/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*jslint devel: true*/
/*global $, tizen, App  */

/**
 * This file acts as a loader for the application and its dependencies
 *
 * First, the 'app.js' script is loaded .
 * Then, scripts defined in 'app.requires' are loaded.
 * Finally, the app is initialised - the app is instantiated ('app = new App()')
 * and 'app.init()' is called.
 */


var app = null;

(function start() { // strict mode wrapper
    'use strict';

    ({
        /**
         * Loader init - load the App constructor
         */
        init: function init() {
            var self = this;
            $.getScript('js/app.js')
                .done(function done() {
                    // once the app is loaded, create the app object
                    // and load the libraries
                    app = new App();
                    self.loadLibs();
                })
                .fail(this.onGetScriptError);
        },

        /**
         * Load dependencies
         */
        loadLibs: function loadLibs() {
            var loadedLibs = 0;
            if ($.isArray(app.requires)) {
                $.each(app.requires, function load(index, filename) {
                    $.getScript(filename)
                        .done(function done() {
                            loadedLibs += 1;
                            if (loadedLibs >= app.requires.length) {
                                // All dependencies are loaded
                                // initialise the app
                                app.init();
                            }
                        })
                        .fail(this.onGetScriptError);
                });
            }
        },

        /**
         * Handle ajax errors
         */
        onGetScriptError: function onGetScriptError(
            e,
            jqxhr,
            setting,
            exception
        ) {
            app.ui.alertPopup('An error occurred: ' + e.message);
        }
    }).init(); // run the loader
}());
