/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.web.eplugin.communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.dynamicanalysis.ide.web.eplugin.DALog;
import org.tizen.dynamicanalysis.ide.web.eplugin.communication.OpenEditManager;
import org.tizen.dynamicanalysis.ide.web.eplugin.launch.CheckPointInfo;
import org.tizen.dynamicanalysis.ide.web.eplugin.launch.ProjectType;
import org.tizen.dynamicanalysis.ide.web.eplugin.nl.Labels;

public class DAServerManager
extends Thread {
    private static final int MAXBUFSIZE = 1024;
    private static DAServerManager instance;
    private Socket ideClientSocket = null;
    private DataOutputStream outputStream = null;
    private int serverPort = 0;
    private boolean reservedTraceApplication = false;
    private String reservedDeviceName = "";
    private ProjectType reservedProjectType;
    private String reservedBinaryOfTarget;
    private String reservedExecutablePath;
    private List<String> reservedLocalPackagePathList;
    private String LOCAL_HOST = "127.0.0.1";
    private Set<CheckPointInfo> reservedInteractiveInfoSet;
    private String reservedDebugBinaryPath;
    private final String IDE_DA_COMMUNICATION_TYPE_1 = "STATUS";
    private final String IDE_DA_COMMUNICATION_TYPE_2 = "RUN";
    private final String IDE_DA_COMMUNICATION_TYPE_3 = "SOURCE";
    private final String IDE_DA_COMMUNICATION_SEPARATOR = "`,";
    private final String IDE_DA_COMMUNICATION_TYPE_1_RECORD = "record";
    private final String IDE_DA_COMMUNICATION_TYPE_1_STOP = "stop";
    private final String IDE_DA_COMMUNICATION_PROJECT_TYPE = "web";
    private static final String DANAIC_ANALYZER = "dynamic-analyzer";
    private static final String SAVE = "save";
    private static final String ACTIVE_DA_PLUGIN = "active_da_plugin";
    private final String CURRENT_ACTIVE_IDE_PORT = "current_active_ide_port";
    private static boolean recvDAReadyStatus;

    static {
        recvDAReadyStatus = false;
    }

    public static synchronized DAServerManager getInstance() {
        if (instance == null) {
            instance = new DAServerManager();
        }
        return instance;
    }

    private DAServerManager() {
    }

    public Socket getClientSocket() {
        return this.ideClientSocket;
    }

    public void reserveTraceApplication(String deviceName, ProjectType projectType, String binaryOfTarget, String executablePath, List<String> localPackagePathList, Set<CheckPointInfo> interactiveInfoSet, String debugBinaryPath) {
        this.reservedTraceApplication = true;
        this.reservedDeviceName = deviceName;
        this.reservedProjectType = projectType;
        this.reservedBinaryOfTarget = binaryOfTarget;
        this.reservedExecutablePath = executablePath;
        this.reservedLocalPackagePathList = localPackagePathList;
        this.reservedInteractiveInfoSet = interactiveInfoSet;
        this.reservedDebugBinaryPath = debugBinaryPath;
    }

    @Override
    public void run() throws IndexOutOfBoundsException {
        if (this.checkInstalledTizenSDK()) {
            while (true) {
                this.resetSocket();
                DALog.printLog(" Start IDE");
                while (!DAServerManager.checkDASingleton()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        DALog.printLog("IDE is terminated!");
                    }
                }
                if (!this.readActiveServerPort()) {
                    DALog.printLog("Failed Read Active IDE Port");
                    continue;
                }
                if (!this.setServerSocket()) {
                    DALog.printLog("Failed Connect IDE Socket");
                    continue;
                }
                DALog.printLog("Connected DA");
                this.checkReservedTraceApplication();
                this.waitingDataReceive();
                DALog.printLog("Disconneced DA");
                this.resetSocket();
            }
        }
        DALog.printLog("failed - Tizen SDK is not installed ");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkDASingleton() {
        boolean isActiveDA = false;
        StringBuffer savePath = new StringBuffer();
        savePath.append(InstallPathConfig.getUserDataPath()).append(File.separatorChar).append(DANAIC_ANALYZER).append(File.separatorChar).append(SAVE).append(File.separatorChar);
        File folder = new File(savePath.toString());
        if (!folder.exists() && !folder.mkdirs()) {
            return false;
        }
        savePath.append(ACTIVE_DA_PLUGIN);
        FileLock fileLock = null;
        AbstractInterruptibleChannel fchannel = null;
        File file = new File(savePath.toString());
        try {
            try {
                fchannel = new RandomAccessFile(file, "rw").getChannel();
                fileLock = ((FileChannel)fchannel).tryLock();
                if (fileLock != null) return isActiveDA;
                isActiveDA = true;
                return isActiveDA;
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                if (fchannel == null) return isActiveDA;
                try {
                    fchannel.close();
                    return isActiveDA;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return isActiveDA;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fchannel == null) return isActiveDA;
                try {
                    fchannel.close();
                    return isActiveDA;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return isActiveDA;
            }
            catch (OverlappingFileLockException e) {
                DALog.printLog(e);
                if (fchannel == null) return isActiveDA;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    fchannel.close();
                    return isActiveDA;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return isActiveDA;
            }
        }
        finally {
            if (fchannel != null) {
                try {
                    fchannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean checkInstalledTizenSDK() {
        String installPath = InstallPathConfig.getUserDataPath();
        File logs = new File(installPath.toString());
        return logs.exists();
    }

    private void checkReservedTraceApplication() {
        if (this.reservedTraceApplication) {
            this.reservedTraceApplication = false;
            this.runTraceApplication(this.reservedDeviceName, this.reservedProjectType, this.reservedBinaryOfTarget, this.reservedExecutablePath, this.reservedLocalPackagePathList, this.reservedInteractiveInfoSet, this.reservedDebugBinaryPath);
        }
    }

    private void waitingDataReceive() {
        int dataSize = 0;
        try {
            byte[] arr;
            InputStream in = this.ideClientSocket.getInputStream();
            while ((dataSize = in.read(arr = new byte[1024])) > 0) {
                String msg = new String(arr);
                this.commandReceiveMessage(msg);
                Object var3_3 = null;
            }
        }
        catch (IOException iOException) {
            DALog.printLog("DAServerManager - waitingDataReceive - IOException");
        }
    }

    public String getPortFile() {
        StringBuffer savePath = new StringBuffer();
        savePath.append(InstallPathConfig.getUserDataPath()).append(File.separatorChar).append(DANAIC_ANALYZER).append(File.separatorChar).append(SAVE);
        File saveDir = new File(savePath.toString());
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        savePath.append(File.separatorChar).append("current_active_ide_port");
        return savePath.toString();
    }

    private boolean readActiveServerPort() {
        boolean bSuccess = true;
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            try {
                fis = new FileInputStream(this.getPortFile());
                dis = new DataInputStream(fis);
                try {
                    this.serverPort = ((DataInputStream)dis).readInt();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bSuccess = false;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                bSuccess = false;
                try {
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                    if (dis != null) {
                        dis.close();
                        dis = null;
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                if (dis != null) {
                    dis.close();
                    dis = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bSuccess;
    }

    private boolean setServerSocket() {
        try {
            this.ideClientSocket = new Socket(Proxy.NO_PROXY);
            InetSocketAddress socketAddress = new InetSocketAddress(this.LOCAL_HOST, this.serverPort);
            this.ideClientSocket.connect(socketAddress);
        }
        catch (UnknownHostException e) {
            DALog.printLog(e);
            this.ideClientSocket = null;
            return false;
        }
        catch (IOException e) {
            DALog.printLog(e);
            this.ideClientSocket = null;
            return false;
        }
        catch (IllegalArgumentException e) {
            DALog.printLog(e);
            this.ideClientSocket = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDAStatusMessage() {
        this.setRecvDAReadyStatus(false);
        StringBuffer command = new StringBuffer();
        command.append("STATUS").append("`,").append("web").append("`,").append("");
        try {
            this.sendData(command.toString());
        }
        catch (IOException iOException) {
            DALog.printLog("DAServerManager - sendDAStatusMessage - IOException");
            DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_FAIL_TO_LAUNCH_PROJECT);
        }
        DAServerManager dAServerManager = this;
        synchronized (dAServerManager) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                DALog.printLog("DAServerManager - sendDAStatusMessage - getRecvDAReadyStatus().wait(10000)");
                DALog.printLog(e);
            }
        }
        return this.getRecvDAReadyStatus();
    }

    public void runTraceApplication(String strDevice, ProjectType projectType, String binaryOfTarget, String executablePath, List<String> localPackagePathList, Set<CheckPointInfo> interactiveInfoSet, String debugBinaryPath) {
        StringBuffer command = new StringBuffer();
        command.append("RUN").append("`,").append(strDevice).append("`,").append(projectType.ordinal()).append("`,").append(binaryOfTarget).append("`,").append(executablePath);
        if (localPackagePathList != null) {
            int i = 0;
            while (i < localPackagePathList.size()) {
                command.append("`,").append(localPackagePathList.get(i));
                ++i;
            }
        }
        if (interactiveInfoSet != null) {
            command.append("`,").append(interactiveInfoSet.size());
            command.append("`,").append(debugBinaryPath);
            for (CheckPointInfo info : interactiveInfoSet) {
                command.append("`,").append(info.getSourcePath());
                command.append("`,").append(info.getVariableName());
                command.append("`,").append(info.getLine());
                command.append("`,").append(info.getArrayCount());
                command.append("`,").append(info.getCheckLocation());
            }
        }
        try {
            this.sendData(command.toString());
        }
        catch (IOException iOException) {
            DALog.printLog("DAServerManager - runTraceApplication - IOException");
            DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_FAIL_TO_LAUNCH_PROJECT);
        }
    }

    private void commandReceiveMessage(String msg) {
        DALog.printLog("commandReceiveMessage : " + msg);
        String[] msgArray = msg.split("`,");
        int size = msgArray.length;
        if (size == 3) {
            if (msgArray[0].equals("STATUS")) {
                this.setDAStatus(msgArray);
            } else if (msgArray[0].equals("SOURCE")) {
                this.viewSouceLine(msgArray);
            } else {
                DALog.printLog("receive message is not valid type");
            }
        } else {
            DALog.printLog("receive message is not valid ");
        }
    }

    private synchronized void setDAStatus(String[] msgArray) {
        if (msgArray[1].equals("record")) {
            this.setRecvDAReadyStatus(false);
        } else if (msgArray[1].equals("stop")) {
            this.setRecvDAReadyStatus(true);
        } else {
            DALog.printLog("receive message is not valid");
        }
        this.notify();
    }

    private void viewSouceLine(String[] msgArray) {
        String srcpath = msgArray[1];
        String strSourceLine = msgArray[2].trim();
        int nline = Integer.parseInt(strSourceLine);
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new OpenEditManager(srcpath, nline));
    }

    private boolean sendData(String msg) throws IOException {
        DALog.printLog("SendData " + msg);
        boolean bSuccess = true;
        try {
            try {
                if (this.ideClientSocket != null) {
                    this.outputStream = new DataOutputStream(this.ideClientSocket.getOutputStream());
                    this.outputStream.writeUTF(msg);
                    this.outputStream.flush();
                }
            }
            catch (IOException e) {
                bSuccess = false;
                DALog.printLog(e);
                bSuccess = false;
            }
        }
        finally {
            bSuccess = false;
        }
        return bSuccess;
    }

    private void resetSocket() {
        this.ideClientSocket = null;
        this.outputStream = null;
        if (this.ideClientSocket != null) {
            try {
                this.ideClientSocket.close();
                this.ideClientSocket = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getRecvDAReadyStatus() {
        return recvDAReadyStatus;
    }

    public void setRecvDAReadyStatus(boolean status) {
        recvDAReadyStatus = status;
    }
}

