/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.templateengine;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.project.template.pages.ProjectPropertyPage;
import org.tizen.nativeappcommon.templateengine.Messages;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateModel;
import org.w3c.dom.Element;

public class TizenTemplateProcessParser {
    private static final Logger logger = LoggerFactory.getLogger(TizenTemplateProcessParser.class);
    public static final String TAG_SLPPROPERTY = "slp-property";
    public static final String TAG_PROPERTYGROUP = "property-group";
    public static final String TAG_SAMPLE = "sample-name";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_DESC = "sample-description";
    public static final String TAG_PROJTYPE = "project-type";
    public static final String TAG_PROCESS = "process";
    public static final String TAG_TYPE = "type";
    public static final String TAG_WIZARD_ICON = "wizard-icon";
    public static final String TAG_EXTRATYPE = "extra-type";
    public static final String ATTRIBUTE_CATEGORY_NAME = "name";

    public static TemplateDescriptor createTemplateDesc(File sampleFile) {
        URL templateURL = null;
        TemplateDescriptor descriptor = null;
        try {
            templateURL = sampleFile.toURI().toURL();
            descriptor = new TemplateDescriptor(templateURL, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return descriptor;
    }

    public static Element getElementFromTag(Element element, String tag) {
        List subElements;
        if (element != null && (subElements = TemplateEngine.getChildrenOfElementByTag((Element)element, (String)tag)) != null && subElements.size() > 0) {
            return (Element)subElements.get(0);
        }
        return null;
    }

    public static List<Element> getElementsFromTag(Element element, String tag) {
        if (element != null) {
            return TemplateEngine.getChildrenOfElementByTag((Element)element, (String)tag);
        }
        return new ArrayList<Element>();
    }

    public static String getTextContextFromElement(Element element, String tag) {
        List subElements;
        if (element != null && (subElements = TemplateEngine.getChildrenOfElementByTag((Element)element, (String)tag)) != null && subElements.size() > 0) {
            return ((Element)subElements.get(0)).getTextContent();
        }
        return null;
    }

    public static IWizardPage getMainPage() {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = MBSCustomPageManager.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof TizenMainWizardPage) {
                return (TizenMainWizardPage)page;
            }
            if (page instanceof ProjectPropertyPage) {
                return (ProjectPropertyPage)page;
            }
            ++n2;
        }
        return null;
    }

    public static ProfileInfo getProfileInfoFromSelectedTemplate() {
        IWizardPage mainPage = TizenTemplateProcessParser.getMainPage();
        if (mainPage != null) {
            TizenNativeTemplateModel selectedTemplate = null;
            if (mainPage instanceof TizenMainWizardPage) {
                selectedTemplate = ((TizenMainWizardPage)mainPage).getSelectedTemplate();
            } else if (mainPage instanceof ProjectPropertyPage) {
                selectedTemplate = ((ProjectPropertyPage)mainPage).getSelectedTemplate();
            }
            if (selectedTemplate != null) {
                return selectedTemplate.getProfileInfo();
            }
        }
        return null;
    }

    public static IPath getSelectedSampleLocationFromMainPage(String lang) {
        IWizardPage mainPage = TizenTemplateProcessParser.getMainPage();
        if (mainPage != null) {
            TizenNativeTemplateModel selectedTemplate = null;
            if (mainPage instanceof TizenMainWizardPage) {
                selectedTemplate = ((TizenMainWizardPage)mainPage).getSelectedTemplate();
            } else if (mainPage instanceof ProjectPropertyPage) {
                selectedTemplate = ((ProjectPropertyPage)mainPage).getSelectedTemplate();
            }
            if (selectedTemplate != null) {
                return selectedTemplate.getSpecXmlPath();
            }
        }
        if (lang.equals("cpp")) {
            return new Path(InstallPathConfig.getSamplesPath()).append("native/cpp/Template/Tizen Native/Empty Application/empty").append("sample.xml");
        }
        if (lang.equals("core")) {
            return new Path(InstallPathConfig.getSamplesPath()).append("native/c/empty").append("sample.xml");
        }
        logger.error(Messages.TizenTemplateProcessParser_CannotMakeUnittestProject2);
        return null;
    }
}

