/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.wizards.model;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTreeGroupModel;

public abstract class TizenNativeAbstractTreeModel {
    private final Logger logger = LoggerFactory.getLogger(TizenNativeAbstractTreeModel.class);
    private String name;
    private List<TizenNativeTreeGroupModel> entries;

    public TizenNativeAbstractTreeModel(String name, List<TizenNativeTreeGroupModel> entries) {
        this.name = name;
        if (entries == null) {
            this.logger.error("Argument entries is not initialized.");
        } else {
            this.entries = entries;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TizenNativeTreeGroupModel> getEntries() {
        return this.entries;
    }

    public void addEntry(TizenNativeTreeGroupModel entry) {
        int i = 0;
        while (i < this.entries.size()) {
            TizenNativeTreeGroupModel targetEntry = this.entries.get(i);
            if (targetEntry.getName().compareTo(entry.getName()) > 0) {
                this.entries.add(i, entry);
                return;
            }
            ++i;
        }
        this.entries.add(entry);
    }

    public TizenNativeTreeGroupModel getEntry(String name) {
        for (TizenNativeTreeGroupModel entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }
}

