/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.wizards;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.PlatformTemplateLoader;
import org.tizen.common.ui.wizards.TizenCommonNewWizardPage;
import org.tizen.common.ui.wizards.TizenWizardThread;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.common.ui.wizards.model.Template;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.EntryDescriptorPlatformMap;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TemplateTizenNewWizard;
import org.tizen.nativeappcommon.wizards.TizenManagedBuildWizard;
import org.tizen.nativeappcommon.wizards.WizardConstants;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateModel;
import org.tizen.nativeappcommon.wizards.ui.TizenNativePWComposite;
import org.w3c.dom.Element;

public class TizenMainWizardPage
extends TizenCommonNewWizardPage
implements IWizardItemsListListener {
    protected final int[] selectedTabColor = new int[]{104, 151, 239};
    protected Composite toolchainComposite;
    private static final int MIN_HEIGHT = 600;
    private static final int MIN_WIDTH = 763;
    protected final String DEFAULT_TAB = Messages.TizenMainWizardPage_Category_Uncategorized;
    protected final String DEFAULT_CATEGORY = "Other";
    public static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.CDTWizard";
    public static final String ELEMENT_NAME = "wizard";
    public static final String CLASS_NAME = "class";
    public static final String DEFAULT_WIZARD_ICON = "icons/wizard/default_icon.png";
    public List<EntryDescriptor> managedBuildWizardItems = new ArrayList<EntryDescriptor>();
    public static final int HORIZONTAL_COMPOSITE = 875;
    public static final int VERTICAL_COMPOSITE = 431;
    private static final Image IMG_CATEGORY = CDTSharedImages.getImage((String)"icons/tobj16/fldr_obj.png");
    private static final Image IMG_ITEM = CDTSharedImages.getImage((String)"icons/tobj16/variable_obj.png");
    public static final String DESC = "EntryDescriptor";
    public CWizardHandler h_selected = null;

    protected IPath getTemplatePath() {
        return null;
    }

    protected List<EntryDescriptor> updateData(Composite right, IWizardItemsListListener ls, IWizard wizard) {
        return null;
    }

    public TizenMainWizardPage() {
        this("TizenMainWizardPage");
    }

    public TizenMainWizardPage(String pageName) {
        super(pageName);
    }

    public TizenMainWizardPage(String pageName, String appType) {
        super(pageName, appType);
    }

    public void initManagedBuildWizardItems() {
        if (this.managedBuildWizardItems == null || this.managedBuildWizardItems.size() < 1) {
            this.managedBuildWizardItems = this.initManagedBuildWizardItems(this.toolchainComposite, this, this.getWizard());
            if (this.managedBuildWizardItems == null) {
                new TizenWizardThread().wizardErrorDialog(Messages.TizenMainWizardPage_7);
                return;
            }
        }
    }

    protected Category createTemplateTabModel() {
        Category root = super.createTemplateTabModel();
        this.toolchainComposite = new Composite(this.fComposite, 0);
        SWTUtil.setGridLayoutData((Control)this.toolchainComposite, (int)0, (int)0, (int)-1, (int)-1, (int)0);
        this.initManagedBuildWizardItems();
        UserLogger.start((String)"native.wizard", (String)"native.wizard.model");
        return root;
    }

    public void createEntryDescriptor(TizenNativeTemplateModel template) {
        this.initManagedBuildWizardItems();
        TemplateTizenNewWizard templateTienCoreNewWizard = new TemplateTizenNewWizard();
        EntryDescriptor entryDes = null;
        if (template.getProjectType() == null) {
            TemplateDescriptor templateDesc = TizenTemplateProcessParser.createTemplateDesc(new File(template.getSamplePath()));
            if (templateDesc == null) {
                this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_1);
                return;
            }
            entryDes = templateTienCoreNewWizard.getEntryDesc(templateDesc, template.getName());
        } else {
            entryDes = templateTienCoreNewWizard.getEntryDesc(template.getProjectType(), template.getName());
        }
        if (entryDes == null) {
            this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_2);
            return;
        }
        boolean found2 = false;
        if (entryDes.getParentId() != null) {
            boolean found1 = false;
            for (EntryDescriptor ed2 : this.managedBuildWizardItems) {
                if (!ed2.getId().equals(entryDes.getParentId())) continue;
                found2 = true;
                found1 = true;
                entryDes.setParentId(null);
                entryDes.setPath(String.valueOf(ed2.getId()) + "/" + entryDes.getId());
                entryDes.setParent(ed2);
                if (ed2.getHandler() == null || !ed2.getHandler().isApplicable(entryDes)) break;
                entryDes.setHandler(ed2.getHandler());
                break;
            }
            if (!found1) {
                this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_2);
                return;
            }
            template.setEntryDescriptor(entryDes);
            template.setSpecXmlPath((IPath)new Path(template.getTemplateDescMetaInfo().getDefUrl()));
        }
        if (!found2) {
            this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_1);
            return;
        }
        this.switchTo(entryDes.getHandler(), entryDes);
    }

    public List<EntryDescriptor> initManagedBuildWizardItems(Composite right, IWizardItemsListListener ls, IWizard wizard) {
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        TizenManagedBuildWizard tizenManagedBuildWizard = new TizenManagedBuildWizard();
        tizenManagedBuildWizard.setDependentControl(right, ls);
        EntryDescriptor[] entryDescriptorArray = tizenManagedBuildWizard.createItems(true, wizard);
        int n = entryDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryDescriptor ed = entryDescriptorArray[n2];
            items.add(ed);
            ++n2;
        }
        int i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                --i;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        if (items == null || items.size() < 1) {
            return null;
        }
        return items;
    }

    protected void buildTab(PWTab tab, String name, Category category) {
        TizenNativePWComposite pwComposite = new TizenNativePWComposite(name, category, this);
        tab.add((PWWidget)pwComposite);
    }

    public IPath getSelectedSampleLocation() {
        return this.getSelectedTemplate().getSpecXmlPath();
    }

    protected String getSelectedProjectType() {
        if (this.getSelectedTemplate() == null) {
            return null;
        }
        EntryDescriptor ed = this.getSelectedTemplate().getEntryDescriptor();
        EntryDescriptor pEd = ed.getParent();
        return pEd.getId();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public TizenNativeTemplateModel getSelectedTemplate() {
        return (TizenNativeTemplateModel)((Object)this.fSelectedTemplate);
    }

    public void setSelectedTemplate(Object selectedTemplate) {
        super.setSelectedTemplate(selectedTemplate);
    }

    protected void setMinimumSize(Composite parent) {
        Shell shell = this.getShell(parent);
        if (shell != null) {
            shell.setMinimumSize(new Point(763, 600));
        }
    }

    private Shell getShell(Composite parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Shell) {
            return (Shell)parent;
        }
        return this.getShell(parent.getParent());
    }

    public void switchTo(CWizardHandler h, EntryDescriptor ed) {
        if (h == null) {
            h = ed.getHandler();
        }
        if (ed.isCategory()) {
            h = null;
        }
        try {
            if (h != null) {
                h.initialize(ed);
            }
        }
        catch (CoreException coreException) {
            h = null;
        }
        if (this.h_selected != null) {
            this.h_selected.handleUnSelection();
        }
        this.h_selected = h;
        if (h == null) {
            return;
        }
        this.h_selected.handleSelection();
        this.h_selected.saveState();
        this.h_selected.setSupportedOnly(true);
    }

    public URI getProjectLocation() {
        if (this.projectCheckViewer != null) {
            if (this.projectCheckViewer.isDefault()) {
                return null;
            }
            return this.projectCheckViewer.getLocationURI();
        }
        return this.useDefaults() ? null : this.getLocationURI();
    }

    public IPath getLocationPath() {
        if (this.projectCheckViewer != null) {
            return this.projectCheckViewer.getLocationPath();
        }
        return super.getLocationPath();
    }

    public boolean validatePage() {
        String prjName = this.getProjectName();
        if (this.projectCheckViewer == null) {
            String msg = TizenMainWizardPage.validateProjectName(prjName, ResourcesPlugin.getWorkspace());
            if (!StringUtil.isEmpty((CharSequence)msg)) {
                this.setErrorMessage(msg);
                return false;
            }
            if (prjName.indexOf(35) >= 0 || prjName.indexOf(45) >= 0) {
                this.setErrorMessage(Messages.TizenMainWizardPage_3);
                return false;
            }
            if (!super.validatePage()) {
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public static String validateProjectName(String projName, IWorkspace workspace) {
        IStatus nameStatus;
        if (workspace != null && !(nameStatus = workspace.validateName(projName, 4)).isOK()) {
            return nameStatus.getMessage();
        }
        if (WizardConstants.CPP_KEYWORDS.contains(projName)) {
            return NLS.bind((String)Messages.TizenMainWizardPage_isCppKeyword, (Object)projName);
        }
        if (projName.length() > 50) {
            return NLS.bind((String)Messages.WizardConstants_6, (Object)51);
        }
        if (projName.length() < 3) {
            return NLS.bind((String)Messages.WizardConstants_5, (Object)2);
        }
        if (!projName.matches(WizardConstants.CPP_NAME_PATTERN)) {
            return Messages.WizardConstants_2;
        }
        return "";
    }

    public boolean checkExisitingProject(String prjName) {
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(prjName) != null) {
            this.setErrorMessage(Messages.WizardConstants_3);
            return false;
        }
        return true;
    }

    public List filterItems(List items) {
        return items;
    }

    public void setVisible(boolean visible) {
        this.fComposite.setVisible(visible);
    }

    private IPath getTemplatePath(ProfileInfo platformInfo) {
        return new Path(InstallPathConfig.getSamplesPath((ProfileInfo)platformInfo, (String)platformInfo.getLatestPlatformVersion())).append("native").append(this.getPathOfTemplate());
    }

    protected String getPathOfTemplate() {
        return "cpp";
    }

    protected Category createModelRoot(List<EntryDescriptor> eds) {
        boolean found3 = false;
        try {
            for (EntryDescriptor ed : eds) {
                TemplateDescriptor templateDesc;
                if (ed.getParentId() == null) continue;
                boolean found1 = false;
                String tempPath = ed.getPath();
                for (EntryDescriptor ed2 : eds) {
                    if (!ed2.getId().equals(ed.getParentId())) continue;
                    found3 = true;
                    found1 = true;
                    ed.setParentId(null);
                    ed.setPath(String.valueOf(ed2.getId()) + "/" + ed.getId());
                    ed.setParent(ed2);
                    if (ed2.getHandler() == null || !ed2.getHandler().isApplicable(ed)) break;
                    ed.setHandler(ed2.getHandler());
                    break;
                }
                if (!found1) continue;
                ProfileInfo platformInfo = EntryDescriptorPlatformMap.getInstance().get(ed);
                if (platformInfo == null) {
                    this.logger.debug("EntryDescriptionPlatformMap doesn't have a ProfileInfo: {}", (Object)ed.getName());
                    continue;
                }
                List<Object> categories = null;
                IPath descPath = null;
                if (tempPath == null) {
                    categories = new ArrayList<String>();
                    categories.add(this.DEFAULT_TAB);
                    categories.add("Other");
                    descPath = this.getTemplatePath(InstallPathConfig.getLatestProfileInfo()).append(ed.getName());
                } else {
                    categories = Arrays.asList(tempPath.split("/"));
                    descPath = this.getTemplatePath(platformInfo).append(tempPath).append(ed.getName());
                }
                IPath samplePath = descPath.append("sample.xml");
                File sampleFile = samplePath.toFile();
                if (!sampleFile.exists() || (templateDesc = TizenTemplateProcessParser.createTemplateDesc(sampleFile)) == null) continue;
                Element root = templateDesc.getRootElement();
                Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag(root, "slp-property");
                slpPropertyElement = TizenTemplateProcessParser.getElementFromTag(slpPropertyElement, "property-group");
                String projDesc = TizenTemplateProcessParser.getTextContextFromElement(slpPropertyElement, "sample-description");
                String label = TizenTemplateProcessParser.getTextContextFromElement(slpPropertyElement, "sample-name");
                String icon = TizenTemplateProcessParser.getTextContextFromElement(slpPropertyElement, "wizard-icon");
                String category = TizenTemplateProcessParser.getTextContextFromElement(slpPropertyElement, "category");
                Category entry = this.addChildEntry(this.fModel, platformInfo, categories);
                IPath iconPath = icon != null ? descPath.append(icon) : null;
                IPath templatePath = this.getTemplatePath();
                descPath = projDesc != null ? descPath.append(projDesc) : (templatePath != null ? templatePath.append("description.xml") : null);
                TizenNativeTemplateModel template = new TizenNativeTemplateModel(platformInfo, label, ed, descPath, samplePath, iconPath, category);
                entry.addTemplate((Template)template);
            }
            if (!found3) {
                this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_1);
            }
            Category category = this.fModel;
            return category;
        }
        finally {
            EntryDescriptorPlatformMap.getInstance().remove();
        }
    }

    protected Category addChildEntry(Category rootModel, ProfileInfo platformInfo, List<String> categories) {
        Category target = null;
        String rootName = categories.get(0);
        target = rootModel.find(rootName);
        if (target == null) {
            target = new Category(rootModel, rootName, "uncategorized.png");
        }
        PlatformTemplateLoader.mapToPlatformName(categories, (ProfileInfo)platformInfo);
        int i = 1;
        while (i < categories.size()) {
            Category subTarget = target.find(categories.get(i));
            if (subTarget == null) {
                subTarget = new Category(target, categories.get(i), null);
            }
            target = subTarget;
            ++i;
        }
        if (categories.size() < 2) {
            Category subTarget = target.find("Other");
            if (subTarget == null) {
                subTarget = new Category(target, "Other", null);
            }
            target = subTarget;
        }
        return target;
    }

    private static String getParentText(TreeItem item) {
        if (item == null || item.getParentItem() == null) {
            return "";
        }
        return item.getParentItem().getText();
    }

    private static TreeItem findItem(Tree tree, String label, String parentLabel) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeItem foundItem = TizenMainWizardPage.findTreeItem(item, label, parentLabel);
            if (foundItem != null) {
                return foundItem;
            }
            ++n2;
        }
        return null;
    }

    private static TreeItem findTreeItem(TreeItem item, String label, String parentLabel) {
        if (item.getText().equals(label) && TizenMainWizardPage.getParentText(item).equals(parentLabel)) {
            return item;
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            TreeItem foundItem = TizenMainWizardPage.findTreeItem(child, label, parentLabel);
            if (foundItem != null) {
                return foundItem;
            }
            ++n2;
        }
        return null;
    }

    private static void addItemsToTree(Tree tree, List<EntryDescriptor> items) {
        boolean found;
        ArrayList<TreeItem> placedTreeItemsList = new ArrayList<TreeItem>(items.size());
        ArrayList<EntryDescriptor> placedEntryDescriptorsList = new ArrayList<EntryDescriptor>(items.size());
        for (EntryDescriptor wd : items) {
            if (wd.getParentId() != null) continue;
            wd.setPath(wd.getId());
            TreeItem ti = new TreeItem(tree, 0);
            ti.setText(TextProcessor.process((String)wd.getName()));
            ti.setData((Object)wd.getHandler());
            ti.setData(DESC, (Object)wd);
            ti.setImage(TizenMainWizardPage.calcImage(wd));
            placedTreeItemsList.add(ti);
            placedEntryDescriptorsList.add(wd);
        }
        do {
            found = false;
            block2: for (EntryDescriptor wd1 : items) {
                if (wd1.getParentId() == null) continue;
                int i = 0;
                while (i < placedEntryDescriptorsList.size()) {
                    EntryDescriptor wd2 = (EntryDescriptor)placedEntryDescriptorsList.get(i);
                    if (wd2.getId().equals(wd1.getParentId())) {
                        found = true;
                        wd1.setParentId(null);
                        CWizardHandler h = wd2.getHandler();
                        if (h == null && wd1.getHandler() == null && !wd1.isCategory()) continue block2;
                        wd1.setPath(String.valueOf(wd2.getPath()) + "/" + wd1.getId());
                        wd1.setParent(wd2);
                        if (h != null) {
                            if (wd1.getHandler() == null && !wd1.isCategory()) {
                                wd1.setHandler((CWizardHandler)h.clone());
                            }
                            if (!h.isApplicable(wd1)) continue block2;
                        }
                        TreeItem p = (TreeItem)placedTreeItemsList.get(i);
                        TreeItem ti = new TreeItem(p, 0);
                        ti.setText(wd1.getName());
                        ti.setData((Object)wd1.getHandler());
                        ti.setData(DESC, (Object)wd1);
                        ti.setImage(TizenMainWizardPage.calcImage(wd1));
                        placedTreeItemsList.add(ti);
                        placedEntryDescriptorsList.add(wd1);
                        continue block2;
                    }
                    ++i;
                }
            }
        } while (found);
    }

    public static CWizardHandler updateData(Tree tree, Composite right, Button show_sup, IWizardItemsListListener ls, IWizard wizard) {
        TreeItem[] selection = tree.getSelection();
        TreeItem selectedItem = selection.length > 0 ? selection[0] : null;
        String savedLabel = selectedItem != null ? selectedItem.getText() : null;
        String savedParentLabel = TizenMainWizardPage.getParentText(selectedItem);
        tree.removeAll();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        List<Object> items = new ArrayList<EntryDescriptor>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensions[i].getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(ELEMENT_NAME)) {
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)element.createExecutableExtension(CLASS_NAME);
                    }
                    catch (CoreException e) {
                        System.out.println("Cannot create ICProjectTypeHandler: " + e.getLocalizedMessage());
                        return null;
                    }
                    if (w == null) {
                        return null;
                    }
                    w.setDependentControl(right, ls);
                    EntryDescriptor[] entryDescriptorArray = w.createItems(show_sup.getSelection(), wizard);
                    int n3 = entryDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        EntryDescriptor ed = entryDescriptorArray[n4];
                        items.add(ed);
                        ++n4;
                    }
                }
                ++n2;
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                items.add(0, ed);
                break;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        TizenMainWizardPage.addItemsToTree(tree, items);
        if (tree.getItemCount() > 0) {
            TreeItem target = null;
            if (savedLabel != null) {
                target = TizenMainWizardPage.findItem(tree, savedLabel, savedParentLabel);
            }
            if (target == null && (target = tree.getItem(0)).getItemCount() != 0) {
                target = target.getItem(0);
            }
            tree.setSelection(target);
            return (CWizardHandler)target.getData();
        }
        return null;
    }

    public void toolChainListChanged(int count) {
        this.setPageComplete(this.validatePage());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    private static Image calcImage(EntryDescriptor ed) {
        if (ed.getImage() != null) {
            return ed.getImage();
        }
        if (ed.isCategory()) {
            return IMG_CATEGORY;
        }
        return IMG_ITEM;
    }
}

