/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.PlatformTemplateLoader;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.EntryDescriptorPlatformMap;
import org.w3c.dom.Element;

public class TemplateTizenNewWizard
extends CNewWizard {
    public static final String LOCATION_CPP_EMPTYPROJECT = "native/cpp/Template/Tizen Native/Empty Application/empty";
    public static final String LOCATION_C_EMPTYPROJECT = "native/c/empty";
    public static final String DIR_NATIVE = "native";
    public static final String DIR_TEST = "Template/NativeTest";
    public static final String DIR_UNIT_TEST = "unittest";
    public static final String DIR_CPP = "cpp";
    public static final String DIR_C = "core";
    public static final String APPLICATION_CPP_ID = "TizenCppApplicationProject";
    public static final String APPLICATION_C_ID = "EFLCApplicationProject";
    public static final String FILE_DESC = "description.xml";
    private static final Map<String, String> TIZEN_CORE_PROJECT_TYPE_MAP = new HashMap<String, String>();
    public static final String APP_PROJECT_TYPE = "org.tizen.nativecore.buildArtefactType.app";
    public static final String APP_TEMPLATE_ID = "TizenCoreApplicationProject";
    public static final String APP_CATEGORY = "Application Template";
    public static final String SERVICE_APP_CATEGORY = "Service Application Template";
    public static final String STATIC_PROJECT_TYPE = "org.tizen.nativecore.buildArtefactType.staticLib";
    public static final String STATIC_TEMPLATE_ID = "TizenCoreSimpleStaticLibraryProject";
    public static final String SHARED_PROJECT_TYPE = "org.tizen.nativecore.buildArtefactType.sharedLib";
    public static final String SHARED_TEMPLATE_ID = "TizenCoreSimpleSharedLibraryProject";
    public static final String TIZEN_PLATFORM_ARTIFACT_TYPE = "org.tizen.nativeide.buildArtefactType.platform";
    public static final String TIZEN_PLATFORM_TEMPLATE_ID = "PlatformProject";
    public static final IPath templateCorePath;

    static {
        TIZEN_CORE_PROJECT_TYPE_MAP.put(APP_PROJECT_TYPE, APP_TEMPLATE_ID);
        TIZEN_CORE_PROJECT_TYPE_MAP.put(STATIC_PROJECT_TYPE, STATIC_TEMPLATE_ID);
        TIZEN_CORE_PROJECT_TYPE_MAP.put(SHARED_PROJECT_TYPE, SHARED_TEMPLATE_ID);
        TIZEN_CORE_PROJECT_TYPE_MAP.put(TIZEN_PLATFORM_ARTIFACT_TYPE, TIZEN_PLATFORM_TEMPLATE_ID);
        templateCorePath = new Path(InstallPathConfig.getSamplesPath()).append(DIR_NATIVE).append(DIR_C);
    }

    public EntryDescriptor[] createItems(boolean supportedOnly, IWizard wizard) {
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        PlatformTemplateLoader templateLoader = new PlatformTemplateLoader(DIR_NATIVE + File.separator + DIR_CPP, "sample.xml");
        Map platformTemplateMap = templateLoader.loadPlatformSamples();
        for (ProfileInfo profileInfo : platformTemplateMap.keySet()) {
            IPath rootPath = new Path(InstallPathConfig.getSamplesPath((ProfileInfo)profileInfo, (String)profileInfo.getLatestPlatformVersion())).append(DIR_NATIVE).append(DIR_CPP);
            for (File sampleFile : (List)platformTemplateMap.get(profileInfo)) {
                Path templatePath = new Path(sampleFile.getPath());
                TemplateDescriptor templateDesc = TizenTemplateProcessParser.createTemplateDesc(sampleFile);
                if (templateDesc == null) continue;
                EntryDescriptor entryDes = this.getEntryDesc(templateDesc, templatePath.removeLastSegments(1).lastSegment());
                IPath sourcePath = templatePath.removeLastSegments(1);
                if (sourcePath.segmentCount() != rootPath.segmentCount()) {
                    entryDes.setPath(templatePath.removeLastSegments(2).makeRelativeTo(rootPath).toString());
                } else {
                    entryDes.setPath(null);
                }
                EntryDescriptorPlatformMap.getInstance().put(entryDes, profileInfo);
                items.add(entryDes);
            }
        }
        return items.toArray(new EntryDescriptor[items.size()]);
    }

    public IPath getTemplatePath() {
        return templateCorePath;
    }

    public String getTemplateID(String projTypeName) {
        String templateId = TIZEN_CORE_PROJECT_TYPE_MAP.get(projTypeName);
        return templateId;
    }

    public EntryDescriptor getEntryDesc(TemplateDescriptor descriptor, String label) {
        Element root = descriptor.getRootElement();
        Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag(root, "slp-property");
        slpPropertyElement = TizenTemplateProcessParser.getElementFromTag(slpPropertyElement, "property-group");
        String projTypeName = TizenTemplateProcessParser.getTextContextFromElement(slpPropertyElement, "project-type");
        return new EntryDescriptor(this.getTemplateID(projTypeName), projTypeName, label, false, null, null);
    }

    public EntryDescriptor getEntryDesc(String projectType, String label) {
        if (projectType == null) {
            return null;
        }
        return new EntryDescriptor(this.getTemplateID(projectType), projectType, label, false, null, null);
    }
}

