/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativeappcommon.build.model.DevPackage;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DevPackageManager {
    private static final String ATTR_BASEID = "base_id";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ISFRAMEWORK = "is_framework";
    private static final String ATTR_ISVIRTUAL = "is_virtual";
    private static final String ELEMENT_DEVPKG = "DevPackage";
    private static final String ELEMENT_INCPATH = "include_path";
    private static final String ELEMENT_INCFILE = "include_file";
    private static final String ELEMENT_LIB = "library";
    private static final String ELEMENT_LIB_PATH = "library_path";
    private static final String ELEMENT_RESOURCE = "resource";
    private static final String ELEMENT_DEP = "dependency";
    private static final String ELEMENT_INCPKG = "include_package";
    private static final String ELEMENT_DESC = "description";
    private static final String ELEMENT_CFLAG = "other_cflag";
    private static final String ELEMENT_LFLAG = "other_lflag";
    private static HashMap<String, List<DevPackage>> devListMap = new HashMap();

    public static List<DevPackage> generateDevPackageList(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        Document doc = DevPackageManager.readDoc(path);
        if (doc != null) {
            return DevPackageManager.generateDevPackageList(doc);
        }
        return null;
    }

    private static Document readDoc(String path) {
        File file;
        Document doc;
        block7: {
            char drive;
            if (path == null || path.isEmpty()) {
                return null;
            }
            doc = null;
            if (System.getProperty("os.name").startsWith("Windows") && path.charAt(0) == '/' && path.charAt(2) == '/' && ((drive = path.charAt(1)) >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z')) {
                String _path = String.valueOf(drive) + ":";
                path = _path = _path.concat(path.substring(2));
            }
            if ((file = new File(path)).exists()) break block7;
            return null;
        }
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException : \n" + e);
        }
        catch (SAXException e) {
            System.out.println("SAXException : \n" + e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    private static void addExtDevPackageList(List<DevPackage> list, String baseId, String platformVerPath) {
        String extDevPackageDir = String.valueOf(platformVerPath) + File.separatorChar + "info";
        File dir = new File(extDevPackageDir);
        if (!dir.isDirectory()) {
            return;
        }
        String[] extList = null;
        extList = dir.list();
        if (extList == null) {
            return;
        }
        int i = 0;
        while (i < extList.length) {
            Document doc;
            if (extList[i].endsWith(".xml") && (doc = DevPackageManager.readDoc(String.valueOf(extDevPackageDir) + "/" + extList[i])) != null && doc.getDocumentElement().getAttribute(ATTR_BASEID).equals(baseId)) {
                String path = doc.getDocumentElement().getAttribute(ATTR_PATH);
                NodeList pList = doc.getElementsByTagName(ELEMENT_DEVPKG);
                int j = 0;
                while (j < pList.getLength()) {
                    DevPackage devPackage = DevPackageManager.generateExtDevPackage(pList.item(j), path);
                    if (devPackage != null) {
                        list.add(devPackage);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static DevPackage generateExtDevPackage(Node node, String path) {
        NamedNodeMap attributeMap = node.getAttributes();
        Node nameNode = attributeMap.getNamedItem(ATTR_NAME);
        if (nameNode == null) {
            return null;
        }
        String name = nameNode.getNodeValue();
        boolean isFramework = false;
        Node isFrameworkNode = attributeMap.getNamedItem(ATTR_ISFRAMEWORK);
        if (isFrameworkNode != null) {
            isFramework = isFrameworkNode.getNodeValue().equals("true");
        }
        boolean isVirtual = false;
        Node isVertualNode = attributeMap.getNamedItem(ATTR_ISVIRTUAL);
        if (isVertualNode != null) {
            isVirtual = isVertualNode.getNodeValue().equals("true");
        }
        DevPackage newPackage = new DevPackage(name, isFramework, isVirtual);
        Node subNode = node.getFirstChild();
        while (subNode != null) {
            String value = null;
            if (subNode.getFirstChild() != null) {
                value = subNode.getFirstChild().getNodeValue();
                if (subNode.getNodeName().equals(ELEMENT_INCPATH)) {
                    if (value.startsWith("/")) {
                        newPackage.addIncludePath("/../" + path + value);
                    } else {
                        newPackage.addIncludePath("/../" + value);
                    }
                } else if (subNode.getNodeName().equals(ELEMENT_INCFILE)) {
                    if (value.startsWith("/")) {
                        newPackage.addIncludeFile("/../" + path + value);
                    } else {
                        newPackage.addIncludeFile("/../" + value);
                    }
                } else if (subNode.getNodeName().equals(ELEMENT_LIB_PATH)) {
                    if (value.startsWith("/")) {
                        newPackage.addLibraryPath("/../" + path + value);
                    } else {
                        newPackage.addLibraryPath("/../" + value);
                    }
                } else if (subNode.getNodeName().equals(ELEMENT_LIB)) {
                    if (value.indexOf(47) == -1) {
                        newPackage.addLibrary(value);
                    } else {
                        String libFile;
                        int sep = value.lastIndexOf(47);
                        String dirName = value.substring(0, sep);
                        String baseName = value.substring(sep + 1);
                        if (value.startsWith("/")) {
                            newPackage.addLibraryPath("/../" + path + dirName);
                            libFile = "/../" + path + value;
                        } else {
                            newPackage.addLibraryPath("/../" + dirName);
                            libFile = "/../" + value;
                        }
                        if (libFile.endsWith(".so") || libFile.endsWith(".a")) {
                            newPackage.addLibrary(baseName);
                        }
                        if (libFile.endsWith(".so") || libFile.indexOf(".so.") != -1) {
                            newPackage.addExtendedSharedLibraryFile(libFile);
                        }
                    }
                } else if (subNode.getNodeName().equals(ELEMENT_RESOURCE)) {
                    if (value.startsWith("/")) {
                        newPackage.addResourceFile("/../" + path + value);
                    } else {
                        newPackage.addResourceFile("/../" + value);
                    }
                } else if (subNode.getNodeName().equals(ELEMENT_DEP)) {
                    newPackage.addDepenencyr(value);
                } else if (subNode.getNodeName().equals(ELEMENT_INCPKG)) {
                    newPackage.addIncludePackage(value);
                } else if (subNode.getNodeName().equals(ELEMENT_DESC)) {
                    newPackage.addDescription(value);
                } else if (subNode.getNodeName().equals(ELEMENT_CFLAG)) {
                    newPackage.addOtherCFlag(value);
                } else if (subNode.getNodeName().equals(ELEMENT_LFLAG)) {
                    newPackage.addOtherLFlag(value);
                }
            }
            subNode = subNode.getNextSibling();
        }
        return newPackage;
    }

    private static List<DevPackage> generateDevPackageList(Document doc) {
        ArrayList<DevPackage> result = new ArrayList<DevPackage>();
        NodeList list = doc.getElementsByTagName(ELEMENT_DEVPKG);
        int i = 0;
        while (i < list.getLength()) {
            DevPackage devPackage = DevPackageManager.generateDevPackage(list.item(i));
            if (devPackage != null) {
                result.add(devPackage);
            }
            ++i;
        }
        return result;
    }

    private static DevPackage generateDevPackage(Node node) {
        NamedNodeMap attributeMap = node.getAttributes();
        Node nameNode = attributeMap.getNamedItem(ATTR_NAME);
        if (nameNode == null) {
            return null;
        }
        String name = nameNode.getNodeValue();
        boolean isFramework = false;
        Node isFrameworkNode = attributeMap.getNamedItem(ATTR_ISFRAMEWORK);
        if (isFrameworkNode != null) {
            isFramework = isFrameworkNode.getNodeValue().equals("true");
        }
        boolean isVirtual = false;
        Node isVirtualNode = attributeMap.getNamedItem(ATTR_ISVIRTUAL);
        if (isVirtualNode != null) {
            isVirtual = isVirtualNode.getNodeValue().equals("true");
        }
        DevPackage newPackage = new DevPackage(name, isFramework, isVirtual);
        Node subNode = node.getFirstChild();
        while (subNode != null) {
            String value = null;
            if (subNode.getFirstChild() != null) {
                value = subNode.getFirstChild().getNodeValue();
                if (subNode.getNodeName().equals(ELEMENT_INCPATH)) {
                    newPackage.addIncludePath(value);
                } else if (subNode.getNodeName().equals(ELEMENT_INCFILE)) {
                    newPackage.addIncludeFile(value);
                } else if (subNode.getNodeName().equals(ELEMENT_LIB_PATH)) {
                    newPackage.addLibraryPath(value);
                } else if (subNode.getNodeName().equals(ELEMENT_LIB)) {
                    newPackage.addLibrary(value);
                } else if (subNode.getNodeName().equals(ELEMENT_DEP)) {
                    newPackage.addDepenencyr(value);
                } else if (subNode.getNodeName().equals(ELEMENT_INCPKG)) {
                    newPackage.addIncludePackage(value);
                } else if (subNode.getNodeName().equals(ELEMENT_DESC)) {
                    newPackage.addDescription(value);
                } else if (subNode.getNodeName().equals(ELEMENT_CFLAG)) {
                    newPackage.addOtherCFlag(value);
                } else if (subNode.getNodeName().equals(ELEMENT_LFLAG)) {
                    newPackage.addOtherLFlag(value);
                }
            }
            subNode = subNode.getNextSibling();
        }
        return newPackage;
    }

    public static List<DevPackage> getAllDevPkgs(String targetID) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        List<DevPackage> packageList = null;
        String rootstrapID = sbi.getRootstrapIDFromTargetID(targetID);
        if (devListMap.containsKey(rootstrapID)) {
            packageList = devListMap.get(rootstrapID);
        } else {
            packageList = DevPackageManager.getAllDevPkgsInternal(targetID);
            if (packageList != null) {
                devListMap.put(rootstrapID, packageList);
            }
        }
        if (packageList == null) {
            return new ArrayList<DevPackage>();
        }
        return packageList;
    }

    public static List<String> getAllDevPkgName(String targetID) {
        ArrayList<String> pkgNameList = new ArrayList<String>();
        List<DevPackage> pkgList = DevPackageManager.getAllDevPkgs(targetID);
        for (DevPackage pkg : pkgList) {
            pkgNameList.add(pkg.getName());
        }
        return pkgNameList;
    }

    private static List<DevPackage> getAllDevPkgsInternal(String targetID) {
        List<DevPackage> pkgList;
        block6: {
            Rootstrap r;
            block9: {
                String path;
                block8: {
                    block7: {
                        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
                        pkgList = null;
                        if (!sbi.checkTargetID(targetID)) break block6;
                        PluginManager pm = PluginManager.getInstance();
                        r = pm.getRootstrapByTargetId(targetID);
                        if (r != null) break block7;
                        return null;
                    }
                    path = r.getPropertyValue("DEV_PACKAGE_CONFIG_PATH");
                    if (path != null) break block8;
                    return null;
                }
                pkgList = DevPackageManager.generateDevPackageList(path);
                if (pkgList != null) break block9;
                return null;
            }
            try {
                String rootstrapId = r.getId();
                String platformVerPath = DevPackageManager.getPlatformVerPath(r);
                if (platformVerPath == null || platformVerPath.isEmpty()) {
                    return pkgList;
                }
                DevPackageManager.addExtDevPackageList(pkgList, rootstrapId, platformVerPath);
            }
            catch (SBIException e) {
                e.printStackTrace();
                e.showErrorDialog();
            }
        }
        return pkgList;
    }

    private static String getPlatformVerPath(Rootstrap rootstrap) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        Path platformBasePath = new Path(sbi.getPlatformBasePath());
        Path rootstrapPath = new Path(rootstrap.getPath());
        String platformVerPath = "";
        int matchingIndex = rootstrapPath.matchingFirstSegments((IPath)platformBasePath);
        IPath versionPath = rootstrapPath.removeFirstSegments(matchingIndex);
        if (versionPath != null && !versionPath.isEmpty()) {
            String platformVer = versionPath.segment(0);
            String profile = versionPath.segment(1);
            platformVerPath = platformBasePath.append(platformVer).append(profile).append("rootstraps").toOSString();
        }
        return platformVerPath;
    }

    public static List<String> getIncludePathList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return pkg.getIncludePathList();
        }
        return new ArrayList<String>();
    }

    public static List<String> getLibraryPathList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return pkg.getLibraryPathList();
        }
        return new ArrayList<String>();
    }

    public static List<String> getLibraryList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return pkg.getLibraryList();
        }
        return new ArrayList<String>();
    }

    public static List<String> getOtherCFlagList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return (ArrayList)pkg.getOtherCFlagList().clone();
        }
        return new ArrayList<String>();
    }

    public static List<String> getOtherLFlagList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return (ArrayList)pkg.getOtherLFlagList().clone();
        }
        return new ArrayList<String>();
    }

    public static List<String> getExtendedSharedLibraryFileList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return pkg.getExtendedSharedLibraryFileList();
        }
        return new ArrayList<String>();
    }

    public static List<String> getResourceFileList(String targetID, String pkgName) {
        DevPackage pkg = DevPackageManager.findPackage(targetID, pkgName);
        if (pkg != null) {
            return pkg.getResourceFileList();
        }
        return new ArrayList<String>();
    }

    private static DevPackage findPackage(String targetID, String pkgName) {
        List<DevPackage> pkgList = DevPackageManager.getAllDevPkgs(targetID);
        if (pkgList != null) {
            for (DevPackage pkg : pkgList) {
                if (!pkg.getName().equals(pkgName)) continue;
                return pkg;
            }
        }
        return null;
    }

    public static boolean isValidDevPackageName(String targetID, String pkgName) {
        return DevPackageManager.findPackage(targetID, pkgName) != null;
    }
}

