/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.shortcut;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ProjectUtil;

public class BuildPackageProjectHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(BuildPackageProjectHandler.class);
    private static String extPointId = "org.eclipse.ui.handlers";
    private static String classIdNative = "org.tizen.nativecore.build.BuildPackageObjectAction";
    private static String classIdWeb = "org.tizen.web.ui.command.popupMenu.buildPackage";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IHandler obj;
        block6: {
            IProject project = ProjectUtil.getProject(event);
            obj = null;
            if (ProjectUtil.isTizenNativeProject(project)) {
                obj = (IHandler)this.loadClass(extPointId, classIdNative);
                break block6;
            }
            if (ProjectUtil.isTizenWebProject(project)) {
                obj = (IHandler)this.loadClass(extPointId, classIdWeb);
                break block6;
            }
            return null;
        }
        try {
            if (obj != null) {
                obj.execute(event);
            }
        }
        catch (Exception e) {
            logger.debug("failed to execute handlers", (Throwable)e);
        }
        return null;
    }

    private Object loadClass(String extPointId, String commandId) throws CoreException {
        IExtension[] exts;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(extPointId);
        IExtension[] iExtensionArray = exts = ep.getExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = ext.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                String id = config.getAttribute("commandId");
                if (id != null && id.equals(commandId)) {
                    return config.createExecutableExtension("class");
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

