/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecommon.CodanSettings;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativecommon.fastdeploy.NativeFastDeployListener;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.nativecommon";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            CodanSettings.disableCodeAnalysisProblems(CodanSettings.getCodanProblemIds("org.eclipse.cdt.codan.core.categories.CompilerErrors"));
        }
        catch (Throwable t) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Failed to initialize Codan", t));
        }
        ProjectUtil.enableAutoBuild(false);
        if (!SBIModel.isInitialized()) {
            Job initJob = new Job("Initializing SBI"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Initializing SBI...", 100);
                    SBIModel.initialize(monitor, InstallPathConfig.getSDKPath());
                    return Status.OK_STATUS;
                }
            };
            initJob.schedule();
        }
        this.initFastDeploy();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void initFastDeploy() {
        NativeFastDeployListener fastDeployListener = new NativeFastDeployListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)fastDeployListener, 16);
    }
}

