/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.sdb;

import java.io.Closeable;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.sdb.SdbDevicesHandlingCommand;
import org.tizen.common.util.Assert;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.IOUtil;

public class ShellSdbCommand
extends SdbDevicesHandlingCommand {
    protected boolean printOption = true;
    private String command;
    private static int DEFAULT_TIME = 90;
    private int time;

    public boolean isPrintOption() {
        return this.printOption;
    }

    public void setPrintOption(boolean printOption) {
        this.printOption = printOption;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time <= 0 ? DEFAULT_TIME : time;
    }

    public ShellSdbCommand() {
        this.time = DEFAULT_TIME;
    }

    public ShellSdbCommand(String command) {
        this.command = command;
        this.time = DEFAULT_TIME;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public MultiLineReceiver createMultiLineReceiver() {
        return new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String content = stringArray[n2];
                    ShellSdbCommand.this.setResult(String.valueOf(content) + System.getProperty("line.separator"));
                    ++n2;
                }
            }
        };
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        IDevice device = this.getDevice();
        Assert.notNull(device);
        Assert.notNull(this.command);
        this.clearResult();
        MultiLineReceiver receiver = null;
        try {
            try {
                receiver = this.createMultiLineReceiver();
                device.executeShellCommand(this.command, (IShellOutputReceiver)receiver, this.getTime() * 1000);
            }
            catch (Exception e) {
                if (this.isPrintOption()) {
                    String msg = "Operation failed.";
                    context.getPrompter().notify(msg);
                }
                throw e;
            }
        }
        finally {
            IOUtil.tryClose((Closeable)receiver);
        }
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
    }
}

