/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.util.LinkedList;
import java.util.List;

public class DispStringAnalyzer {
    public static final int FUNC_WITH_ARGS = 7;
    public static final int FUNC_NO_ARGS = 3;
    public static final int NO_FUNC = 0;
    private final String[] aTypeNameModifiers = new String[]{"unsigned", "const", "struct", "union", "enum", "short", "long", "signed", "char"};
    private final String[] aKeyWords = new String[]{"for", "do", "while", "return", "break", "continue", "switch", "case", "default", "delete"};
    private final String[] aComplexKeyWords = new String[]{"for -", "do -", "switch -", "else -", "elseif -", "new -"};
    private List<String> lArgTypeNames;
    private String fDString;
    private int fTypeOfItem;
    private boolean fMacroDetected = false;

    private boolean isTypeNameModifier(String sParam) {
        int i = 0;
        while (i < this.aTypeNameModifiers.length) {
            if (sParam.equals(this.aTypeNameModifiers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInFunctionKeyword() {
        int i = 0;
        while (i < this.aKeyWords.length) {
            if (this.fDString.equals(this.aKeyWords[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.aComplexKeyWords.length) {
            if (this.fDString.startsWith(this.aComplexKeyWords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void appendTypeNames(String sArgDesc) {
        if (sArgDesc.equals("...")) {
            this.fTypeOfItem = 7;
            return;
        }
        String[] aElems = sArgDesc.split("[\\s\\*\\[\\]]+");
        String sTypeNameCandidate = null;
        int i = 0;
        while (i < aElems.length) {
            if (!this.isTypeNameModifier(aElems[i])) {
                if (sTypeNameCandidate == null) {
                    sTypeNameCandidate = aElems[i];
                } else {
                    this.lArgTypeNames.add(sTypeNameCandidate);
                    this.fTypeOfItem = 7;
                    return;
                }
            }
            ++i;
        }
    }

    public int setFunctionDisplayString4Analysis(String aString) {
        this.lArgTypeNames = new LinkedList<String>();
        this.fDString = aString;
        this.fMacroDetected = false;
        this.fTypeOfItem = 0;
        int closingBracket = -1;
        int openningBracket = this.fDString.indexOf(40);
        if (-1 == openningBracket) {
            return this.fTypeOfItem;
        }
        closingBracket = this.fDString.lastIndexOf(41);
        if (-1 == closingBracket) {
            return this.fTypeOfItem;
        }
        if (closingBracket < openningBracket) {
            return this.fTypeOfItem;
        }
        this.fTypeOfItem = 3;
        this.fMacroDetected = false;
        String sInBrackets = this.fDString.substring(openningBracket + 1, closingBracket).trim();
        if (sInBrackets.length() == 0) {
            return this.fTypeOfItem;
        }
        String[] aArgDesc = sInBrackets.split(",");
        int i = 0;
        while (i < aArgDesc.length) {
            this.appendTypeNames(aArgDesc[i]);
            ++i;
        }
        if (this.lArgTypeNames.size() > 0) {
            this.fTypeOfItem = 7;
        } else if (this.fTypeOfItem != 7) {
            this.fTypeOfItem = 0;
            this.fMacroDetected = true;
        }
        return this.fTypeOfItem;
    }

    public boolean isTypeNameReferenced(String sTypeName) {
        if (this.fMacroDetected) {
            return false;
        }
        int i = 0;
        while (i < this.lArgTypeNames.size()) {
            if (this.lArgTypeNames.get(i).equals(sTypeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMacro() {
        return this.fMacroDetected;
    }
}

