/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.ssl.ASN1Structure;
import org.apache.commons.ssl.PEMItem;
import org.apache.commons.ssl.PEMUtil;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.asn1.ASN1InputStream;
import org.apache.commons.ssl.asn1.DEREncodable;
import org.apache.commons.ssl.asn1.DERInteger;
import org.apache.commons.ssl.asn1.DERObjectIdentifier;
import org.apache.commons.ssl.asn1.DEROctetString;
import org.apache.commons.ssl.asn1.DERPrintableString;
import org.apache.commons.ssl.asn1.DERSequence;
import org.apache.commons.ssl.asn1.DERSet;
import org.apache.commons.ssl.asn1.DERTaggedObject;

public class ASN1Util {
    public static boolean DEBUG = false;
    public static final BigInteger BIGGEST = new BigInteger(Integer.toString(Integer.MAX_VALUE));

    public static ASN1Structure analyze(byte[] asn1) throws IOException {
        ASN1InputStream asn = new ASN1InputStream(asn1);
        DERSequence seq = (DERSequence)asn.readObject();
        ASN1Structure pkcs8 = new ASN1Structure();
        ASN1Util.analyze(seq, pkcs8, 0);
        return pkcs8;
    }

    public static void main(String[] args) throws Exception {
        DEBUG = true;
        FileInputStream in = new FileInputStream(args[0]);
        byte[] bytes = Util.streamToBytes(in);
        List list = PEMUtil.decode(bytes);
        if (!list.isEmpty()) {
            bytes = ((PEMItem)list.get(0)).getDerBytes();
        }
        ASN1Structure asn1 = ASN1Util.analyze(bytes);
        while (asn1.bigPayload != null) {
            System.out.println("------------------------------------------");
            System.out.println(asn1);
            System.out.println("------------------------------------------");
            asn1 = ASN1Util.analyze(asn1.bigPayload);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void analyze(DEREncodable seq, ASN1Structure pkcs8, int depth) {
        void var4_4;
        Enumeration en;
        String tag = null;
        if (depth >= 2) {
            pkcs8.derIntegers = null;
        }
        if (seq instanceof DERSequence) {
            en = ((DERSequence)seq).getObjects();
        } else if (seq instanceof DERSet) {
            en = ((DERSet)seq).getObjects();
        } else if (seq instanceof DERTaggedObject) {
            DERTaggedObject derTag = (DERTaggedObject)seq;
            tag = Integer.toString(derTag.getTagNo());
            Vector<DEREncodable> v = new Vector<DEREncodable>();
            v.add(derTag.getObject());
            en = v.elements();
        } else {
            throw new IllegalArgumentException("DEREncodable must be one of: DERSequence, DERSet, DERTaggedObject");
        }
        while (var4_4 != null && var4_4.hasMoreElements()) {
            DEREncodable obj = (DEREncodable)var4_4.nextElement();
            if (!(obj instanceof DERSequence || obj instanceof DERSet || obj instanceof DERTaggedObject)) {
                String str = obj.toString();
                String name = obj.getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                if (tag != null) {
                    name = " [tag=" + tag + "] " + name;
                }
                for (int i = 0; i < depth; ++i) {
                    name = "  " + name;
                }
                if (obj instanceof DERInteger) {
                    DERInteger dInt = (DERInteger)obj;
                    if (pkcs8.derIntegers != null) {
                        pkcs8.derIntegers.add(dInt);
                    }
                    BigInteger big = dInt.toBigInteger();
                    int intValue = big.intValue();
                    if (BIGGEST.compareTo(big) >= 0 && intValue > 0) {
                        if (pkcs8.iterationCount == 0) {
                            pkcs8.iterationCount = intValue;
                        } else if (pkcs8.keySize == 0) {
                            pkcs8.keySize = intValue;
                        }
                    }
                    str = dInt.toBigInteger().toString();
                } else if (obj instanceof DERObjectIdentifier) {
                    DERObjectIdentifier id = (DERObjectIdentifier)obj;
                    str = id.getIdentifier();
                    pkcs8.oids.add(str);
                    if (pkcs8.oid1 == null) {
                        pkcs8.oid1 = str;
                    } else if (pkcs8.oid2 == null) {
                        pkcs8.oid2 = str;
                    } else if (pkcs8.oid3 == null) {
                        pkcs8.oid3 = str;
                    }
                } else {
                    pkcs8.derIntegers = null;
                    if (obj instanceof DEROctetString) {
                        DEROctetString oct = (DEROctetString)obj;
                        byte[] octets = oct.getOctets();
                        int len = Math.min(10, octets.length);
                        boolean probablyBinary = false;
                        for (int i = 0; i < len; ++i) {
                            boolean isBinary;
                            byte b = octets[i];
                            boolean bl = isBinary = b > 128 || b < 0;
                            if (!isBinary) continue;
                            probablyBinary = true;
                            break;
                        }
                        if (probablyBinary && octets.length > 64) {
                            if (pkcs8.bigPayload == null) {
                                pkcs8.bigPayload = octets;
                            }
                            str = "probably binary";
                        } else {
                            str = PEMUtil.bytesToHex(octets);
                            if (octets.length <= 64) {
                                if (octets.length % 8 == 0) {
                                    if (pkcs8.salt == null) {
                                        pkcs8.salt = octets;
                                    } else if (pkcs8.iv == null) {
                                        pkcs8.iv = octets;
                                    }
                                } else if (pkcs8.smallPayload == null) {
                                    pkcs8.smallPayload = octets;
                                }
                            }
                        }
                        str = str + " (length=" + octets.length + ")";
                    } else if (obj instanceof DERPrintableString) {
                        DERPrintableString dps = (DERPrintableString)obj;
                        str = dps.getString();
                    }
                }
                if (!DEBUG) continue;
                System.out.println(name + ": [" + str + "]");
                continue;
            }
            if (tag != null && DEBUG) {
                String name = obj.getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                name = " [tag=" + tag + "] " + name;
                for (int i = 0; i < depth; ++i) {
                    name = "  " + name;
                }
                System.out.println(name);
            }
            ASN1Util.analyze(obj, pkcs8, depth + 1);
        }
    }
}

