/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.commons.ssl.Base64;
import org.apache.commons.ssl.Base64InputStream;
import org.apache.commons.ssl.ComboInputStream;
import org.apache.commons.ssl.DerivedKey;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.Version;

public class OpenSSL {
    public static InputStream decrypt(String cipher, byte[] pwd, InputStream encrypted) throws IOException, GeneralSecurityException {
        CipherInfo cipherInfo = OpenSSL.lookup(cipher);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        boolean salted = false;
        byte[] saltLine = Util.streamToBytes(encrypted, 16);
        if (saltLine.length <= 0) {
            throw new IOException("encrypted InputStream is empty");
        }
        String firstEightBytes = "";
        if (saltLine.length >= 8) {
            firstEightBytes = new String(saltLine, 0, 8);
        }
        if ("SALTED__".equalsIgnoreCase(firstEightBytes)) {
            salted = true;
        } else if (Base64.isArrayByteBase64(saltLine)) {
            ByteArrayInputStream head = new ByteArrayInputStream(saltLine);
            encrypted = new ComboInputStream(head, encrypted);
            saltLine = Util.streamToBytes(encrypted = new Base64InputStream(encrypted, true), 16);
            if (saltLine.length >= 8) {
                firstEightBytes = new String(saltLine, 0, 8);
            }
            if ("SALTED__".equalsIgnoreCase(firstEightBytes)) {
                salted = true;
            }
        }
        byte[] salt = null;
        if (salted) {
            salt = new byte[8];
            System.arraycopy(saltLine, 8, salt, 0, 8);
        } else {
            ByteArrayInputStream head = new ByteArrayInputStream(saltLine);
            encrypted = new ComboInputStream(head, encrypted);
        }
        int keySize = cipherInfo.keySize;
        int ivSize = 64;
        if (cipherInfo.javaCipher.startsWith("AES")) {
            ivSize = 128;
        }
        DerivedKey dk = OpenSSL.deriveKey(pwd, salt, keySize, ivSize, md5);
        Cipher c = PKCS8Key.generateCipher(cipherInfo.javaCipher, cipherInfo.blockMode, dk, cipherInfo.des2, null, true);
        return new CipherInputStream(encrypted, c);
    }

    public static InputStream encrypt(String cipher, byte[] pwd, InputStream data) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, pwd, data, true);
    }

    public static InputStream encrypt(String cipher, byte[] pwd, InputStream data, boolean toBase64) throws IOException, GeneralSecurityException {
        return OpenSSL.encrypt(cipher, pwd, data, toBase64, true);
    }

    public static InputStream encrypt(String cipher, byte[] pwd, InputStream data, boolean toBase64, boolean useSalt) throws IOException, GeneralSecurityException {
        CipherInfo cipherInfo = OpenSSL.lookup(cipher);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] salt = null;
        if (useSalt) {
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            salt = new byte[8];
            rand.nextBytes(salt);
        }
        int keySize = cipherInfo.keySize;
        int ivSize = 64;
        if (cipherInfo.javaCipher.startsWith("AES")) {
            ivSize = 128;
        }
        DerivedKey dk = OpenSSL.deriveKey(pwd, salt, keySize, ivSize, md5);
        Cipher c = PKCS8Key.generateCipher(cipherInfo.javaCipher, cipherInfo.blockMode, dk, cipherInfo.des2, null, false);
        InputStream cipherStream = new CipherInputStream(data, c);
        if (useSalt) {
            byte[] saltLine = new byte[16];
            byte[] salted = "Salted__".getBytes();
            System.arraycopy(salted, 0, saltLine, 0, salted.length);
            System.arraycopy(salt, 0, saltLine, salted.length, salt.length);
            ByteArrayInputStream head = new ByteArrayInputStream(saltLine);
            cipherStream = new ComboInputStream(head, cipherStream);
        }
        if (toBase64) {
            cipherStream = new Base64InputStream(cipherStream, false);
        }
        return cipherStream;
    }

    public static DerivedKey deriveKey(byte[] password, byte[] salt, int keySize, MessageDigest md) {
        return OpenSSL.deriveKey(password, salt, keySize, 0, md);
    }

    public static DerivedKey deriveKey(byte[] password, byte[] salt, int keySize, int ivSize, MessageDigest md) {
        md.reset();
        byte[] keyAndIv = new byte[keySize / 8 + ivSize / 8];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            md.update(password);
            if (salt != null) {
                md.update(salt, 0, 8);
            }
            if ((result = md.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            md.reset();
            md.update(result);
        }
        if (ivSize == 0) {
            return new DerivedKey(keyAndIv, salt);
        }
        byte[] key = new byte[keySize / 8];
        byte[] iv = new byte[ivSize / 8];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        return new DerivedKey(key, iv);
    }

    public static CipherInfo lookup(String openSSLCipher) {
        if ((openSSLCipher = openSSLCipher.trim()).charAt(0) == '-') {
            openSSLCipher = openSSLCipher.substring(1);
        }
        String javaCipher = openSSLCipher;
        String blockMode = "CBC";
        int keySize = -1;
        boolean des2 = false;
        StringTokenizer st = new StringTokenizer(openSSLCipher, "-");
        if (st.hasMoreTokens()) {
            javaCipher = st.nextToken().toUpperCase();
            if (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (st.hasMoreTokens()) {
                    block22: {
                        try {
                            keySize = Integer.parseInt(tok);
                        }
                        catch (NumberFormatException nfe) {
                            String upper = tok.toUpperCase();
                            if ("EDE3".equals(upper)) {
                                javaCipher = "DESede";
                            }
                            if (!"EDE".equals(upper)) break block22;
                            javaCipher = "DESede";
                            des2 = true;
                        }
                    }
                    blockMode = st.nextToken().toUpperCase();
                } else {
                    blockMode = tok.toUpperCase();
                    if ("EDE".equals(blockMode)) {
                        javaCipher = "DESede";
                        blockMode = "ECB";
                        des2 = true;
                    } else if ("EDE3".equals(blockMode)) {
                        javaCipher = "DESede";
                        blockMode = "ECB";
                    }
                }
            }
        }
        if ("BF".equals(javaCipher)) {
            javaCipher = "Blowfish";
        }
        if ("DES3".equals(javaCipher)) {
            javaCipher = "DESede";
        } else if ("DES2".equals(javaCipher)) {
            javaCipher = "DESede";
            des2 = true;
        } else if ("AES128".equals(javaCipher)) {
            javaCipher = "AES";
            keySize = 128;
        } else if ("AES192".equals(javaCipher)) {
            javaCipher = "AES";
            keySize = 192;
        } else if ("AES256".equals(javaCipher)) {
            javaCipher = "AES";
            keySize = 256;
        }
        if (keySize == -1) {
            keySize = javaCipher.startsWith("DESede") ? 192 : (javaCipher.startsWith("DES") ? 64 : 128);
        }
        return new CipherInfo(javaCipher, blockMode, keySize, des2);
    }

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        if (args.length < 3) {
            System.out.println(Version.versionString());
            System.out.println("Pure-java utility to decrypt files previously encrypted by 'openssl enc'");
            System.out.println();
            System.out.println("Usage:  java -cp commons-ssl.jar org.apache.commons.ssl.OpenSSL [args]");
            System.out.println("        [args]   == [password] [cipher] [file-to-decrypt]");
            System.out.println("        [cipher] == des, des3, des-ede3-cbc, aes256, rc2, rc4, bf, bf-cbc, etc...");
            System.out.println("                    Try 'man enc' on a unix box to see what's possible.");
            System.out.println();
            System.out.println("This utility can handle base64 or raw, salted or unsalted.");
            System.out.println();
            System.exit(1);
        }
        char[] password = args[0].toCharArray();
        byte[] pwdAsBytes = new byte[password.length];
        for (int i = 0; i < password.length; ++i) {
            pwdAsBytes[i] = (byte)password[i];
        }
        InputStream in = new FileInputStream(args[2]);
        in = OpenSSL.decrypt(args[1], pwdAsBytes, in);
        Util.pipeStream(in, System.out, false);
        byte[] output = Util.streamToBytes(in);
        System.out.write(output);
        System.out.flush();
    }

    public static class CipherInfo {
        public final String javaCipher;
        public final String blockMode;
        public final int keySize;
        public final boolean des2;

        public CipherInfo(String javaCipher, String blockMode, int keySize, boolean des2) {
            this.javaCipher = javaCipher;
            this.blockMode = blockMode;
            this.keySize = keySize;
            this.des2 = des2;
        }

        public String toString() {
            return this.javaCipher + "/" + this.blockMode + " " + this.keySize + "bit  des2=" + this.des2;
        }
    }
}

