/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerFocusHandler {
    private int KEYSIZE = 220;
    private boolean isFocused = false;
    private TableColumnTemporaryStorage columnStorage = new TableColumnTemporaryStorage();

    public List<String> getColumnValues() {
        return this.columnStorage.getColumnList();
    }

    public void saveColumnValues(Table table) {
        TableColumn[] columns = table.getColumns();
        this.getColumnValues().clear();
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            this.getColumnValues().add(c.getText());
            ++n2;
        }
    }

    public void restoreColumnValues(Table table) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].setText(this.getColumnValues().get(i));
            ++i;
        }
    }

    public void restoreIfFocusingStatus(Rectangle area, Table table) {
        if (this.isColumnFocused()) {
            this.restoreColumnValues(table);
            this.resizeAllItemsSame(area, table);
            table.getParent().layout(true, true);
        }
    }

    public synchronized void resizeAllItemsSame(Rectangle area, Table table) {
        Point oldSize = table.getSize();
        TableColumn[] columns = table.getColumns();
        if (columns.length <= 1) {
            return;
        }
        int[] size = this.getColumnSize(area, table, columns.length);
        if (oldSize.x > area.width) {
            int i = 0;
            while (i < columns.length) {
                if (i == 0) {
                    columns[i].setWidth(size[0]);
                } else {
                    columns[i].setWidth(size[1]);
                }
                ++i;
            }
            table.setSize(area.width, area.height);
        } else {
            table.setSize(area.width, area.height);
            int i = 0;
            while (i < columns.length) {
                if (i == 0) {
                    columns[i].setWidth(size[0]);
                } else {
                    columns[i].setWidth(size[1]);
                }
                ++i;
            }
        }
        this.setColumnFocusing(false);
    }

    public void focusSelectedItem(Rectangle area, Table table, int selectedColumn) {
        if (selectedColumn == 0) {
            return;
        }
        Point size = table.computeSize(-1, -1);
        ScrollBar vBar = table.getVerticalBar();
        int width = area.width - table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
        if (size.y > area.height + table.getHeaderHeight()) {
            Point vBarSize = vBar.getSize();
            width -= vBarSize.x;
        }
        int otherColumnsSize = 20;
        Point oldSize = table.getSize();
        TableColumn[] columns = table.getColumns();
        int keySize = columns[0].getWidth();
        int asize = otherColumnsSize * (columns.length - 2);
        if (oldSize.x > area.width) {
            int i = 0;
            while (i < columns.length) {
                if (i == 0) {
                    columns[i].setWidth(keySize);
                } else if (i == selectedColumn) {
                    columns[i].setWidth(width - keySize - asize - otherColumnsSize);
                } else {
                    columns[i].setText("");
                    columns[i].setWidth(otherColumnsSize);
                }
                ++i;
            }
            table.setSize(area.width, area.height);
        } else {
            table.setSize(area.width, area.height);
            int i = 0;
            while (i < columns.length) {
                if (i == 0) {
                    columns[i].setWidth(keySize);
                } else if (i == selectedColumn) {
                    columns[i].setWidth(width - keySize - asize - otherColumnsSize);
                } else {
                    columns[i].setText("");
                    columns[i].setWidth(otherColumnsSize);
                }
                ++i;
            }
        }
        this.setColumnFocusing(true);
    }

    public int[] getColumnSize(Rectangle area, Table table, int columnSize) {
        Point size = table.computeSize(-1, -1);
        ScrollBar vBar = table.getVerticalBar();
        int width = area.width - table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
        if (size.y > area.height + table.getHeaderHeight()) {
            Point vBarSize = vBar.getSize();
            width -= vBarSize.x;
        }
        if (columnSize == 1) {
            int[] nArray = new int[2];
            nArray[0] = width;
            return nArray;
        }
        int otherSize = width / columnSize;
        int keySize = this.KEYSIZE;
        if (otherSize > this.KEYSIZE) {
            keySize = otherSize;
        } else {
            otherSize = (width - this.KEYSIZE) / (columnSize - 1);
        }
        return new int[]{keySize, otherSize};
    }

    public boolean isColumnFocused() {
        return this.isFocused;
    }

    public void setColumnFocusing(boolean value) {
        this.isFocused = value;
    }

    static class TableColumnTemporaryStorage {
        private List<String> tempColumns = new ArrayList<String>();

        public List<String> getColumnList() {
            return this.tempColumns;
        }
    }
}

