/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;

public class DeltaListResource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String FILENAME = ".delta.lst";
    protected final String[][] typeKeyValue = new String[][]{{"add", "C"}, {"modify", "C"}, {"delete", "D"}};
    public static final String DELIMETER = "__DEL__";
    protected IProject project;
    protected IContainer cwd;
    protected File listFile;

    public DeltaListResource(IProject project, IContainer workgingFolder) {
        Assert.notNull((Object)project);
        Assert.notNull((Object)workgingFolder);
        this.project = project;
        this.cwd = workgingFolder;
        this.listFile = this.cwd.getLocation().append(FILENAME).toFile();
    }

    public int createListResource(List<DeltaResourceInfo> deltaInfoList) throws IOException {
        Assert.notNull(deltaInfoList);
        this.logger.debug("create delta list for RDS");
        int count = 0;
        OutputStream os = null;
        try {
            os = new FileOutputStream(this.listFile);
            os = new BufferedOutputStream(os);
            StringBuilder strBuilder = new StringBuilder();
            deltaInfoList = this.remakeDeltaResourceForSign(deltaInfoList);
            IPath cwdLocation = this.cwd.getLocation();
            for (DeltaResourceInfo deltaInfo : deltaInfoList) {
                String realPath = deltaInfo.getRealPath();
                Path fullPath = new Path(realPath);
                IPath relativePath = fullPath.makeRelativeTo(cwdLocation);
                if (!this.checkValidPath(relativePath)) continue;
                strBuilder.append(realPath);
                String[][] stringArray = this.typeKeyValue;
                int n = this.typeKeyValue.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] type = stringArray[n2];
                    if (type[0].equals(deltaInfo.getType())) {
                        strBuilder.append(type[1]);
                        break;
                    }
                    ++n2;
                }
                strBuilder.append(DELIMETER);
                String remotePath = deltaInfo.getRemotePath();
                if (remotePath != null) {
                    strBuilder.append(remotePath);
                } else {
                    strBuilder.append(relativePath.toString());
                }
                strBuilder.append('\n');
                ++count;
            }
            this.logger.debug(strBuilder.toString());
            os.write(strBuilder.toString().getBytes());
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{os});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{os});
        return count;
    }

    private List<DeltaResourceInfo> remakeDeltaResourceForSign(List<DeltaResourceInfo> deltaInfoList) {
        ArrayList<DeltaResourceInfo> remakeDeltaInfo = new ArrayList<DeltaResourceInfo>();
        for (DeltaResourceInfo deltaInfo : deltaInfoList) {
            if (1 == deltaInfo.getResourceType()) {
                remakeDeltaInfo.add(deltaInfo);
            }
            remakeDeltaInfo.addAll(this.remakeDeltaResourceForSign(deltaInfo.getChildren()));
            deltaInfo.setChildren(new ArrayList());
        }
        return remakeDeltaInfo;
    }

    protected boolean checkValidPath(IPath path) {
        Assert.notNull((Object)path);
        String firstSegment = path.segment(0);
        String name = path.lastSegment();
        if (name.startsWith(".")) {
            return false;
        }
        return !SignatureUtility.isSignatureFile(firstSegment);
    }

    public File getListResource() {
        return this.listFile;
    }

    public IContainer getCurrentWorkingFolder() {
        return this.cwd;
    }

    public boolean removeListResource() {
        Assert.notNull((Object)this.listFile);
        this.logger.debug("remove {}", (Object)this.listFile.getAbsolutePath());
        return this.listFile.exists() && this.listFile.isFile() ? this.listFile.delete() : true;
    }
}

