/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Resource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.util.FilenameUtil;

public class ResourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtil.class);

    public static org.tizen.common.file.IResource getResource(String relativePath, org.tizen.common.file.IResource ... resources) {
        String findPath = relativePath;
        org.tizen.common.file.IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            org.tizen.common.file.IResource resource = iResourceArray[n2];
            String compPath = FilenameUtil.getCanonicalForm(resource.getPath());
            if (compPath.equals(findPath = FilenameUtil.getCanonicalForm(relativePath))) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    public static void removeResource(String companionFullPath, org.tizen.common.file.IResource[] array) {
    }

    public static org.tizen.common.file.IResource convertResource(IResource eclipseResource) {
        Resource resource = null;
        try {
            StandardFileHandler fh = new StandardFileHandler(eclipseResource.getProject().getLocation().toOSString());
            resource = new Resource(fh, FilenameUtil.getRelativePath(fh.getCurrentWorkingDirectory(), eclipseResource.getLocation().toOSString()));
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return resource;
    }

    public static Collection<org.tizen.common.file.IResource> getChildren(org.tizen.common.file.IResource resource, boolean recursively) throws IOException {
        ArrayList<org.tizen.common.file.IResource> resources = new ArrayList<org.tizen.common.file.IResource>();
        try {
            FileHandler fh = resource.getFileHandler();
            for (String path : fh.list(resource.getPath())) {
                Resource childResource = new Resource(fh, FilenameUtil.getRelativePath(fh.getCurrentWorkingDirectory(), path));
                resources.add(childResource);
                if (!FileHandler.Type.DIRECTORY.equals(fh.get(path, FileHandler.Attribute.TYPE)) || !recursively) continue;
                resources.addAll(ResourceUtil.getChildren(childResource, recursively));
            }
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return resources;
    }
}

