/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.rmi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMISocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.ssl.LogWrapper;
import org.apache.commons.ssl.RMISocketFactoryImpl;
import org.apache.commons.ssl.SSLClient;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.commons.ssl.rmi.DateRMI;
import org.apache.commons.ssl.rmi.IntegerRMI;
import org.apache.commons.ssl.rmi.RemoteDate;
import org.apache.commons.ssl.rmi.RemoteInteger;

public class Test {
    private static final LogWrapper log = LogWrapper.getLogger(class$org$apache$commons$ssl$rmi$Test == null ? (class$org$apache$commons$ssl$rmi$Test = Test.class$("org.apache.commons.ssl.rmi.Test")) : class$org$apache$commons$ssl$rmi$Test);
    private static final String TEST_DATE_NAME = "/org.apache.commons.ssl.rmi.testdate";
    private static final String TEST_INT_NAME = "/org.apache.commons.ssl.rmi.testint";
    protected static final int PORT;
    protected static final String URL;
    private static boolean rmiRunning;
    static /* synthetic */ Class class$org$apache$commons$ssl$rmi$Test;

    public static Object lookup(String ref) throws RemoteException, NotBoundException, MalformedURLException {
        return Naming.lookup(URL + ref);
    }

    public static void rebind(String ref, Remote obj) throws RemoteException, MalformedURLException {
        Test.requireNameServer();
        String realRef = URL + ref;
        Naming.rebind(realRef, obj);
        try {
            Object o = Test.lookup(ref);
            log.debug("Bound " + o.getClass().getName() + " to [" + realRef + "]");
        }
        catch (NotBoundException nbe) {
            log.debug("Error binding " + obj.getClass().getName() + " to [" + realRef + "]");
        }
    }

    private static void rebindTest() throws Exception {
        DateRMI remoteTest = new DateRMI();
        Naming.rebind(URL + TEST_DATE_NAME, remoteTest);
        Remote o = Naming.lookup(URL + TEST_DATE_NAME);
        if (!((Object)remoteTest).equals(o)) {
            throw new RuntimeException("rmi: Test failed. Lookup != Rebind");
        }
    }

    private static synchronized void requireNameServer() {
        if (rmiRunning) {
            return;
        }
        try {
            Test.rebindTest();
            rmiRunning = true;
        }
        catch (Exception e) {
            Test.tryToStartNameServer();
            try {
                Test.rebindTest();
                log.debug((class$org$apache$commons$ssl$rmi$Test == null ? (class$org$apache$commons$ssl$rmi$Test = Test.class$("org.apache.commons.ssl.rmi.Test")) : class$org$apache$commons$ssl$rmi$Test).getName() + " successfully started.");
                rmiRunning = true;
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                log.error(e2.getMessage(), e2);
                String msg = (class$org$apache$commons$ssl$rmi$Test == null ? (class$org$apache$commons$ssl$rmi$Test = Test.class$("org.apache.commons.ssl.rmi.Test")) : class$org$apache$commons$ssl$rmi$Test).getName() + " cannot start.";
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    public static void tryToStartNameServer() {
        String className = (class$org$apache$commons$ssl$rmi$Test == null ? (class$org$apache$commons$ssl$rmi$Test = Test.class$("org.apache.commons.ssl.rmi.Test")) : class$org$apache$commons$ssl$rmi$Test).getName();
        log.debug(className + " probably not running.   Trying to start one.");
        try {
            LocateRegistry.createRegistry(PORT);
            log.debug("registry on " + PORT + " started!");
        }
        catch (Exception problem) {
            problem.printStackTrace();
            log.warn(problem, problem);
        }
    }

    public static void main(String[] args) throws Exception {
        RMISocketFactoryImpl impl;
        if (args.length > 0 && "ssl".equalsIgnoreCase(args[0])) {
            impl = new RMISocketFactoryImpl();
            SocketFactory sf = impl.getDefaultClient();
            if (sf instanceof SSLClient) {
                SSLClient client = (SSLClient)impl.getDefaultClient();
                impl.setClient("ryerson.ca", client);
                impl.setClient("neptune.cucbc.com", client);
                client.setCheckHostname(false);
                client.addTrustMaterial(TrustMaterial.CACERTS);
            }
            RMISocketFactory.setSocketFactory(impl);
        } else {
            impl = new RMISocketFactoryImpl();
            RMISocketFactory.setSocketFactory(impl);
            Test.requireNameServer();
            Test.rebindTest();
            IntegerRMI remoteInt = new IntegerRMI();
            Test.rebind(TEST_INT_NAME, remoteInt);
        }
        Object o = Test.lookup(TEST_DATE_NAME);
        RemoteDate rd = (RemoteDate)o;
        System.out.println("The remote-date is: " + rd.getDate());
        o = Test.lookup(TEST_INT_NAME);
        RemoteInteger ri = (RemoteInteger)o;
        System.out.println("The remote-int  is: " + ri.getInt());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rmiRunning = false;
        int port = 1099;
        String host = "127.0.0.1";
        PORT = port;
        URL = "rmi://" + host + ":" + port;
    }
}

