/*
 * Decompiled with CFR 0.152.
 */
package keycertificategenerator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.ssl.PKCS8Key;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class TizenKeyCertificateGenerator {
    static RSAPrivateCrtKeySpec privateKeySpec;
    static Certificate[] chain;
    private static final String BC;
    private static String PBEAlgorithm;
    private static String RSAString;
    private static String PKString;
    private static String SignAlgo;
    private static int MAXKeySize;
    private static String DeveloperPath;
    private static String DeveloperPathDirect;
    private static String DeveloperConfFile;
    private static String seperator;

    static {
        BC = BouncyCastleProvider.PROVIDER_NAME;
        PBEAlgorithm = "PBEWithSHA1AndDESede";
        RSAString = "RSA";
        PKString = "PKCS12";
        SignAlgo = "SHA1WithRSAEncryption";
        MAXKeySize = 1024;
        DeveloperPath = "../certificates/developer/";
        DeveloperPathDirect = "/certificates/developer/";
        DeveloperConfFile = "conf.ini";
        seperator = "/";
    }

    public static RSAPrivateCrtKeySpec getKeySpec() {
        return privateKeySpec;
    }

    public static Certificate[] getCerts() {
        return chain;
    }

    public static void KeyCertGeneratorFromIde(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, CertificateException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidParameterException, IllegalArgumentException, SecurityException, Exception {
        String caPrivKeyPath = null;
        String passwd = null;
        String caCertPath = null;
        String subjectName = null;
        String pathCert = null;
        String[] passValue = null;
        String[] split = null;
        TizenKeyCertificateGenerator tizenKeyGen = null;
        InputStreamReader inStream = null;
        BufferedReader bufRead = null;
        File fp = null;
        boolean visited = false;
        int iter = 1;
        int index = 0;
        try {
            try {
                if (countryName == null || countryName.length() == 0) {
                    countryName = "";
                } else if (!countryName.matches("^[a-zA-Z\\s]*$")) {
                    throw new IllegalArgumentException("the country name entered is not valid");
                }
                if (stateName == null || stateName.length() == 0) {
                    stateName = "";
                } else if (!stateName.matches("^[a-zA-Z\\s]*$")) {
                    throw new IllegalArgumentException("the stateName name entered is not valid");
                }
                if (cityName == null || cityName.length() == 0) {
                    cityName = "";
                } else if (!cityName.matches("^[a-zA-Z\\s]*$")) {
                    throw new IllegalArgumentException("the city name entered is not valid");
                }
                if (commonName == null) {
                    commonName = "";
                }
                if (organizationName == null) {
                    organizationName = "";
                }
                if (orgUnitName == null) {
                    orgUnitName = "";
                }
                if (emailId == null || emailId.length() == 0) {
                    emailId = "";
                } else if (!emailId.contains("@")) {
                    throw new IllegalArgumentException("the email id entered is not valid");
                }
                if (certGenDirPath == null || certGenDirPath.length() == 0) {
                    throw new IllegalArgumentException("the directory path where certs are stored shouldnt be empty");
                }
                if (certGenDirPath.contains("\\")) {
                    certGenDirPath = certGenDirPath.replace('\\', '/');
                }
                if (password == null || password.length() == 0) {
                    throw new IllegalArgumentException("password cannot be empty.");
                }
                if (alias == null || alias.length() == 0) {
                    throw new IllegalArgumentException("alias cannot be empty.");
                }
                if (pkcsKeyStorePath == null || pkcsKeyStorePath.length() == 0) {
                    throw new IllegalArgumentException("pkcsKeyStorePath cannot be empty.");
                }
                String osName = System.getProperty("os.name");
                if (osName.contains("Windows")) {
                    if (pkcsKeyStorePath.contains("\\") || pkcsKeyStorePath.contains("/")) {
                        pkcsKeyStorePath = pkcsKeyStorePath.replace('\\', '/');
                        visited = true;
                    }
                    if (visited ? (split = pkcsKeyStorePath.split(seperator))[split.length - 1].contains("<") || split[split.length - 1].contains(">") || split[split.length - 1].contains("?") || split[split.length - 1].contains("*") || split[split.length - 1].contains("/") || split[split.length - 1].contains("\\") || split[split.length - 1].contains("|") || split[split.length - 1].contains(":") || split[split.length - 1].contains("\"") : pkcsKeyStorePath.contains("<") || pkcsKeyStorePath.contains(">") || pkcsKeyStorePath.contains("?") || pkcsKeyStorePath.contains("*") || pkcsKeyStorePath.contains("/") || pkcsKeyStorePath.contains("\\") || pkcsKeyStorePath.contains("|") || pkcsKeyStorePath.contains(":") || pkcsKeyStorePath.contains("\"")) {
                        throw new IllegalArgumentException("pkcsKeyStore path string should not have special characters not permissible in windows file system");
                    }
                } else if (pkcsKeyStorePath.contains(seperator)) {
                    split = pkcsKeyStorePath.split(seperator);
                    iter = 0;
                    while (iter < split.length - 1) {
                        fp = new File(split[iter]);
                        if (fp.isFile()) {
                            fp = null;
                            throw new IllegalArgumentException("pkcsKeyStore path string should not have special characters not permissible in unix type file system");
                        }
                        fp = null;
                        ++iter;
                    }
                }
                tizenKeyGen = new TizenKeyCertificateGenerator();
                pathCert = certGenDirPath;
                pathCert = String.valueOf(pathCert) + DeveloperPathDirect;
                inStream = new InputStreamReader(new FileInputStream(String.valueOf(pathCert) + DeveloperConfFile));
                bufRead = new BufferedReader(inStream);
                visited = false;
                while ((passwd = bufRead.readLine()) != null) {
                    if (!passwd.matches("PASSWD_OF_ISSUER_FOR_DEV=.*")) continue;
                    visited = true;
                    break;
                }
                if (!visited) {
                    throw new InvalidParameterException("The password file is either missing or doesnt have a valid entry.");
                }
                visited = false;
                passValue = passwd.split("PASSWD_OF_ISSUER_FOR_DEV=");
                passwd = passValue[1];
                caCertPath = String.valueOf(pathCert) + "tizen-developer-ca.cer";
                caPrivKeyPath = String.valueOf(pathCert) + "tizen-developer-ca-privatekey.pem";
                index = 0;
                boolean flag = true;
                String tempCountryName = countryName;
                iter = countryName.length();
                if (tempCountryName.length() >= 2) {
                    while (tempCountryName.charAt(index) == ' ') {
                        if (++index != iter) continue;
                        flag = false;
                        break;
                    }
                    if (flag && index < iter) {
                        countryName = Character.toString(tempCountryName.charAt(index));
                        ++index;
                    }
                    if (index < iter) {
                        while (tempCountryName.charAt(index) == ' ') {
                            if (++index != iter) continue;
                            flag = false;
                            break;
                        }
                    }
                    countryName = flag && index < iter ? String.valueOf(countryName) + Character.toString(tempCountryName.charAt(index)) : "";
                }
                if (countryName.length() != 0) {
                    subjectName = "C=" + countryName;
                }
                if (stateName.length() != 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",ST=" + stateName;
                } else if (stateName.length() != 0) {
                    subjectName = "ST=" + stateName;
                }
                if (cityName.length() != 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",L=" + cityName;
                } else if (cityName.length() != 0) {
                    subjectName = "L=" + cityName;
                }
                if (organizationName.length() != 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",O=" + organizationName;
                } else if (organizationName.length() != 0) {
                    subjectName = "O=" + organizationName;
                }
                if (orgUnitName.length() != 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",OU=" + orgUnitName;
                } else if (orgUnitName.length() != 0) {
                    subjectName = "OU=" + orgUnitName;
                }
                if (emailId.length() != 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",E=" + emailId;
                } else if (emailId.length() != 0) {
                    subjectName = "E=" + emailId;
                }
                if (commonName.length() != 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",CN=" + commonName;
                } else if (commonName.length() != 0 && subjectName == null) {
                    subjectName = "CN=" + commonName;
                } else if (commonName.length() == 0 && subjectName != null) {
                    subjectName = String.valueOf(subjectName) + ",CN=author";
                } else if (commonName.length() == 0 && subjectName == null) {
                    subjectName = "CN=author";
                }
                Security.addProvider((Provider)new BouncyCastleProvider());
                tizenKeyGen.generateCertificate(subjectName, caCertPath, caPrivKeyPath, passwd);
                tizenKeyGen.GeneratePkcs12KeyStore(password, alias, pkcsKeyStorePath);
            }
            catch (KeyStoreException e) {
                throw new KeyStoreException("Key store type should be PKCS12 or any other valid entry.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new NoSuchAlgorithmException("Algorithm should be valid such as RSA or any other valid entry.", e);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeySpecException("The Key Spec should be generated from RSAPrivateKeySpec, PKCS8privateKeySpec, EncodedKeySpec or any other reconized spec.", e);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchPaddingException("Cipher object instance should be of valid algo such as PBEWithSHA1AndDESede." + e.getMessage());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyException("Key should be defined for init API of Cipher Object.", e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidAlgorithmParameterException("Valid Algorithm Parameter should be defined for init API of Cipher Object.", e);
            }
            catch (CertificateException e) {
                throw new CertificateException("Pass a valid PKCS12 structure along with correct password for storing it.", e);
            }
            catch (IOException e) {
                throw new IOException("Pass a valid data for reading or the file to be read is incorrect.", e);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidParameterSpecException("Parameter Spec should be valid when passed for init API for AlgorithmParameters Object." + e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new IllegalBlockSizeException("Data passed should be valid when calling doFinal API for Cipher Object." + e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new BadPaddingException("Data should be properly padded when calling doFinal API for Cipher Object." + e.getMessage());
            }
            catch (SignatureException e) {
                throw new SignatureException("Generated certificate has failed because of incorrect input parameters.", e);
            }
            catch (NoSuchProviderException e) {
                throw new NoSuchProviderException("Failed to validate the generated certificate with its intermediate CA." + e.getMessage());
            }
            catch (SecurityException e) {
                throw new SecurityException("method does not permit the named directory and all necessary parent directories to be created.", e);
            }
            catch (Exception e) {
                throw new Exception("Exception caught." + e.getMessage());
            }
        }
        finally {
            if (bufRead != null) {
                bufRead.close();
            }
        }
    }

    public static void main1(String[] args) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, CertificateException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidParameterException, SecurityException, Exception {
        String caPrivKeyPath = null;
        String passwd = null;
        String caCertPath = null;
        String countryName = null;
        String stateName = null;
        String cityName = null;
        String commonName = null;
        String organizationName = null;
        String orgUnitName = null;
        String emailId = null;
        String password = null;
        String alias = null;
        String subjectName = null;
        String[] passValue = null;
        String[] split = null;
        File fp = null;
        TizenKeyCertificateGenerator tizenKeyGen = null;
        InputStreamReader inStream = null;
        BufferedReader bufRead = null;
        int iter = 1;
        int index = 0;
        boolean visited = false;
        try {
            URL directoryPath;
            inStream = new InputStreamReader(System.in);
            bufRead = new BufferedReader(inStream);
            System.out.println("Please enter the country name(optional, two letters): ");
            countryName = bufRead.readLine();
            if (!countryName.matches("^[a-zA-Z\\s]*$")) {
                System.out.println("the country name entered is not valid");
                return;
            }
            System.out.println("Please enter the state or province name(optional): ");
            stateName = bufRead.readLine();
            if (!stateName.matches("^[a-zA-Z\\s]*$")) {
                System.out.println("the stateName name entered is not valid");
                return;
            }
            System.out.println("Please enter the city name(optional): ");
            cityName = bufRead.readLine();
            if (!cityName.matches("^[a-zA-Z\\s]*$")) {
                System.out.println("the city name entered is not valid");
                return;
            }
            System.out.println("Please enter your name(optional, default is 'author'): ");
            commonName = bufRead.readLine();
            System.out.println("Please enter your organization name(optional): ");
            organizationName = bufRead.readLine();
            System.out.println("Please enter your department name(optional): ");
            orgUnitName = bufRead.readLine();
            System.out.println("Please enter your email id(optional): ");
            emailId = bufRead.readLine();
            if (emailId.length() != 0 && !emailId.contains("@")) {
                System.out.println("the email id entered is not valid");
                return;
            }
            System.out.println("Please enter password for pkcs12 format key certificate: ");
            password = bufRead.readLine();
            if (password.length() == 0) {
                System.out.println("password cannot be empty.");
                return;
            }
            System.out.println("Please enter alias for generated pkcs12 structure: ");
            alias = bufRead.readLine();
            if (alias.length() == 0) {
                System.out.println("alias cannot be empty.");
                return;
            }
            System.out.println("Please enter file name for storing pkcs12 file (*.pfx or *.p12): ");
            String pkcsKeyStorePath = bufRead.readLine();
            if (pkcsKeyStorePath.length() == 0) {
                System.out.println("pkcsKeyStorePath cannot be empty.");
                return;
            }
            String osName = System.getProperty("os.name");
            if (osName.contains("Windows")) {
                if (pkcsKeyStorePath.contains("\\") || pkcsKeyStorePath.contains("/")) {
                    pkcsKeyStorePath = pkcsKeyStorePath.replace('\\', '/');
                    visited = true;
                }
                if (visited ? (split = pkcsKeyStorePath.split(seperator))[split.length - 1].contains("<") || split[split.length - 1].contains(">") || split[split.length - 1].contains("?") || split[split.length - 1].contains("*") || split[split.length - 1].contains("/") || split[split.length - 1].contains("\\") || split[split.length - 1].contains("|") || split[split.length - 1].contains(":") || split[split.length - 1].contains("\"") : pkcsKeyStorePath.contains("<") || pkcsKeyStorePath.contains(">") || pkcsKeyStorePath.contains("?") || pkcsKeyStorePath.contains("*") || pkcsKeyStorePath.contains("/") || pkcsKeyStorePath.contains("\\") || pkcsKeyStorePath.contains("|") || pkcsKeyStorePath.contains(":") || pkcsKeyStorePath.contains("\"")) {
                    throw new IllegalArgumentException("pkcsKeyStore path string should not have special characters not permissible in windows file system");
                }
            } else if (pkcsKeyStorePath.contains(seperator)) {
                split = pkcsKeyStorePath.split(seperator);
                iter = 0;
                while (iter < split.length - 1) {
                    fp = new File(split[iter]);
                    if (fp.isFile()) {
                        fp = null;
                        throw new IllegalArgumentException("pkcsKeyStore path string should not have special characters not permissible in unix type file system");
                    }
                    fp = null;
                    ++iter;
                }
            }
            if (!(directoryPath = (tizenKeyGen = new TizenKeyCertificateGenerator()).getJarPath()).getPath().contains(".jar")) {
                System.out.println("the cert generator jar is unavailable at its mentioned position");
                return;
            }
            iter = 1;
            split = directoryPath.getPath().split(seperator);
            while (!split[iter].matches(".*.jar")) {
                ++iter;
            }
            split[1] = String.valueOf(seperator) + split[1] + seperator;
            index = 2;
            while (index < iter) {
                split[1] = split[1].concat(split[index]);
                split[1] = String.valueOf(split[1]) + seperator;
                ++index;
            }
            String pathCert = split[1];
            pathCert = String.valueOf(pathCert) + DeveloperPath;
            inStream = new InputStreamReader(new FileInputStream(String.valueOf(pathCert) + DeveloperConfFile));
            bufRead = new BufferedReader(inStream);
            visited = false;
            while ((passwd = bufRead.readLine()) != null) {
                if (!passwd.matches("PASSWD_OF_ISSUER_FOR_DEV=.*")) continue;
                visited = true;
                break;
            }
            if (!visited) {
                System.out.println("The password file is either missing or doesnt have a valid entry.");
                if (bufRead != null) {
                    bufRead.close();
                }
                return;
            }
            visited = false;
            passValue = passwd.split("PASSWD_OF_ISSUER_FOR_DEV=");
            passwd = passValue[1];
            caCertPath = String.valueOf(pathCert) + "tizen-developer-ca.cer";
            caPrivKeyPath = String.valueOf(pathCert) + "tizen-developer-ca-privatekey.pem";
            index = 0;
            boolean flag = true;
            String tempCountryName = countryName;
            iter = countryName.length();
            if (tempCountryName.length() >= 2) {
                while (tempCountryName.charAt(index) == ' ') {
                    if (++index != iter) continue;
                    flag = false;
                    break;
                }
                if (flag && index < iter) {
                    countryName = Character.toString(tempCountryName.charAt(index));
                    ++index;
                }
                if (index < iter) {
                    while (tempCountryName.charAt(index) == ' ') {
                        if (++index != iter) continue;
                        flag = false;
                        break;
                    }
                }
                countryName = flag && index < iter ? String.valueOf(countryName) + Character.toString(tempCountryName.charAt(index)) : "";
            }
            if (countryName.length() != 0) {
                subjectName = "C=" + countryName;
            }
            if (stateName.length() != 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",ST=" + stateName;
            } else if (stateName.length() != 0) {
                subjectName = "ST=" + stateName;
            }
            if (cityName.length() != 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",L=" + cityName;
            } else if (cityName.length() != 0) {
                subjectName = "L=" + cityName;
            }
            if (organizationName.length() != 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",O=" + organizationName;
            } else if (organizationName.length() != 0) {
                subjectName = "O=" + organizationName;
            }
            if (orgUnitName.length() != 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",OU=" + orgUnitName;
            } else if (orgUnitName.length() != 0) {
                subjectName = "OU=" + orgUnitName;
            }
            if (emailId.length() != 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",E=" + emailId;
            } else if (emailId.length() != 0) {
                subjectName = "E=" + emailId;
            }
            if (commonName.length() != 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",CN=" + commonName;
            } else if (commonName.length() != 0 && subjectName == null) {
                subjectName = "CN=" + commonName;
            } else if (commonName.length() == 0 && subjectName != null) {
                subjectName = String.valueOf(subjectName) + ",CN=author";
            } else if (commonName.length() == 0 && subjectName == null) {
                subjectName = "CN=author";
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            tizenKeyGen.generateCertificate(subjectName, caCertPath, caPrivKeyPath, passwd);
            tizenKeyGen.GeneratePkcs12KeyStore(password, alias, pkcsKeyStorePath);
        }
        catch (KeyStoreException e) {
            System.out.println("Key store type should be PKCS12 or any other valid entry." + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Algorithm should be valid such as RSA or any other valid entry." + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            System.out.println("The Key Spec should be generated from RSAPrivateKeySpec, PKCS8privateKeySpec, EncodedKeySpec or any other reconized spec." + e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            System.out.println("Cipher object instance should be of valid algo such as PBEWithSHA1AndDESede." + e.getMessage());
        }
        catch (InvalidKeyException e) {
            System.out.println("Key should be defined for init API of Cipher Object." + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            System.out.println("Valid Algorithm Parameter should be defined for init API of Cipher Object." + e.getMessage());
        }
        catch (CertificateException e) {
            System.out.println("Pass a valid PKCS12 structure along with correct password for storing it." + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Pass a valid data for reading." + e.getMessage());
        }
        catch (InvalidParameterSpecException e) {
            System.out.println("Parameter Spec should be valid when passed for init API for AlgorithmParameters Object." + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            System.out.println("Data passed should be valid when calling doFinal API for Cipher Object." + e.getMessage());
        }
        catch (BadPaddingException e) {
            System.out.println("Data should be properly padded when calling doFinal API for Cipher Object." + e.getMessage());
        }
        catch (SignatureException e) {
            System.out.println("Generated certificate has failed because of incorrect input parameters." + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            System.out.println("Failed to validate the generated certificate with its intermediate CA." + e.getMessage());
        }
        catch (SecurityException e) {
            System.out.println("method does not permit the named directory and all necessary parent directories to be created." + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Exception caught." + e.getMessage());
        }
    }

    private URL getJarPath() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    private boolean generateCertificate(String subjectName, String caCertPath, String caPrivkeyPath, String passwd) throws IOException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, InvalidKeyException, IllegalArgumentException, Exception {
        PublicKey publicKey = null;
        SecureRandom secRandom = null;
        KeyPairGenerator keyPairGenerator = null;
        X500Name x500SubjectName = null;
        X500Name x500IssuerName = null;
        AlgorithmIdentifier sigAlgId = null;
        AlgorithmIdentifier digAlgId = null;
        RSAPrivateCrtKeyParameters caPrivateKey = null;
        X509Certificate caCertificate = null;
        ContentSigner sigGen = null;
        SubjectPublicKeyInfo pubInfo = null;
        X509v3CertificateBuilder certGen = null;
        X509CertificateHolder certHolder = null;
        X509Certificate userCertificate = null;
        RSAPrivateCrtKey privateCrtKey = null;
        try (ASN1InputStream asn1InputStream = null;){
            try {
                secRandom = new SecureRandom();
                keyPairGenerator = KeyPairGenerator.getInstance(RSAString);
                keyPairGenerator.initialize(MAXKeySize, secRandom);
                KeyPair keypair = keyPairGenerator.generateKeyPair();
                publicKey = keypair.getPublic();
                privateCrtKey = (RSAPrivateCrtKey)keypair.getPrivate();
                caCertificate = this.ImportCertificate(caCertPath, passwd);
                if (caCertificate == null) {
                    throw new IllegalArgumentException("CA Certificate or its arguments present in the conf file are incorrect. Please verify the cert or its conf file.");
                }
                x500SubjectName = new X500Name(subjectName);
                x500IssuerName = new X500Name(caCertificate.getSubjectDN().toString());
                sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(SignAlgo);
                digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
                caPrivateKey = this.ReadCaPrivateKey(caPrivkeyPath, passwd, privateCrtKey);
                if (caPrivateKey == null) {
                    throw new IllegalArgumentException("Private key or its arguments present in the conf file are incorrect. Please verify the private key or its conf file.");
                }
                sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build((AsymmetricKeyParameter)caPrivateKey);
                asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(publicKey.getEncoded()));
                pubInfo = new SubjectPublicKeyInfo((ASN1Sequence)asn1InputStream.readObject());
                GregorianCalendar startDate = new GregorianCalendar(2012, 10, 1, 0, 0, 0);
                ((Calendar)startDate).setTimeZone(TimeZone.getTimeZone("Greenwich"));
                GregorianCalendar endDate = new GregorianCalendar(2027, 0, 1, 0, 0, 0);
                ((Calendar)endDate).setTimeZone(TimeZone.getTimeZone("Greenwich"));
                certGen = new X509v3CertificateBuilder(x500IssuerName, BigInteger.valueOf(System.currentTimeMillis()), new Date(startDate.getTimeInMillis()), new Date(endDate.getTimeInMillis()), x500SubjectName, pubInfo);
                certGen.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
                certGen.addExtension(X509Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(128));
                certGen.addExtension(X509Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_codeSigning));
                certHolder = certGen.build(sigGen);
                userCertificate = new JcaX509CertificateConverter().setProvider(BC).getCertificate(certHolder);
                chain = new Certificate[2];
                TizenKeyCertificateGenerator.chain[0] = userCertificate;
                TizenKeyCertificateGenerator.chain[1] = caCertificate;
                userCertificate.checkValidity(new Date());
                userCertificate.verify(caCertificate.getPublicKey());
            }
            catch (IOException e) {
                System.out.println("Certificate read or private key reading has failed because of invalid parameters." + e.getMessage());
                throw e;
            }
            catch (SignatureException e) {
                System.out.println("Signature verification has failed." + e.getMessage());
                throw e;
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("The algorithm is invalid for KeyPairGenerator object." + e.getMessage());
                throw e;
            }
            catch (NoSuchProviderException e) {
                System.out.println("Generated certificate validation has failed." + e.getMessage());
                throw e;
            }
            catch (CertificateException e) {
                System.out.println("Certificate is not valid for reading." + e.getMessage());
                throw e;
            }
            catch (InvalidKeyException e) {
                System.out.println("CA Certificate public key is invalid for verification purpose of generated certificate." + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                System.out.println("Exception caught." + e.getMessage());
                throw e;
            }
        }
        return true;
    }

    private X509Certificate ImportCertificate(String caCertPath, String password) throws FileNotFoundException, IOException, Exception {
        X509Certificate caCert = null;
        try (BufferedReader buffReader = null;){
            Object objVal;
            Password passFinder = null;
            PEMReader pemRead = null;
            buffReader = new BufferedReader(new FileReader(caCertPath));
            if (password != null) {
                passFinder = new Password(password.toCharArray());
                pemRead = new PEMReader((Reader)buffReader, (PasswordFinder)passFinder);
            } else {
                pemRead = new PEMReader((Reader)buffReader);
            }
            while ((objVal = pemRead.readObject()) != null) {
                if (objVal instanceof X509Certificate) {
                    caCert = (X509Certificate)objVal;
                    continue;
                }
                System.out.println("Failed to read CA certificate");
            }
            pemRead.close();
            if (caCert == null) {
                System.out.println("Failed to read CA certificate");
            }
            if (buffReader != null) {
                buffReader.close();
            }
            X509Certificate x509Certificate = caCert;
            return x509Certificate;
        }
    }

    private RSAPrivateCrtKeyParameters ReadCaPrivateKey(String caPrivKeyPath, String passwd, RSAPrivateCrtKey privateCrtKey) throws IOException, FileNotFoundException, GeneralSecurityException, Exception {
        FileInputStream fileStream = null;
        RSAPrivateCrtKeyParameters caPrivateKey = null;
        RSAPrivateCrtKey privateKey = null;
        byte[] decodedString = null;
        PKCS8EncodedKeySpec p8KeySpec = null;
        PKCS8Key p8Key = null;
        try {
            fileStream = new FileInputStream(caPrivKeyPath);
            p8Key = new PKCS8Key((InputStream)fileStream, passwd.toCharArray());
            decodedString = p8Key.getDecryptedBytes();
            p8KeySpec = new PKCS8EncodedKeySpec(decodedString);
            privateKey = (RSAPrivateCrtKey)KeyFactory.getInstance(RSAString).generatePrivate(p8KeySpec);
            if (privateKey == null) {
                System.out.println("Failed to read private key file.");
                return null;
            }
            privateKeySpec = new RSAPrivateCrtKeySpec(privateCrtKey.getModulus(), privateCrtKey.getPublicExponent(), privateCrtKey.getPrivateExponent(), privateCrtKey.getPrimeP(), privateCrtKey.getPrimeQ(), privateCrtKey.getPrimeExponentP(), privateCrtKey.getPrimeExponentQ(), privateCrtKey.getCrtCoefficient());
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = caPrivateKey = new RSAPrivateCrtKeyParameters(privateKey.getModulus(), privateKey.getPublicExponent(), privateKey.getPrivateExponent(), privateKey.getPrimeP(), privateKey.getPrimeQ(), privateKey.getPrimeExponentP(), privateKey.getPrimeExponentQ(), privateKey.getCrtCoefficient());
            return rSAPrivateCrtKeyParameters;
        }
        catch (GeneralSecurityException e) {
            System.out.println("The private key passed is of not a proper encoding. It should be of PKCS8 or EncodedKeySpec format." + e.getMessage());
            throw e;
        }
        catch (FileNotFoundException e) {
            System.out.println("Private Key file not found at specified path." + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            System.out.println("Encrypted Private Key file not valid or pass a valid password to read it." + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            System.out.println("Exception caught." + e.getMessage());
            throw e;
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    private void GeneratePkcs12KeyStore(String password, String alias, String pkcsKeyStorePath) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, CertificateException, IOException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, SecurityException, Exception {
        try {
            Certificate[] certs = null;
            RSAPrivateCrtKeySpec privKeySpec = null;
            PBEParameterSpec pbeParamSpec = null;
            EncryptedPrivateKeyInfo encPrivKey = null;
            KeyStore keyStore = null;
            int count = 20;
            byte[] ciphertext = null;
            byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
            privKeySpec = TizenKeyCertificateGenerator.getKeySpec();
            certs = TizenKeyCertificateGenerator.getCerts();
            keyStore = KeyStore.getInstance(PKString);
            KeyFactory fact = KeyFactory.getInstance(RSAString);
            PrivateKey privKey = fact.generatePrivate(privKeySpec);
            pbeParamSpec = new PBEParameterSpec(salt, count);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PBEAlgorithm);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(PBEAlgorithm);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            ciphertext = pbeCipher.doFinal(privKey.getEncoded());
            AlgorithmParameters algparms = AlgorithmParameters.getInstance(PBEAlgorithm);
            algparms.init(pbeParamSpec);
            encPrivKey = new EncryptedPrivateKeyInfo(algparms, ciphertext);
            keyStore.load(null, null);
            keyStore.setKeyEntry(alias, encPrivKey.getEncoded(), certs);
            String[] split = pkcsKeyStorePath.split(seperator);
            String dirPath = split[0];
            int iter = 1;
            while (iter < split.length - 1) {
                dirPath = String.valueOf(dirPath) + seperator + split[iter];
                ++iter;
            }
            File fp = new File(dirPath);
            if ((dirPath.contains("\\") || dirPath.contains("/")) && !fp.isFile()) {
                fp.mkdirs();
            }
            FileOutputStream fOut = new FileOutputStream(pkcsKeyStorePath);
            keyStore.store(fOut, password.toCharArray());
        }
        catch (KeyStoreException e) {
            System.out.println("Key store type should be PKCS12 or any other valid entry." + e.getMessage());
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Algorithm should be valid such as RSA or any other valid entry." + e.getMessage());
            throw e;
        }
        catch (InvalidKeySpecException e) {
            System.out.println("The Key Spec should be generated from RSAPrivateKeySpec, PKCS8privateKeySpec, EncodedKeySpec or any other reconized spec." + e.getMessage());
            throw e;
        }
        catch (NoSuchPaddingException e) {
            System.out.println("Cipher object instance should be of valid algo such as PBEWithSHA1AndDESede." + e.getMessage());
            throw e;
        }
        catch (InvalidKeyException e) {
            System.out.println("Key should be defined for init API of Cipher Object." + e.getMessage());
            throw e;
        }
        catch (InvalidAlgorithmParameterException e) {
            System.out.println("Valid Algorithm Parameter should be defined for init API of Cipher Object." + e.getMessage());
            throw e;
        }
        catch (CertificateException e) {
            System.out.println("Pass a valid PKCS12 structure along with correct password for storing it." + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            System.out.println("Pass a valid path where PKCS12 structure will be stored." + e.getMessage());
            throw e;
        }
        catch (InvalidParameterSpecException e) {
            System.out.println("Parameter Spec should be valid when passed for init API for AlgorithmParameters Object." + e.getMessage());
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            System.out.println("Data passed should be valid when calling doFinal API for Cipher Object." + e.getMessage());
            throw e;
        }
        catch (BadPaddingException e) {
            System.out.println("Data should be properly padded when calling doFinal API for Cipher Object." + e.getMessage());
            throw e;
        }
        catch (SecurityException e) {
            System.out.println("method does not permit the named directory and all necessary parent directories to be created." + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            System.out.println("Exception caught." + e.getMessage());
            throw e;
        }
    }

    private static class Password
    implements PasswordFinder {
        char[] password;

        Password(char[] word) {
            this.password = word;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

