/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.implementations.ResolverLocalFilesystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.model.ISignatureXml;
import org.tizen.common.util.Assert;
import org.tizen.common.util.URIEscapeUtil;
import org.w3c.dom.Attr;

public class ResolverCustomResource
extends ResolverLocalFilesystem {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final Map<String, InputStream> isMap = new HashMap<String, InputStream>();
    protected final Map<String, String> realPathMap = new HashMap<String, String>();
    protected Map<String, ISignatureXml> authorXmlMap;

    public InputStream addInputStream(String uri, InputStream is) {
        Assert.notNull((Object)uri);
        Assert.notNull((Object)is);
        return this.isMap.put(uri, is);
    }

    public InputStream[] addInputStreams(Map<String, InputStream> isMap) {
        ArrayList<InputStream> list = new ArrayList<InputStream>();
        if (isMap != null) {
            for (String key : isMap.keySet()) {
                list.add(this.addInputStream(key, isMap.get(key)));
            }
        }
        return list.toArray(new InputStream[0]);
    }

    public InputStream removeInputStream(String uri) {
        Assert.notNull((Object)uri);
        return this.isMap.remove(uri);
    }

    public String addRealPath(String uri, String realPath) {
        Assert.notNull((Object)uri);
        Assert.notNull((Object)realPath);
        return this.realPathMap.put(uri, realPath);
    }

    public String[] addRealPaths(Map<String, String> realPathMap) {
        ArrayList<String> list = new ArrayList<String>();
        if (realPathMap != null) {
            for (String key : realPathMap.keySet()) {
                list.add(this.addRealPath(key, realPathMap.get(key)));
            }
        }
        return list.toArray(new String[0]);
    }

    public String removeRealPath(String uri) {
        Assert.notNull((Object)uri);
        return this.realPathMap.remove(uri);
    }

    public boolean hasAuthorSignatureXML() {
        return this.authorXmlMap != null && !this.authorXmlMap.isEmpty();
    }

    public void setAuthorSignatureXML(Map<String, ISignatureXml> authorXmlMap) {
        this.authorXmlMap = Collections.unmodifiableMap(authorXmlMap);
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        if (uri != null) {
            String value = uri.getValue();
            if (this.isMap.containsKey(value)) {
                return true;
            }
            if (this.hasAuthorSignatureXML() && this.authorXmlMap.containsKey(value)) {
                return true;
            }
        }
        return super.engineCanResolve(uri, baseURI);
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        if (uri == null) {
            return null;
        }
        String value = uri.getValue();
        InputStream is = null;
        try {
            URL url = new URL(new URL(baseURI), value);
            String escapedUnicode = URIEscapeUtil.decode((String)value);
            if (this.isMap.containsKey(escapedUnicode)) {
                is = this.isMap.get(escapedUnicode);
                is.reset();
            } else if (this.realPathMap.containsKey(escapedUnicode)) {
                String realPath = this.realPathMap.get(escapedUnicode);
                is = this.openStream(new File(realPath).toURI().toURL());
            } else if (this.hasAuthorSignatureXML() && this.authorXmlMap.containsKey(value)) {
                ISignatureXml signatureXml = this.authorXmlMap.get(value);
                is = signatureXml.getContent();
            } else {
                is = this.openStream(url);
            }
            XMLSignatureInput input = new XMLSignatureInput(is);
            input.setSourceURI(url.toString());
            return input;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ResourceResolverException("generic.EmptyMessage", (Exception)e, uri, baseURI);
        }
    }

    private InputStream openStream(URL url) throws IOException {
        return url.openStream();
    }
}

