/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.sa.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.sa.model.Warning;
import org.tizen.nativecommon.sa.model.WarningEvent;
import org.tizen.nativecommon.sa.model.WarningFileInfo;
import org.tizen.nativecommon.sa.model.WarningRoot;
import org.tizen.nativecommon.sa.model.WarningRootByFile;
import org.tizen.nativecommon.sa.model.WarningType;
import org.tizen.nativecommon.sa.parser.ConsolidatedReport;
import org.tizen.nativecommon.sa.parser.Event;
import org.tizen.nativecommon.sa.parser.Events;
import org.tizen.nativecommon.sa.parser.ObjectFactory;
import org.tizen.nativecommon.sa.parser.Report;

public class TizenSAResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(TizenSAResultHandler.class);
    static ObjectFactory objFactory = new ObjectFactory();
    static JAXBContext jaxbContext = null;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            String message = "cannot create JAXBContext instance (" + TizenSAResultHandler.class.getName() + ")";
            logger.error(message, (Throwable)e);
        }
    }

    public static ConsolidatedReport unmarshal(File file) {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (ConsolidatedReport)unmarshaller.unmarshal(file);
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshal", (Throwable)e);
            return null;
        }
    }

    public static WarningRoot makeTizenSAModel(File outDir) {
        Warning warning = null;
        ConsolidatedReport cReport = null;
        WarningRoot root = new WarningRoot();
        ArrayList<File> fileList = new ArrayList<File>();
        File OutDirSrc = new File(String.valueOf(outDir.toString()) + "/src");
        if (OutDirSrc.exists()) {
            outDir = OutDirSrc;
        }
        Iterator it = FileUtils.iterateFiles((File)outDir, (String[])new String[]{"xml"}, (boolean)true);
        while (it.hasNext()) {
            File file = (File)it.next();
            cReport = TizenSAResultHandler.unmarshal(file);
            if (cReport == null) {
                return null;
            }
            for (Report report : cReport.getReport()) {
                warning = TizenSAResultHandler.makeWarning(report);
                root.addWarning(warning);
            }
            fileList.add(file);
        }
        root.setResultFiles(fileList);
        for (WarningType warningType : root.getChildren()) {
            Collections.sort(warningType.getChildren(), new Comparator<Warning>(){

                @Override
                public int compare(Warning o1, Warning o2) {
                    String file2;
                    String file1 = o1.getFileInfo().getFile().getName();
                    int comparedResult = file1.compareTo(file2 = o2.getFileInfo().getFile().getName());
                    if (comparedResult == 0) {
                        Integer line1 = o1.getFileInfo().getLine();
                        Integer line2 = o2.getFileInfo().getLine();
                        comparedResult = line1.compareTo(line2);
                    }
                    return comparedResult;
                }
            });
        }
        return root;
    }

    public static WarningRootByFile makeTizenSAModelByFile(File outDir) {
        WarningRoot rootByWarning = TizenSAResultHandler.makeTizenSAModel(outDir);
        if (rootByWarning == null) {
            return null;
        }
        WarningRootByFile root = new WarningRootByFile();
        for (WarningType warningType : rootByWarning.getChildren()) {
            for (Warning warning : warningType.getChildren()) {
                Warning newWarning = new Warning(warning);
                root.addWarning(newWarning);
            }
        }
        root.setResultFiles(rootByWarning.getResultFiles());
        return root;
    }

    public static Warning makeWarning(Report report) {
        Events events = report.getEvents();
        List eventList = events.getEvent();
        Warning warning = new Warning();
        WarningEvent warningEvent = null;
        for (Event event : eventList) {
            warningEvent = TizenSAResultHandler.makeWarning(event);
            warningEvent.setParent(warning);
            warning.addChild(warningEvent);
        }
        WarningFileInfo fileInfo = new WarningFileInfo();
        fileInfo.setFile(new File(report.getFILE()));
        fileInfo.setLine(report.getLINE());
        fileInfo.setColumn(report.getCOLUMN());
        warning.setName(fileInfo.getName());
        warning.setDes(report.getDES());
        warning.setType(report.getType());
        warning.setFileInfo(fileInfo);
        return warning;
    }

    public static WarningEvent makeWarning(Event event) {
        WarningFileInfo fileInfo = new WarningFileInfo();
        fileInfo.setFile(new File(event.getFILE()));
        fileInfo.setLine(event.getLINE());
        fileInfo.setColumn(event.getCOLUMN());
        WarningEvent warningEvent = new WarningEvent();
        warningEvent.setDes(event.getDES());
        warningEvent.setId(event.getId());
        warningEvent.setFileInfo(fileInfo);
        return warningEvent;
    }
}

