/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VisitingDisplayer
extends ASTVisitor {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Stack<IASTNode> fdepth = new Stack();
    private IASTNode fRoot;

    private void updateStack(IASTNode cn) {
        boolean found = false;
        while (!this.fdepth.isEmpty() && !found) {
            IASTNode ancestor = cn.getParent();
            while (!ancestor.equals(this.fRoot)) {
                if (ancestor.equals(this.fdepth.peek())) {
                    found = true;
                    break;
                }
                ancestor = ancestor.getParent();
            }
            if (found) continue;
            this.fdepth.pop();
        }
        this.fdepth.push(cn);
    }

    private String printStackToString() {
        String retVal = "Stack : ";
        Iterator i = this.fdepth.iterator();
        while (i.hasNext()) {
            retVal = String.valueOf(retVal) + i.next() + "->";
        }
        return retVal;
    }

    private String getMarginRlativeToStackDepth() {
        String rv = "";
        int i = 0;
        while (i < this.fdepth.size()) {
            rv = String.valueOf(rv) + "   ";
            ++i;
        }
        return rv;
    }

    public VisitingDisplayer(IASTNode aRoot) {
        super(true);
        this.fRoot = aRoot;
    }

    public int visit(IASTDeclaration declaration) {
        this.updateStack((IASTNode)declaration);
        this.commonVisit((IASTNode)declaration);
        return 3;
    }

    public int visit(IASTDeclarator d) {
        this.updateStack((IASTNode)d);
        this.commonVisit((IASTNode)d);
        return 3;
    }

    public int visit(IASTTypeId t) {
        this.updateStack((IASTNode)t);
        this.commonVisit((IASTNode)t);
        return 3;
    }

    public int visit(IASTDeclSpecifier d) {
        this.updateStack((IASTNode)d);
        this.commonVisit((IASTNode)d);
        return 3;
    }

    public int visit(IASTExpression e) {
        this.updateStack((IASTNode)e);
        this.commonVisit((IASTNode)e);
        return 3;
    }

    public int visit(IASTStatement e) {
        this.updateStack((IASTNode)e);
        this.commonVisit((IASTNode)e);
        return 3;
    }

    public int visit(IASTTranslationUnit tu) {
        this.updateStack((IASTNode)tu);
        this.commonVisit((IASTNode)tu);
        return 3;
    }

    public int visit(IASTName name) {
        this.updateStack((IASTNode)name);
        this.commonVisit((IASTNode)name);
        return 3;
    }

    public int visit(IASTInitializer initializer) {
        this.updateStack((IASTNode)initializer);
        this.commonVisit((IASTNode)initializer);
        return 3;
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.updateStack((IASTNode)parameterDeclaration);
        this.commonVisit((IASTNode)parameterDeclaration);
        return 3;
    }

    public int visit(IASTArrayModifier arrayModifier) {
        this.updateStack((IASTNode)arrayModifier);
        this.commonVisit((IASTNode)arrayModifier);
        return 3;
    }

    public int visit(IASTPointerOperator ptrOperator) {
        this.updateStack((IASTNode)ptrOperator);
        this.commonVisit((IASTNode)ptrOperator);
        return 3;
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.updateStack((IASTNode)enumerator);
        this.commonVisit((IASTNode)enumerator);
        return 3;
    }

    public int visit(IASTProblem problem) {
        this.updateStack((IASTNode)problem);
        this.commonVisit((IASTNode)problem);
        return 3;
    }

    private void commonVisit(IASTNode n) {
        IASTFileLocation fl = n.getFileLocation();
        String flString = fl == null ? "null_fl" : fl.toString();
        int numOfChildren = n.getChildren().length;
        this.logger.info(String.valueOf(this.getMarginRlativeToStackDepth()) + flString + " numOfChildren: " + numOfChildren);
    }
}

