/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rds;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class RdsDeltaDetector {
    private static final Logger logger = LoggerFactory.getLogger(RdsDeltaDetector.class);
    ElementTree[] oldTrees;
    ElementTree latestTree;
    IDevice device;
    IProject project;
    String remotePath;
    String strResInfoFile = "";
    public static final String STR_TREE_FILE = ".sdk_delta.info";
    public static final String STR_TREE_DIRECTORY = "/info/";
    private static final String EMPTY_STRING = "";
    private static final String RDS_SEPARATOR = "/";
    private static final String TEMP_RESOURCE = ".temp";
    private static final int TREE_BUFFER_SIZE = 65536;
    List<String> deltaFilterDataList;
    private List<IProject> projects = new ArrayList<IProject>();
    private Map<String, ElementTree> projectTreeMap = new HashMap<String, ElementTree>();

    public RdsDeltaDetector(IDevice device, IProject project, String remotePath) {
        this.device = device;
        this.project = project;
        this.remotePath = remotePath;
        List<IProject> referencedProjects = ProjectUtil.getReferencedProjects(project);
        int size = referencedProjects.size();
        this.projects.add(project);
        if (size > 0) {
            this.projects.addAll(1, referencedProjects);
            this.oldTrees = new ElementTree[size + 1];
        } else {
            this.oldTrees = new ElementTree[1];
            this.latestTree = new ElementTree();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean readOldTree() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean readLatestTree() {
        block6: {
            DataInputStream input;
            block5: {
                String latestTreePath = RdsUtil.getInstance().getLatestSnapshotFilePath(this.project);
                File latestFile = new File(latestTreePath);
                if (!latestFile.exists()) {
                    return false;
                }
                Workspace workspace = (Workspace)this.project.getWorkspace();
                ElementTreeReader treeReader = new ElementTreeReader((IElementInfoFlattener)workspace.getSaveManager());
                input = null;
                try {
                    input = new DataInputStream((InputStream)new SafeFileInputStream(latestTreePath, String.valueOf(latestTreePath) + TEMP_RESOURCE, 65536));
                    ElementTree readTree = treeReader.readTree((DataInput)input);
                    if (readTree == null) break block5;
                    this.latestTree = readTree;
                }
                catch (IOException e) {
                    try {
                        logger.error("Failed to read latest snapshot", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose(input);
                        throw throwable;
                    }
                    IOUtil.tryClose(input);
                    break block6;
                }
                IOUtil.tryClose(input);
                return true;
            }
            IOUtil.tryClose(input);
        }
        return false;
    }

    public boolean hasOldTree() {
        return this.oldTrees != null && this.oldTrees[0] != null;
    }

    private String downloadOldTree() {
        SyncService service;
        String strLocalFile;
        block6: {
            if (this.remotePath == null) {
                return null;
            }
            String deltaFileOnRemote = String.valueOf(this.remotePath) + STR_TREE_DIRECTORY + STR_TREE_FILE;
            strLocalFile = RdsUtil.getInstance().getOldSnapshotDirPath(this.project);
            if (!RdsUtil.getInstance().mkdir(strLocalFile)) {
                return null;
            }
            service = null;
            try {
                service = this.device.getSyncService();
                SyncResult result = service.pull(this.device.getFileEntry(deltaFileOnRemote), strLocalFile);
                if (result.isOk()) break block6;
                logger.error("old snapshot pull failed: " + result.getCode() + " " + result.getMessage());
            }
            catch (IOException e) {
                try {
                    logger.error("old snapshot pull - get SyncService failed: " + this.device.getSerialNumber(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(service);
                    throw throwable;
                }
                IOUtil.tryClose(service);
                return null;
            }
            IOUtil.tryClose(service);
            return null;
        }
        IOUtil.tryClose(service);
        return String.valueOf(strLocalFile) + RDS_SEPARATOR + STR_TREE_FILE;
    }

    public List<DeltaResourceInfo> getDelta() {
        String projectPath = EMPTY_STRING;
        if (this.oldTrees == null || this.oldTrees[0] == null) {
            return null;
        }
        ArrayList<DeltaResourceInfo> deltaInfoList = new ArrayList<DeltaResourceInfo>();
        int i = 0;
        while (i < this.oldTrees.length) {
            IProject currentProject = this.projects.get(i);
            String projectName = currentProject.getName();
            IPath subTreePath = currentProject.getFullPath();
            projectPath = currentProject.getLocation().toString();
            ElementTree tree = ((Workspace)currentProject.getWorkspace()).getElementTree().getSubtree(subTreePath);
            ResourceDelta result = ResourceDeltaFactory.computeDelta((Workspace)((Workspace)currentProject.getWorkspace()), (ElementTree)this.oldTrees[i], (ElementTree)tree, (IPath)currentProject.getFullPath(), (long)-1L);
            this.getDelta(deltaInfoList, (IResourceDelta)result, projectPath, projectName);
            ++i;
        }
        return deltaInfoList;
    }

    public List<DeltaResourceInfo> getLatestDelta() {
        String projectPath = EMPTY_STRING;
        if (this.latestTree == null) {
            return null;
        }
        ArrayList<DeltaResourceInfo> deltaInfoList = new ArrayList<DeltaResourceInfo>();
        String projectName = this.project.getName();
        IPath subTreePath = this.project.getFullPath();
        projectPath = this.project.getLocation().toString();
        ElementTree tree = ((Workspace)this.project.getWorkspace()).getElementTree().getSubtree(subTreePath);
        ResourceDelta result = ResourceDeltaFactory.computeDelta((Workspace)((Workspace)this.project.getWorkspace()), (ElementTree)this.latestTree, (ElementTree)tree, (IPath)this.project.getFullPath(), (long)-1L);
        this.getDelta(deltaInfoList, (IResourceDelta)result, projectPath, projectName);
        return deltaInfoList;
    }

    public List<DeltaResourceInfo> getDelta(IProject project) {
        String projectPath = project.getLocation().toString();
        IPath subTreePath = project.getFullPath();
        ElementTree tree = ((Workspace)project.getWorkspace()).getElementTree().getSubtree(subTreePath);
        ElementTree oldTree = this.projectTreeMap.get(project.getName());
        ResourceDelta result = ResourceDeltaFactory.computeDelta((Workspace)((Workspace)project.getWorkspace()), (ElementTree)oldTree, (ElementTree)tree, (IPath)project.getFullPath(), (long)-1L);
        return this.getDelta(new ArrayList<DeltaResourceInfo>(), (IResourceDelta)result, projectPath, project.getName());
    }

    private DeltaResourceInfo addDeltaInfo(List<DeltaResourceInfo> deltaInfoList, String nodeName, String deltaFullPath, String deltaType, int resourceType, String projectName, IResource res) {
        DeltaResourceInfo resourceInfo = new DeltaResourceInfo(nodeName, deltaFullPath, null, deltaType, resourceType, projectName, res);
        deltaInfoList.add(resourceInfo);
        return resourceInfo;
    }

    public String makeDeltaFile() {
        String strLocalFile;
        block12: {
            Workspace workspace = (Workspace)this.project.getWorkspace();
            ElementTreeWriter treeWriter = new ElementTreeWriter((IElementInfoFlattener)workspace.getSaveManager());
            String strLocalDir = RdsUtil.getInstance().getSnapshotDirPath(this.project);
            RdsUtil.getInstance().mkdir(strLocalDir);
            strLocalFile = RdsUtil.getInstance().getSnapshotFilePath(this.project);
            DataOutputStream output = null;
            try {
                try {
                    output = new DataOutputStream((OutputStream)new SafeFileOutputStream(strLocalFile, String.valueOf(strLocalFile) + TEMP_RESOURCE));
                    for (IProject currentProject : this.projects) {
                        ElementTree currentTree = workspace.getElementTree().getSubtree(currentProject.getFullPath());
                        IPath currentSubTreePath = currentProject.getFullPath();
                        treeWriter.writeTree(currentTree, currentSubTreePath, -1, (DataOutput)output);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IOUtil.tryClose(output);
                    try {
                        this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(output);
                try {
                    this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
                throw throwable;
            }
            IOUtil.tryClose(output);
            try {
                this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return strLocalFile;
    }

    public List<DeltaResourceInfo> getDelta(List<DeltaResourceInfo> deltaInfoList, IResourceDelta deltaNode, String strPath, String projectName) {
        String resourceName = EMPTY_STRING;
        int resourceType = 0;
        DeltaResourceInfo resourceInfo = null;
        IResource resource = null;
        String resourcePath = EMPTY_STRING;
        IResourceDelta[] iResourceDeltaArray = deltaNode.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            resource = resourceDelta.getResource();
            resourceName = resource.getName();
            resourceType = resource.getType();
            resourcePath = String.valueOf(strPath) + RDS_SEPARATOR + resourceName;
            switch (resourceDelta.getKind()) {
                case 1: 
                case 8: {
                    this.addDeltaInfo(deltaInfoList, resourceName, resourcePath, "add", resourceType, projectName, resource);
                    this.getDelta(deltaInfoList, resourceDelta, resourcePath, projectName);
                    break;
                }
                case 4: {
                    if (2 == resourceType) {
                        this.getDelta(deltaInfoList, resourceDelta, resourcePath, projectName);
                        break;
                    }
                    if (1 != resourceType) break;
                    this.addDeltaInfo(deltaInfoList, resourceName, resourcePath, "modify", resourceType, projectName, resource);
                    break;
                }
                case 2: 
                case 16: {
                    resourceInfo = this.addDeltaInfo(deltaInfoList, resourceName, resourcePath, "delete", resourceType, projectName, resource);
                    if (2 != resourceType) break;
                    this.getDelta(resourceInfo.getChildren(), resourceDelta, resourcePath, projectName);
                    break;
                }
            }
            ++n2;
        }
        return deltaInfoList;
    }

    public List<IProject> getProjects() {
        return this.projects;
    }

    public Map<String, ElementTree> getProjectTreeMap() {
        return this.projectTreeMap;
    }
}

