/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.FileHandler;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;

public abstract class AbstractResourceParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DELIMETER = "__DEL__";
    protected final Pattern pattern;
    protected boolean read = false;
    protected FileHandler fileHandler;

    public AbstractResourceParser(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.pattern = Pattern.compile(this.getRegExp());
    }

    public boolean isRead() {
        return this.read;
    }

    protected Matcher getMatcher(String content) {
        return this.pattern.matcher(content);
    }

    protected abstract String getRegExp();

    public abstract String getResourceName();

    public boolean exists() {
        Assert.notNull((Object)this.fileHandler);
        try {
            return this.fileHandler.is(this.getResourceName(), FileHandler.Attribute.EXISTS);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public abstract void read(InputStreamReader var1) throws IOException;

    public abstract void write(OutputStreamWriter var1) throws IOException;

    public void read(File file) throws IOException {
        Assert.notNull((Object)file);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            this.read(fileReader);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fileReader});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fileReader});
    }

    public void write(File file) throws IOException {
        Assert.notNull((Object)file);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.write(fileWriter);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fileWriter});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fileWriter});
    }

    public void read() throws IOException {
        Assert.notNull((Object)this.fileHandler);
        InputStream is = null;
        try {
            is = this.fileHandler.read(this.getResourceName());
            this.read(new InputStreamReader(is));
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
    }

    public void write() throws IOException {
        Assert.notNull((Object)this.fileHandler);
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = new ByteArrayOutputStream();
            this.write(new OutputStreamWriter(baos));
            bais = new ByteArrayInputStream(baos.toByteArray());
            this.fileHandler.write(this.getResourceName(), (InputStream)bais);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{baos, bais});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{baos, bais});
    }
}

