/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IProcessList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.TizenProcessInfo;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class TizenDeviceProcessList
implements IProcessList {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    IDevice device = null;
    List<TizenProcessInfo> processInfoList;
    TizenProcessInfo[] processInfo = null;
    String[] cmdFilterPrefixes = null;
    Pattern numberPattern = Pattern.compile("[0-9]+");

    public TizenDeviceProcessList(IDevice device) {
        this(device, (String)null);
    }

    public TizenDeviceProcessList(IDevice device, String cmdFilterPrefix) {
        this(device, new String[]{cmdFilterPrefix});
    }

    public TizenDeviceProcessList(IDevice device, String ... cmdFilterPrefixes) {
        this.device = device;
        this.processInfoList = new ArrayList<TizenProcessInfo>();
        this.cmdFilterPrefixes = cmdFilterPrefixes;
    }

    public TizenProcessInfo[] getProcessList() {
        try {
            String cmdQuery = TizenPlatformConstants.CMD_PROCESS;
            MultiLineReceiver receiver = new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        String[] token = StringUtil.split((String)(line = line.trim()), (String)" ");
                        if (token.length >= 2) {
                            Matcher m = TizenDeviceProcessList.this.numberPattern.matcher(token[0]);
                            if (m.matches()) {
                                String procId = token[0];
                                String cmd = "";
                                int i = 1;
                                while (i < token.length) {
                                    cmd = String.valueOf(cmd) + token[i] + " ";
                                    ++i;
                                }
                                if (TizenDeviceProcessList.this.cmdFilterPrefixes == null || TizenDeviceProcessList.this.cmdFilterPrefixes[0] == null) {
                                    TizenProcessInfo info = new TizenProcessInfo(procId, token[1]);
                                    info.setCmd(cmd);
                                    TizenDeviceProcessList.this.processInfoList.add(info);
                                } else {
                                    String[] stringArray2 = TizenDeviceProcessList.this.cmdFilterPrefixes;
                                    int n3 = TizenDeviceProcessList.this.cmdFilterPrefixes.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        String cmdFilterPrefix = stringArray2[n4];
                                        if (cmd.startsWith(cmdFilterPrefix)) {
                                            TizenProcessInfo info = new TizenProcessInfo(procId, token[1]);
                                            info.setCmd(cmd);
                                            TizenDeviceProcessList.this.processInfoList.add(info);
                                        }
                                        ++n4;
                                    }
                                }
                            } else {
                                TizenDeviceProcessList.this.logger.error("Invalid process line - " + line);
                            }
                        }
                        ++n2;
                    }
                }
            };
            this.device.executeHostCommand(cmdQuery, (IShellOutputReceiver)receiver);
        }
        catch (IOException e) {
            this.logger.error(TizenLaunchMessages.CANNOT_GET_PROCESSLIST, (Object)e.getMessage(), (Object)e);
        }
        this.processInfo = new TizenProcessInfo[this.processInfoList.size()];
        return this.processInfoList.toArray(this.processInfo);
    }
}

