/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.templateengine.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(TemplateUtil.class);
    public static final String START_PATTERN = "$(";
    public static final String END_PATTERN = ")";
    private static final char[] PSEUDO_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final BigInteger PSEUDO_CHAR_SIZE = new BigInteger("62");
    public static final String DEFAULT_APP_ID = "93bt1p123e";
    static final String[] RESERVED_APPID = new String[]{"TIZEN", "PRIVT", "WIDGT"};
    static final int RESERVED_APPID_NUMBER = 3;

    public static String getValueAfterExpandingMacros(String string, Map<String, String> valueStore) {
        if (string == null) {
            return "";
        }
        if (valueStore == null || valueStore.size() == 0) {
            return string;
        }
        StringBuffer resultBuffer = new StringBuffer();
        int stringLength = string.length();
        int start = 0;
        int i = 0;
        while (i < stringLength) {
            if (string.charAt(i) == START_PATTERN.charAt(0)) {
                if (++i == string.length()) {
                    resultBuffer.append(string.substring(start));
                    break;
                }
                if (string.charAt(i) == START_PATTERN.charAt(1)) {
                    if (++i == string.length()) {
                        resultBuffer.append(string.substring(start));
                        break;
                    }
                    boolean found = true;
                    int keyStart = i;
                    while (string.charAt(i) != END_PATTERN.charAt(0)) {
                        if (++i != string.length()) continue;
                        resultBuffer.append(string.substring(start));
                        found = false;
                        break;
                    }
                    if (!found) break;
                    resultBuffer.append(string.substring(start, keyStart - 2));
                    String key = string.substring(keyStart, i);
                    if (valueStore.containsKey(key)) {
                        String value = valueStore.get(key);
                        resultBuffer.append(value);
                    } else {
                        resultBuffer.append(string.substring(keyStart - 2, i + 1));
                    }
                    start = i + 1;
                }
            }
            if (i == stringLength - 1) {
                resultBuffer.append(string.substring(start));
                break;
            }
            ++i;
        }
        return resultBuffer.toString();
    }

    public static List<Element> getChildrenOfElementByTag(Element element, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(tag)) {
                list.add((Element)child);
            }
            ++i;
        }
        return list;
    }

    public static List<Element> getChildrenOfElement(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                list.add((Element)child);
            }
            ++i;
        }
        return list;
    }

    public static Set<String> getReplaceKeys(String str) {
        if (str == null) {
            return new HashSet<String>();
        }
        HashSet<String> replaceStrings = new HashSet<String>();
        int start = 0;
        int end = 0;
        while ((start = str.indexOf(START_PATTERN, start)) >= 0) {
            end = str.indexOf(END_PATTERN, start);
            if (end != -1) {
                replaceStrings.add(str.substring(start + START_PATTERN.length(), end));
                start = end + END_PATTERN.length();
                continue;
            }
            ++start;
        }
        return replaceStrings;
    }

    public static void createReplaceableFile(InputStream sourceIn, String targetPath, Map<String, String> valueStore) throws IOException {
        String fileContents = null;
        fileContents = FileUtil.readFromFile((InputStream)sourceIn);
        TemplateUtil.writeReplaceableFile(fileContents, targetPath, valueStore);
    }

    public static void createReplaceableFile(URL sourceUrl, String targetPath, Map<String, String> valueStore) throws IOException {
        String fileContents = null;
        fileContents = FileUtil.readFromFile((URL)sourceUrl);
        TemplateUtil.writeReplaceableFile(fileContents, targetPath, valueStore);
    }

    public static void createReplaceableFile(String sourcePath, String targetPath, Map<String, String> valueStore) throws IOException {
        File sourceFile = new File(sourcePath);
        String fileContents = FileUtil.readTextFile((File)sourceFile, null);
        TemplateUtil.writeReplaceableFile(fileContents, targetPath, valueStore);
    }

    private static void writeReplaceableFile(String sourceContents, String targetPath, Map<String, String> valueStore) throws IOException {
        FileWriter fileWriter = null;
        try {
            boolean mkdirs;
            File targetFile = new File(targetPath);
            File parentDir = targetFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !(mkdirs = parentDir.mkdirs())) {
                logger.warn("Failed to make a directory: " + parentDir);
            }
            sourceContents = TemplateUtil.getValueAfterExpandingMacros(sourceContents, valueStore);
            fileWriter = new FileWriter(targetFile);
            fileWriter.write(sourceContents);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fileWriter});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fileWriter});
    }

    public static String generateAppId() {
        String appId = DEFAULT_APP_ID;
        do {
            try {
                appId = TemplateUtil.convertBytesToAlphaNumeric(TemplateUtil.generateRandomBytes(10), 10);
            }
            catch (GeneralSecurityException e) {
                logger.error(Messages.getString("TizenTemplateEngine.ExceptionGeneratingAppid"), (Throwable)e);
                return appId;
            }
        } while (!TemplateUtil.check(appId));
        return appId;
    }

    private static String convertBytesToAlphaNumeric(byte[] in, int size) {
        BigInteger randomBigInt = new BigInteger(in).abs();
        StringBuffer out = new StringBuffer(size + 1);
        int i = 0;
        while (i < size) {
            BigInteger[] dividedAndremainder = randomBigInt.divideAndRemainder(PSEUDO_CHAR_SIZE);
            randomBigInt = dividedAndremainder[0];
            out.append(PSEUDO_CHARS[dividedAndremainder[1].intValue()]);
            ++i;
        }
        String ret = new String(out);
        return ret;
    }

    private static byte[] generateRandomBytes(int size) throws GeneralSecurityException {
        SecureRandom random = new SecureRandom();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        SecretKey secretkey = keyGen.generateKey();
        byte[] key = secretkey.getEncoded();
        SecretKeySpec secretkeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretkeySpec);
        return cipher.doFinal(bytes);
    }

    private static boolean check(String appId) {
        int i = 0;
        while (i < 3) {
            if (appId.indexOf(RESERVED_APPID[i]) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

