/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.tidl;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.FileEditorInput;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecommon.Activator;

public class TIDLHandler
extends AbstractHandler {
    private String version;
    private static final Activator plugin = Activator.getDefault();
    private static IFile file;
    private static IWorkbenchPage page;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.version = ProjectUtil.getTizenProjectDescription((IProject)ProjectUtil.getProject((ExecutionEvent)event)).getVersion();
        page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        ISelectionProvider selProvider = viewPart.getSite().getSelectionProvider();
        IStructuredSelection structured = (IStructuredSelection)selProvider.getSelection();
        file = (IFile)structured.getFirstElement();
        IPath path = file.getLocation();
        String workingDir = String.valueOf(InstallPathConfig.getPlatformDir().toString()) + File.separator + "tizen" + "-" + this.version;
        workingDir = String.valueOf(workingDir) + File.separator + "common" + File.separator + "tidl" + File.separator;
        this.executeTIDLCommand(path.toOSString(), workingDir);
        return null;
    }

    public static void verifyTIDLOutput(String output) {
        ConsoleManager cm = new ConsoleManager("TIDLC Output", false);
        cm.clear();
        cm.showConsoleView();
        MessageConsoleStream stream = cm.getMessageConsoleStream();
        if (output.toLowerCase().contains("error")) {
            try {
                throw new Exception(output);
            }
            catch (Exception exception) {
                stream.setColor(Display.getCurrent().getSystemColor(3));
                stream.print(output);
                String editorId = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("temp.txt").getId();
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        } else if (output.isEmpty()) {
            stream.setColor(Display.getCurrent().getSystemColor(6));
            stream.print("Success!");
        }
    }

    public void executeTIDLCommand(String inputFile, String workingDir) {
        String language = plugin.getLanguagePreference();
        String outputPath = plugin.getOutputPathPreference();
        Boolean stub = plugin.getStubPreference();
        Boolean proxy = plugin.getProxyPreference();
        String cmd = "";
        if (OSChecker.isLinux()) {
            cmd = "./tidlc -i " + inputFile + " -l " + language + " -o " + outputPath;
        } else if (OSChecker.isMAC()) {
            cmd = "./tidlc -i " + inputFile + " -l " + language + " -o " + outputPath;
        } else if (OSChecker.isWindows()) {
            cmd = "tidlc -i " + inputFile + " -l " + language + " -o " + outputPath;
        }
        if (stub.booleanValue()) {
            cmd = String.valueOf(cmd) + " -s";
        }
        if (proxy.booleanValue()) {
            cmd = String.valueOf(cmd) + " -p";
        }
        TIDLHandler.verifyTIDLOutput(HostUtil.returnExecute((String)cmd, (String)workingDir, (boolean)true));
    }
}

