/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.ui.IPlatformChangedListener;
import org.tizen.sdblib.util.StringUtil;

public class PlatformChangingManager {
    private static final Logger logger = LoggerFactory.getLogger(PlatformChangingManager.class);
    public static Set<IPlatformChangedListener> changedListener = new HashSet<IPlatformChangedListener>();

    public static synchronized void addListener(IPlatformChangedListener listener) {
        changedListener.add(listener);
    }

    public static synchronized void removeListener(IPlatformChangedListener listener) {
        changedListener.remove(listener);
    }

    public static synchronized void notifyChangedPlatformListener(IConfiguration config) {
        for (IPlatformChangedListener tl : changedListener) {
            if (tl == null || !tl.getConfigName().equals(config.getName())) continue;
            tl.platformChanged(config);
        }
    }

    public static boolean changeOnlyArch(IProject srcProj, IProject dstProj, boolean setActive) {
        IConfiguration srcConfig = CommonConfigurationManager.getDefaultConfiguration(srcProj);
        if (srcConfig == null) {
            return false;
        }
        String srcArch = CommonConfigurationManager.getArchitectureFromConfiguration(srcConfig);
        return PlatformChangingManager.changePlatform(dstProj, srcArch, setActive);
    }

    public static boolean changeOnlyArch(IProject srcProj, IProject dstProj) {
        return PlatformChangingManager.changeOnlyArch(srcProj, dstProj, true);
    }

    public static boolean changePlatform(IProject project, String configName, String arch) {
        return PlatformChangingManager.changePlatform(project, configName, arch, true);
    }

    public static boolean changePlatformById(IProject project, String configId, String arch) {
        return PlatformChangingManager.changePlatform(project, configId, arch, true);
    }

    private static boolean changeToolchain(IProject project, IConfiguration config, String arch) {
        String targetName = "";
        try {
            targetName = CommonConfigurationManager.getDefaultBuildTargetNameFromArchGroup(config, arch);
        }
        catch (SBIException e) {
            e.printStackTrace();
            return false;
        }
        if (StringUtil.isEmpty((CharSequence)targetName)) {
            return false;
        }
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(project);
        if (builder == null) {
            return false;
        }
        builder.changeToolchain(config, targetName);
        return true;
    }

    private static void setConfiguration(IProject project, IConfiguration config) {
        ManagedBuildManager.getBuildInfo((IResource)project).setDefaultConfiguration(config);
    }

    private static void notifyChangingConfiguration(IConfiguration config) {
        PlatformChangingManager.notifyChangedPlatformListener(config);
    }

    public static boolean changePlatform(IProject project, String configName, String arch, boolean setActive) {
        IConfiguration targetConfig = PlatformChangingManager.getConfigurationByName(project, configName);
        IConfiguration currentConfig = CommonConfigurationManager.getDefaultConfiguration(project);
        if (targetConfig == null || currentConfig == null) {
            return false;
        }
        if (targetConfig.getName().equals(currentConfig.getName())) {
            String currentArch = CommonConfigurationManager.getArchitecture(currentConfig);
            if (CommonConfigurationManager.isSameArchType(arch, currentArch)) {
                return true;
            }
            if (PlatformChangingManager.changeToolchain(project, targetConfig, arch)) {
                if (setActive) {
                    PlatformChangingManager.setConfiguration(project, targetConfig);
                }
                PlatformChangingManager.notifyChangingConfiguration(targetConfig);
                return true;
            }
            return false;
        }
        String targetArch = CommonConfigurationManager.getArchitecture(targetConfig);
        if (CommonConfigurationManager.isSameArchType(arch, targetArch)) {
            if (setActive) {
                PlatformChangingManager.setConfiguration(project, targetConfig);
            }
            PlatformChangingManager.notifyChangedPlatformListener(targetConfig);
            return true;
        }
        if (PlatformChangingManager.changeToolchain(project, targetConfig, arch)) {
            if (setActive) {
                PlatformChangingManager.setConfiguration(project, targetConfig);
            }
            PlatformChangingManager.notifyChangingConfiguration(targetConfig);
            return true;
        }
        return false;
    }

    public static boolean changePlatformById(IProject project, String configId, String arch, boolean setActive) {
        IConfiguration config = PlatformChangingManager.getConfigurationById(project, configId);
        if (config == null) {
            return false;
        }
        String configName = config.getName();
        return PlatformChangingManager.changePlatform(project, configName, arch, true);
    }

    public static boolean changePlatform(IProject project, String arch) {
        return PlatformChangingManager.changePlatform(project, arch, true);
    }

    public static boolean changePlatform(IProject project, String arch, boolean setActive) {
        IConfiguration config = CommonConfigurationManager.getDefaultConfiguration(project);
        if (config == null) {
            return false;
        }
        return PlatformChangingManager.changePlatform(project, config.getName(), arch, setActive);
    }

    public static boolean changePlatform(String configName, IProject project) {
        IConfiguration config = PlatformChangingManager.getConfigurationByName(project, configName);
        if (config == null) {
            return false;
        }
        String arch = CommonConfigurationManager.getArchitecture(config);
        if (arch == null) {
            return false;
        }
        return PlatformChangingManager.changePlatform(project, configName, arch, true);
    }

    public static boolean changePlatformById(IProject project, String configId) {
        IConfiguration config = PlatformChangingManager.getConfigurationById(project, configId);
        if (config == null) {
            return false;
        }
        String arch = CommonConfigurationManager.getArchitecture(config);
        if (arch == null) {
            return false;
        }
        return PlatformChangingManager.changePlatform(project, configId, arch, true);
    }

    public static boolean changePlatform(IProject srcProj, IProject dstProj) {
        IConfiguration srcConfig = CommonConfigurationManager.getDefaultConfiguration(srcProj);
        if (srcConfig == null) {
            return false;
        }
        String srcArch = CommonConfigurationManager.getArchitectureFromConfiguration(srcConfig);
        return PlatformChangingManager.changePlatform(dstProj, srcConfig.getName(), srcArch, true);
    }

    public static boolean changePlatform(IProject srcProj, IProject dstProj, boolean setActive) {
        IConfiguration srcConfig = CommonConfigurationManager.getDefaultConfiguration(srcProj);
        if (srcConfig == null) {
            return false;
        }
        String srcArch = CommonConfigurationManager.getArchitectureFromConfiguration(srcConfig);
        return PlatformChangingManager.changePlatform(dstProj, srcConfig.getName(), srcArch, setActive);
    }

    public static IConfiguration getConfigurationByName(IProject project, String configName) {
        return CommonConfigurationManager.getConfigurationByName(project, configName);
    }

    public static IConfiguration getConfigurationById(IProject project, String id) {
        return CommonConfigurationManager.getConfigurationById(project, id);
    }

    public static boolean isBuiltReferencedProject(IProject project) {
        IncrementalProjectBuilder targetBuilder = PlatformChangingManager.getBuilder(project);
        if (targetBuilder == null) {
            return false;
        }
        IBuildConfiguration[] targetCfg = targetBuilder.getContext().getRequestedConfigs();
        IProject buildProj = null;
        if (targetCfg.length > 0) {
            buildProj = targetCfg[0].getProject();
            if (!project.getName().equals(buildProj.getName())) {
                return true;
            }
        }
        return false;
    }

    public static IProject getReferencingProject(IProject project) {
        String projectName = project.getName();
        IncrementalProjectBuilder targetBuilder = PlatformChangingManager.getBuilder(project);
        if (targetBuilder == null) {
            return null;
        }
        IBuildConfiguration[] targetCfg = targetBuilder.getContext().getRequestedConfigs();
        if (targetCfg.length > 0) {
            IProject targetProj = targetCfg[0].getProject();
            if (targetProj.getName().equals(projectName)) {
                return null;
            }
            return targetProj;
        }
        return null;
    }

    public static boolean cleanGeneratedRebuildResources(IProject project) {
        IConfiguration config = CommonConfigurationManager.getDefaultConfiguration(project);
        if (config == null) {
            logger.error("Failed to get default configuration: " + project);
            return false;
        }
        IncrementalProjectBuilder targetBuilder = PlatformChangingManager.getBuilder(project);
        if (targetBuilder == null) {
            return false;
        }
        int flags = 15;
        try {
            IBuildDescription des = BuildDescriptionManager.createBuildDescription((IConfiguration)config, (IResourceDelta)targetBuilder.getDelta(project), (int)flags);
            BuildDescriptionManager.cleanGeneratedRebuildResources((IBuildDescription)des);
        }
        catch (CoreException e) {
            e.printStackTrace();
            logger.info(String.format("[Platform Changing Manager] Failed to clean generated resources (%s, %s)", project.getName(), config.getName()));
            return false;
        }
        return true;
    }

    public static IBuildDescription getBuildDescription(IProject project, int flags) {
        IConfiguration config = CommonConfigurationManager.getDefaultConfiguration(project);
        IncrementalProjectBuilder targetBuilder = PlatformChangingManager.getBuilder(project);
        IBuildDescription des = null;
        if (targetBuilder != null) {
            try {
                des = BuildDescriptionManager.createBuildDescription((IConfiguration)config, (IResourceDelta)targetBuilder.getDelta(project), (int)flags);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return des;
    }

    public static boolean needChangePlatform(IProject srcProj, IProject dstProj) {
        return !CommonConfigurationManager.equalsConfig(srcProj, dstProj) || !CommonConfigurationManager.equalsArch(srcProj, dstProj);
    }

    public static IncrementalProjectBuilder getBuilder(IProject project) {
        ICommand[] commands = ((Project)project).internalGetDescription().getBuildSpec(false);
        IncrementalProjectBuilder targetBuilder = null;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            targetBuilder = (IncrementalProjectBuilder)((BuildCommand)command).getBuilders();
            if (targetBuilder != null) break;
            ++n2;
        }
        if (targetBuilder == null) {
            logger.info("[Platform Changing Manager] Failed to get IncrementalProjectBuilder instance");
        }
        return targetBuilder;
    }
}

