/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.ui.view;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.EclipseCopyHandlingCommand;
import org.tizen.common.core.command.file.EclipseMoveHandlingCommand;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.rm.model.RMChangeListener;
import org.tizen.nativecommon.rm.model.RMHandler;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.nativecommon.rm.ui.view.ConfigDialog;
import org.tizen.nativecommon.rm.ui.view.ContextMenuProvider;
import org.tizen.nativecommon.rm.ui.view.RMExpandableLayout;
import org.tizen.nativecommon.rm.ui.view.RMViewTabFolder;
import org.tizen.nativecommon.rm.ui.view.TizenRMMessages;

public class TizenRMView
extends ViewPart
implements ISelectionListener,
RMChangeListener {
    private ISelection currentSelection;
    private IProject project;
    private IProject newProject;
    private RMHandler rmHandler;
    private RMViewTabFolder tabFolder;
    private RMExpandableLayout expandable;
    private Action configAction;
    private Action pinAction;
    private Action layoutAction;
    private Composite parent;
    private Label defaultLabel;
    private ContextMenuProvider contextMenu;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SNIPPET_FORMAT = "app_resource_manager_get(APP_RESOURCE_TYPE_IMAGE, \"%s\", &res_path);";

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createToolBar();
        this.contextMenu = new ContextMenuProvider(this);
        if (this.project == null) {
            this.createDefaultLabel(TizenRMMessages.VIEW_NOT_AVAILABLE);
            this.configAction.setEnabled(false);
            return;
        }
        if (this.isSupportedProject(this.project)) {
            this.configAction.setEnabled(true);
            if (!"Switch Tab List".equals(this.layoutAction.getText())) {
                this.createTabFolder(parent);
            } else {
                this.createExpandableLayout(parent);
            }
        } else {
            this.createDefaultLabel(NLS.bind((String)TizenRMMessages.VIEW_NOT_SUPPORT_PROJECT, (Object)this.project.getName()));
            this.configAction.setEnabled(false);
        }
    }

    private void createDefaultLabel(String text) {
        if (this.defaultLabel == null) {
            this.defaultLabel = new Label(this.parent, 0);
        }
        this.defaultLabel.setText(text);
    }

    public void createTabFolder(Composite parent) {
        this.tabFolder = new RMViewTabFolder(parent, this, 0);
    }

    public void createExpandableLayout(Composite parent) {
        this.expandable = new RMExpandableLayout(parent, this);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addPostSelectionListener((ISelectionListener)this);
    }

    private void init(IProject project) {
        if (this.rmHandler != null) {
            this.rmHandler.reset(project);
        } else {
            this.rmHandler = new RMHandler(project);
            this.rmHandler.addListener(this);
        }
    }

    private void update(IProject project) {
        if (project == null) {
            this.createDefaultLabel(TizenRMMessages.VIEW_NOT_AVAILABLE);
            this.configAction.setEnabled(false);
            return;
        }
        this.init(project);
        if (!this.isSupportedProject(project)) {
            this.configAction.setEnabled(false);
            if (this.tabFolder != null) {
                this.tabFolder.dispose();
                this.tabFolder = null;
            } else if (this.expandable != null) {
                this.expandable.dispose();
                this.expandable = null;
            }
            if (this.defaultLabel == null) {
                this.createDefaultLabel(NLS.bind((String)TizenRMMessages.VIEW_NOT_SUPPORT_PROJECT, (Object)project.getName()));
            } else {
                this.defaultLabel.setText(NLS.bind((String)TizenRMMessages.VIEW_NOT_SUPPORT_PROJECT, (Object)project.getName()));
            }
        } else {
            this.configAction.setEnabled(true);
            if (this.defaultLabel != null) {
                this.defaultLabel.dispose();
                this.defaultLabel = null;
            }
            HashSet<ResConfig.Item> items = new HashSet<ResConfig.Item>();
            items.add(this.rmHandler.getDefaultType());
            items.addAll(this.rmHandler.getSupportedType());
            if (!"Switch Tab List".equals(this.layoutAction.getText())) {
                if (this.expandable != null) {
                    this.expandable.dispose();
                    this.expandable = null;
                }
                if (this.tabFolder == null) {
                    this.createTabFolder(this.parent);
                }
                this.tabFolder.update(items);
            } else {
                if (this.tabFolder != null) {
                    this.tabFolder.dispose();
                    this.tabFolder = null;
                }
                if (this.expandable == null) {
                    this.createExpandableLayout(this.parent);
                }
                this.expandable.update(items);
            }
        }
        this.parent.layout();
        this.parent.getParent().layout();
    }

    public boolean existsDefaultItem() {
        ResConfig.Item defaultItem = this.rmHandler.getDefaultType();
        IResource defaultResource = defaultItem.getResource();
        return defaultResource.exists();
    }

    public void createDefaultItem() {
        if (!this.existsDefaultItem()) {
            this.rmHandler.addDefaultFeature();
            Job saveJob = new Job("Saving build options"){

                protected IStatus run(IProgressMonitor arg0) {
                    TizenRMView.this.rmHandler.saveBuildOption();
                    if (arg0 != null) {
                        arg0.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            saveJob.schedule();
        }
    }

    private void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.createConfigAction();
        actionBars.getToolBarManager().add((IAction)this.configAction);
        actionBars.getToolBarManager().add((IAction)this.createPinAction());
        actionBars.getToolBarManager().add((IAction)this.createLayoutAction());
    }

    private Action createLayoutAction() {
        this.layoutAction = new Action(""){

            public void run() {
                if (!"Switch Tab List".equals(this.getText())) {
                    this.setText("Switch Tab List");
                    this.setToolTipText("");
                    this.setImageDescriptor(RMViewTabFolder.ENABLE_ICON);
                    this.setDisabledImageDescriptor(RMViewTabFolder.DISABLE_ICON);
                } else {
                    this.setText("Switch Folding List");
                    this.setToolTipText("");
                    this.setImageDescriptor(RMExpandableLayout.ENABLE_ICON);
                    this.setDisabledImageDescriptor(RMExpandableLayout.DISABLE_ICON);
                }
                TizenRMView.this.update(TizenRMView.this.project);
            }
        };
        this.layoutAction.setText("Switch Folding List");
        this.layoutAction.setToolTipText("");
        this.layoutAction.setImageDescriptor(RMExpandableLayout.ENABLE_ICON);
        return this.layoutAction;
    }

    private Action createPinAction() {
        this.pinAction = new Action("", 2){

            public void run() {
                if (!this.isChecked()) {
                    if (TizenRMView.this.newProject != null) {
                        TizenRMView.this.project = TizenRMView.this.newProject;
                        TizenRMView.this.newProject = null;
                    }
                    TizenRMView.this.update(TizenRMView.this.project);
                }
            }
        };
        this.pinAction.setToolTipText(TizenRMMessages.VIEW_ACTION_TOOLTIP_PIN);
        this.pinAction.setImageDescriptor(ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/elcl18/pin.png"));
        this.pinAction.setDisabledImageDescriptor(ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/dlcl18/pin.png"));
        return this.pinAction;
    }

    private Action createConfigAction() {
        this.configAction = new Action(TizenRMMessages.DIALOG_TITLE){

            public void run() {
                ConfigDialog dialog = new ConfigDialog(SWTUtil.getShell(), TizenRMView.this.rmHandler);
                dialog.open();
            }
        };
        this.configAction.setToolTipText("Config Dialog");
        this.configAction.setImageDescriptor(ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/elcl18/config.png"));
        this.configAction.setDisabledImageDescriptor(ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/dlcl18/config.png"));
        return this.configAction;
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (sel == null || part == null || !this.isImportant(part) || sel.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = sel;
        IProject newProject = ProjectUtil.getProject(part, sel);
        if (newProject == null) {
            return;
        }
        if (this.project != null && this.project.equals((Object)newProject)) {
            return;
        }
        if (this.pinAction.isChecked()) {
            this.newProject = newProject;
            return;
        }
        this.project = newProject;
        this.newProject = null;
        this.update(this.project);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        String partID = part.getSite().getId();
        boolean isRMView = this.getSite().getId().equals(partID);
        return !isRMView;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    @Override
    public void rmChagned() {
        this.rmHandler.load();
        HashSet<ResConfig.Item> items = new HashSet<ResConfig.Item>();
        items.add(this.rmHandler.getDefaultType());
        items.addAll(this.rmHandler.getSupportedType());
        if (!"Switch Tab List".equals(this.layoutAction.getText())) {
            this.tabFolder.update(items);
        } else {
            this.expandable.update(items);
        }
    }

    public Set<ResConfig.Item> getItems() {
        HashSet<ResConfig.Item> items = new HashSet<ResConfig.Item>();
        items.add(this.rmHandler.getDefaultType());
        items.addAll(this.rmHandler.getSupportedType());
        return items;
    }

    public IResource[] getKeys(ResConfig.Item item) {
        return this.rmHandler.getKeys(item);
    }

    public IProject getProject() {
        return this.project;
    }

    public void fillContextMenu(Control control) {
    }

    public List<Object> getActions(ResConfig.Item item) {
        return this.contextMenu.getActions(item);
    }

    public void doDeleteAction() {
        List<ResConfig.Key> keyList = null;
        keyList = !"Switch Tab List".equals(this.layoutAction.getText()) ? this.tabFolder.getSelectedKeys() : this.expandable.getSelectedKeys();
        if (keyList != null && !keyList.isEmpty()) {
            String message = "";
            if (keyList.size() == 1) {
                String fileName = keyList.get(0).getRes().getProjectRelativePath().toString();
                message = NLS.bind((String)TizenRMMessages.DIALOG_REMOVE_MESSAGE, (Object)fileName);
            } else {
                message = NLS.bind((String)TizenRMMessages.DIALOG_REMOVE_MESSAGE2, (Object)keyList.size());
            }
            int result = DialogUtil.openQuestionDialog((String)message);
            if (result == 64) {
                for (ResConfig.Key key : keyList) {
                    FileUtil.recursiveDelete((File)key.getRes().getLocation().toFile());
                }
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    this.logger.error("Failed to refresh after delete keys: " + this.project, (Throwable)e);
                }
            }
        }
    }

    public void doOpenAction() {
        List<ResConfig.Key> keyList = null;
        keyList = !"Switch Tab List".equals(this.layoutAction.getText()) ? this.tabFolder.getSelectedKeys() : this.expandable.getSelectedKeys();
        if (keyList != null && !keyList.isEmpty()) {
            for (ResConfig.Key key : keyList) {
                IResource res = key.getRes();
                if (1 != res.getType()) continue;
                try {
                    IDE.openEditor((IWorkbenchPage)SWTUtil.getActivePage(), (IFile)((IFile)res));
                }
                catch (PartInitException e) {
                    this.logger.error("Failed to open file: " + res, (Throwable)e);
                }
            }
        }
    }

    private ResConfig.Item StringToItem(String name) {
        for (ResConfig.Item item : this.getItems()) {
            if (!name.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    public void doCopyAction(String actionText) {
        List<ResConfig.Key> keyList = null;
        ArrayList<EclipseCopyHandlingCommand.CopyFile> copyFileList = new ArrayList<EclipseCopyHandlingCommand.CopyFile>();
        ResConfig.Item destItem = null;
        keyList = !"Switch Tab List".equals(this.layoutAction.getText()) ? this.tabFolder.getSelectedKeys() : this.expandable.getSelectedKeys();
        destItem = this.StringToItem(actionText);
        if (destItem == null) {
            return;
        }
        if (keyList != null && !keyList.isEmpty()) {
            for (ResConfig.Key source : keyList) {
                String src = source.getRes().getProjectRelativePath().toString();
                String dest = String.valueOf(destItem.getResource().getLocation().toString()) + "/" + source.getKeyString();
                copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(source.getRes().getProject(), src, dest));
            }
            EclipseCopyHandlingCommand command = new EclipseCopyHandlingCommand(copyFileList){

                protected boolean isCopyChildren() {
                    return true;
                }
            };
            CommonPlugin.getDefault().getExecutor().execute(new Command[]{command});
            try {
                destItem.getResource().refreshLocal(2, null);
            }
            catch (CoreException e) {
                this.logger.debug("Failed to call refreshLocal()", (Throwable)e);
            }
        }
    }

    public void doMoveAction(String actionText) {
        List<ResConfig.Key> keyList = null;
        ArrayList<EclipseMoveHandlingCommand.MoveFile> moveFileList = new ArrayList<EclipseMoveHandlingCommand.MoveFile>();
        ResConfig.Item destItem = null;
        keyList = !"Switch Tab List".equals(this.layoutAction.getText()) ? this.tabFolder.getSelectedKeys() : this.expandable.getSelectedKeys();
        destItem = this.StringToItem(actionText);
        if (destItem == null) {
            return;
        }
        if (keyList != null && !keyList.isEmpty()) {
            for (ResConfig.Key source : keyList) {
                String src = source.getRes().getProjectRelativePath().toString();
                String dest = String.valueOf(destItem.getResource().getLocation().toString()) + "/" + source.getKeyString();
                moveFileList.add(new EclipseMoveHandlingCommand.MoveFile(source.getRes().getProject(), src, dest));
            }
            EclipseMoveHandlingCommand command = new EclipseMoveHandlingCommand(moveFileList){

                protected boolean isCopyChildren() {
                    return true;
                }
            };
            CommonPlugin.getDefault().getExecutor().execute(new Command[]{command});
        }
    }

    private boolean isSupportedProject(IProject project) {
        return RMHandler.isSupportedProject(project);
    }
}

