/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ParsingUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.TPKException;
import org.tizen.sbilib.ide.Toolchain;

public class CommonBuildTargetManager {
    private static Logger logger = LoggerFactory.getLogger(CommonBuildTargetManager.class);
    public static final String MACRO_PLATFORM_DEFAULT_GCC_PATH = "PLATFORM_DEFAULT_GCC_PATH";
    public static final String MACRO_PLATFORM_DEFAULT_TOOLCHAIN_PREFIX = "PLATFORM_DEFAULT_GCC_PREFIX";

    public void setBuildTargetName(IConfiguration config, String targetName) {
        String c_compiler_tool_id = "org.tizen.nativeide.tool.sbi.gnu.c.compiler.base";
        String c_target_option_id = "sbi.gnu.c.compiler.option";
        String cpp_compiler_tool_id = "org.tizen.nativeide.tool.sbi.gnu.cpp.compiler.base";
        String cpp_target_option_id = "sbi.gnu.cpp.compiler.option";
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add(targetName);
        ITool compilerTool = config.getToolsBySuperClassId(c_compiler_tool_id)[0];
        IOption targetOption = compilerTool.getOptionBySuperClassId(c_target_option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)targetOption, (String[])tmpList.toArray(new String[0]));
        compilerTool = config.getToolsBySuperClassId(cpp_compiler_tool_id)[0];
        targetOption = compilerTool.getOptionBySuperClassId(cpp_target_option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)targetOption, (String[])tmpList.toArray(new String[0]));
    }

    public void setBuildTargetName(IConfiguration config, IOption option, String targetName) {
        String compiler_tool_id = "";
        compiler_tool_id = option.getBaseId().equals("sbi.gnu.c.compiler.option") ? "org.tizen.nativeide.tool.sbi.gnu.c.compiler.base" : "org.tizen.nativeide.tool.sbi.gnu.cpp.compiler.base";
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add(targetName);
        ITool compilerTool = config.getToolsBySuperClassId(compiler_tool_id)[0];
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)compilerTool, (IOption)option, (String[])tmpList.toArray(new String[0]));
    }

    public String getDefaultBuildTargetName(String platformName, String[] archs) throws SBIException {
        String defaultRootstrapId = this.getDefaultRootstrapId(platformName, archs);
        if (defaultRootstrapId == null || defaultRootstrapId.isEmpty()) {
            throw new SBIException("There is no avaiable rootstrap for architecture");
        }
        String defaultToolchainId = this.getDefaultToolchainId(defaultRootstrapId, archs);
        if (defaultToolchainId == null || defaultToolchainId.isEmpty()) {
            throw new SBIException("There is no avaiable rootstrap for architecture");
        }
        return SmartBuildInterface.makeTargetID(defaultRootstrapId, defaultToolchainId);
    }

    public String getDefaultBuildTargetName(String projectType, String toolName, String platformName, String[] archs) throws SBIException {
        String defaultRootstrapName = null;
        String defaultToolchainName = null;
        defaultToolchainName = this.getDefaultToolchain(projectType, toolName, archs);
        if (defaultToolchainName == null || defaultToolchainName.isEmpty()) {
            throw new SBIException(String.format("There is no avaiable toolchain for project type: %s and architecture", projectType));
        }
        defaultRootstrapName = this.getDefaultRootstrap(defaultToolchainName, platformName, archs);
        if (defaultRootstrapName == null || defaultRootstrapName.isEmpty()) {
            throw new SBIException(String.format("There is no avaiable rootstrap for project type: %s and architecture", projectType));
        }
        return SmartBuildInterface.makeTargetID(defaultRootstrapName, defaultToolchainName);
    }

    public String getDefaultBuildTargetName(String projectType, String toolName, String platformName, String arch) throws SBIException {
        String defaultRootstrapName = null;
        String defaultToolchainName = null;
        String[] archs = new String[]{arch};
        defaultToolchainName = this.getDefaultToolchain(projectType, toolName, archs);
        if (defaultToolchainName == null || defaultToolchainName.isEmpty()) {
            throw new SBIException(String.format("There is no avaiable toolchain for project type: %s and architecture", projectType));
        }
        defaultRootstrapName = this.getDefaultRootstrap(defaultToolchainName, platformName, archs);
        if (defaultRootstrapName == null || defaultRootstrapName.isEmpty()) {
            throw new SBIException(String.format("There is no avaiable rootstrap for project type: %s and architecture", projectType));
        }
        return SmartBuildInterface.makeTargetID(defaultRootstrapName, defaultToolchainName);
    }

    public String getDefaultBuildTargetName(IConfiguration config, String projectType) throws SBIException {
        String defaultBuildTargetName;
        block4: {
            String platformName = CommonConfigurationManager.getPlatformName(config);
            if (CommonConfigurationManager.isEmulatorConfiguration(config)) {
                return this.getDefaultBuildTargetName(platformName, CommonConfigurationManager.ARCHGROUP_X86);
            }
            if (CommonConfigurationManager.isDeviceConfiguration(config)) {
                return this.getDefaultBuildTargetName(platformName, CommonConfigurationManager.ARCHGROUP_ARM);
            }
            defaultBuildTargetName = null;
            try {
                defaultBuildTargetName = this.getDefaultBuildTargetName(platformName, CommonConfigurationManager.ARCHGROUP_X86);
            }
            catch (SBIException sBIException) {
                if (defaultBuildTargetName != null && !defaultBuildTargetName.isEmpty()) break block4;
                defaultBuildTargetName = this.getDefaultBuildTargetName(platformName, CommonConfigurationManager.ARCHGROUP_ARM);
            }
        }
        return defaultBuildTargetName;
    }

    public String getDefaultBuildTargetNameFromArchGroup(IConfiguration config, String arch, String projectType) throws SBIException {
        String platformName = CommonConfigurationManager.getPlatformName(config);
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String targetId = this.getBuildTargetName(config);
        String toolchainId = sbi.getToolchainIDFromTargetID(targetId);
        String toolName = sbi.getToolchianNameFromToolchainID(toolchainId);
        String target = "";
        try {
            target = this.getDefaultBuildTargetName(projectType, toolName, platformName, arch);
        }
        catch (SBIException sBIException) {
            target = this.getDefaultBuildTargetNameFromArchGroup(projectType, toolName, platformName, arch);
        }
        return target;
    }

    public String getDefaultBuildTargetNameFromArchGroup(String projectType, String toolName, String platformName, String arch) throws SBIException {
        if (CommonConfigurationManager.isArmArch(arch)) {
            return this.getDefaultBuildTargetName(projectType, toolName, platformName, CommonConfigurationManager.ARCHGROUP_ARM);
        }
        if (CommonConfigurationManager.isX86_64Arch(arch)) {
            return this.getDefaultBuildTargetName(projectType, toolName, platformName, CommonConfigurationManager.ARCHGROUP_X86_64);
        }
        if (CommonConfigurationManager.isArm64Arch(arch)) {
            return this.getDefaultBuildTargetName(projectType, toolName, platformName, CommonConfigurationManager.ARCHGROUP_ARM_64);
        }
        return this.getDefaultBuildTargetName(projectType, toolName, platformName, CommonConfigurationManager.ARCHGROUP_X86);
    }

    public String getBuildTargetName(IProject project) {
        IConfiguration config = CommonConfigurationManager.getDefaultConfiguration(project);
        if (config != null) {
            return this.getBuildTargetName(config);
        }
        return null;
    }

    public String getBuildTargetName(IConfiguration config) {
        String[] targetList;
        if (config == null) {
            return null;
        }
        String compiler_tool_id = "org.tizen.nativeide.tool.sbi.gnu.cpp.compiler.base";
        String target_option_id = "sbi.gnu.cpp.compiler.option";
        String target = "";
        ITool[] tools = config.getToolsBySuperClassId(compiler_tool_id);
        if (tools.length == 0) {
            return null;
        }
        ITool compilerTool = tools[0];
        IOption targetOption = compilerTool.getOptionBySuperClassId(target_option_id);
        try {
            targetList = targetOption.getUserObjects();
        }
        catch (BuildException e) {
            logger.error("Failed to get target", (Throwable)e);
            return null;
        }
        if (targetList.length != 1) {
            return null;
        }
        target = targetList[0];
        return CommonConfigurationManager.verifyTarget(config, target);
    }

    public String getBuildTargetName(String toolchainId, String rootstrapId) throws SBIException {
        return SmartBuildInterface.makeTargetID(rootstrapId, toolchainId);
    }

    public String getDefaultRootstrap(String defaultToolchainName, String platformName, String[] archs) throws SBIException {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        List<String> rootstrapList = sbi.getRootstrapList();
        ArrayList<String> availableRootstrap = new ArrayList<String>();
        String defaultRootstrapName = null;
        for (String rootStrap : rootstrapList) {
            String toolchainType;
            if (!sbi.doesRootstrapSupportToolchainType(rootStrap, toolchainType = sbi.getToolchainTypeFromToolchainID(defaultToolchainName)) || !this.containValue(archs, sbi.getArchitectureFromRootstrapID(rootStrap)) || !rootStrap.startsWith(platformName)) continue;
            availableRootstrap.add(rootStrap);
        }
        if (availableRootstrap.isEmpty()) {
            return null;
        }
        Collections.sort(availableRootstrap);
        for (String rootStrap : availableRootstrap) {
            String setDefault = sbi.getRootstrapPropertyValue(rootStrap, "DEFAULT");
            if (setDefault == null || !ParsingUtil.parseBoolean((String)setDefault, (boolean)false)) continue;
            defaultRootstrapName = rootStrap;
            break;
        }
        if (defaultRootstrapName == null || defaultRootstrapName.isEmpty()) {
            defaultRootstrapName = (String)availableRootstrap.get(0);
        }
        return defaultRootstrapName;
    }

    public String getDefaultRootstrapId(String platformName, String[] archs) {
        PluginManager pm = PluginManager.getInstance();
        String projectType = "core";
        List rsList = pm.getRootstrapList();
        for (Rootstrap rs : rsList) {
            String profile = rs.getProfile().toLowerCase();
            String version = rs.getProfileVersion().toLowerCase();
            String supportType = rs.getSupportToolchainType();
            if (!supportType.endsWith(projectType) || !this.containValue(archs, rs.getArchitecture()) || !platformName.toLowerCase().startsWith(profile) || !platformName.toLowerCase().endsWith(version)) continue;
            return rs.getId();
        }
        return null;
    }

    public String getDefaultToolchain(String projectType, String toolName, String[] archs) throws SBIException {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String defaultToolchainName = null;
        List<String> toolchainList = sbi.getToolchainList();
        ArrayList<String> availableToolchain = new ArrayList<String>();
        for (String toolchain : toolchainList) {
            String _projType;
            if (!this.containValue(archs, sbi.getArchitectureFromToolchainID(toolchain)) || (_projType = sbi.getToolchainPropertyValue(toolchain, "PROJECT_TYPE")) != null && !_projType.equals(projectType)) continue;
            availableToolchain.add(toolchain);
        }
        if (availableToolchain.isEmpty()) {
            return null;
        }
        Collections.sort(availableToolchain);
        if (toolName != null && !toolName.isEmpty()) {
            for (String toolchain : availableToolchain) {
                String toolchainName = sbi.getToolchianNameFromToolchainID(toolchain);
                if (toolchainName == null || !toolchainName.equals(toolName)) continue;
                defaultToolchainName = toolchain;
                break;
            }
        }
        if (defaultToolchainName == null || defaultToolchainName.isEmpty()) {
            for (String toolchain : availableToolchain) {
                String setDefault = sbi.getToolchainPropertyValue(toolchain, "DEFAULT");
                if (setDefault == null || !ParsingUtil.parseBoolean((String)setDefault, (boolean)false)) continue;
                defaultToolchainName = toolchain;
                break;
            }
        }
        if (defaultToolchainName == null || defaultToolchainName.isEmpty()) {
            defaultToolchainName = (String)availableToolchain.get(0);
        }
        return defaultToolchainName;
    }

    public String getDefaultToolchainId(String rootstrapId) {
        PluginManager pm = PluginManager.getInstance();
        try {
            return pm.getDefaultToolchain(rootstrapId).getId();
        }
        catch (TPKException e) {
            logger.error(String.format("can not find default toolchain: %s", rootstrapId), (Throwable)e);
            return null;
        }
    }

    public String getDefaultToolchainId(String rootstrapId, String[] archs) throws SBIException {
        if (rootstrapId != null) {
            return this.getDefaultToolchainId(rootstrapId);
        }
        return this.getDefaultToolchainFromToolchainList(null, archs);
    }

    public List<Toolchain> getDefaultToolchainList() {
        PluginManager pm = PluginManager.getInstance();
        List toolchainList = pm.getToolchainList();
        ArrayList<Toolchain> defaultTCList = new ArrayList<Toolchain>();
        for (Toolchain tc : toolchainList) {
            if (!tc.isDefault()) continue;
            defaultTCList.add(tc);
        }
        return defaultTCList;
    }

    public String getDefaultToolchainFromToolchainList(String toolName, String[] archs) {
        if (archs == null) {
            return null;
        }
        List<Toolchain> defaultTCList = this.getDefaultToolchainList();
        for (Toolchain defaultToolchain : defaultTCList) {
            if (!this.containValue(archs, defaultToolchain.getArchitecture())) continue;
            if (toolName == null) {
                return defaultToolchain.getId();
            }
            if (!toolName.equals(defaultToolchain.getName())) continue;
            return defaultToolchain.getId();
        }
        return null;
    }

    public boolean containValue(String[] strs, String value) {
        if (strs == null || value == null) {
            return false;
        }
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str == null) {
                return false;
            }
            if (str.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

