/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;

public class CommonBuildPackageFile {
    private static Logger logger = LoggerFactory.getLogger(CommonBuildPackageFile.class);
    private static final String FILE_NAME = ".package-stamp";

    public static void setPackageType(IProject project, String packageType) {
        File file = new File(String.valueOf(project.getLocation().toString()) + File.separatorChar + FILE_NAME);
        try {
            FileUtil.writeTextFile((File)file, (String)packageType, null);
        }
        catch (IOException e) {
            logger.error("Failed to write a file", (Throwable)e);
        }
    }

    public static String getPackageType(IProject project) {
        String packageType = "";
        File file = new File(String.valueOf(project.getLocation().toString()) + File.separatorChar + FILE_NAME);
        if (file.exists()) {
            try {
                packageType = FileUtil.readTextFile((File)file, null);
            }
            catch (IOException e) {
                logger.error("Failed to read a file", (Throwable)e);
            }
        }
        return packageType;
    }
}

