/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.operator.InputDecryptor;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.Streams;

public class PKCS8EncryptedPrivateKeyInfo {
    private EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;

    public PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
    }

    public EncryptedPrivateKeyInfo toASN1Structure() {
        return this.encryptedPrivateKeyInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.encryptedPrivateKeyInfo.getEncoded();
    }

    public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        InputDecryptor inputDecryptor = inputDecryptorProvider.get(this.encryptedPrivateKeyInfo.getEncryptionAlgorithm());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encryptedPrivateKeyInfo.getEncryptedData());
        try {
            return PrivateKeyInfo.getInstance((Object)Streams.readAll((InputStream)inputDecryptor.getInputStream(byteArrayInputStream)));
        }
        catch (Exception exception) {
            throw new PKCSException("unable to read encrypted data: " + exception.getMessage(), exception);
        }
    }
}

