/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.sa.view;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.sa.model.EventInfo;
import org.tizen.nativecommon.sa.model.Warning;
import org.tizen.nativecommon.sa.model.WarningFileInfo;

public class DetailTreeDoubleClickListener
implements IDoubleClickListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        Object source = event.getSource();
        if (source instanceof TreeViewer && selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            TreeViewer treeViewer = (TreeViewer)source;
            Object target = treeSelection.getFirstElement();
            if (target instanceof Warning) {
                this.openEditor(((Warning)target).getFileInfo());
            } else if (target instanceof EventInfo) {
                this.openEditor(((EventInfo)target).getFileInfo());
            } else {
                treeViewer.setExpandedState(target, !treeViewer.getExpandedState(target));
            }
        }
    }

    public void openEditor(WarningFileInfo fileInfo) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        File file = fileInfo.getFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile eclipseFile = workspace.getRoot().getFileForLocation(location);
        String editorId = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName()).getId();
        try {
            IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(eclipseFile), editorId);
            IEditorInput input = editorPart.getEditorInput();
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            provider.connect((Object)input);
            IDocument document = provider.getDocument((Object)input);
            IRegion region = document.getLineInformation(fileInfo.getLine() - 1);
            textEditor.selectAndReveal(region.getOffset(), region.getLength());
        }
        catch (Exception e) {
            this.logger.warn(String.format("Failed to open the file(%s)", file), (Throwable)e);
        }
    }
}

