/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.appfw.resourcecutter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.tizen.appfw.resourcecutter.ResourceNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResourceHandler
extends DefaultHandler {
    private static final String TAG_RES = "res";
    private static final String TAG_GROUP_IMAGE = "group-image";
    private static final String TAG_GROUP_LAYOUT = "group-layout";
    private static final String TAG_GROUP_SOUND = "group-sound";
    private static final String TAG_GROUP_BIN = "group-bin";
    private static final String TAG_NODE = "node";
    private static final String ATTR_FOLDER = "folder";
    private static final String[] ATTR_NAMES = new String[]{"screen-dpi", "screen-dpi-range", "screen-bpp", "screen-width-range", "screen-large", "platform-version", "language"};
    private List<ResourceNode> mNodes = new LinkedList<ResourceNode>();
    private boolean mIsStarted = false;
    private String mFolder;
    private int mType;

    ResourceHandler() {
    }

    List<ResourceNode> getOutput() {
        return this.mNodes;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.mNodes.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (TAG_RES.equals(localName)) {
            this.mIsStarted = true;
            return;
        }
        if (!this.mIsStarted) {
            return;
        }
        if (TAG_GROUP_IMAGE.equals(localName)) {
            this.mType = 0;
            this.mFolder = attributes.getValue(ATTR_FOLDER);
            this.mNodes.add(new ResourceNode(this.mFolder, this.mType));
            return;
        }
        if (TAG_GROUP_LAYOUT.equals(localName)) {
            this.mType = 1;
            this.mFolder = attributes.getValue(ATTR_FOLDER);
            this.mNodes.add(new ResourceNode(this.mFolder, this.mType));
            return;
        }
        if (TAG_GROUP_SOUND.equals(localName)) {
            this.mType = 2;
            this.mFolder = attributes.getValue(ATTR_FOLDER);
            this.mNodes.add(new ResourceNode(this.mFolder, this.mType));
            return;
        }
        if (TAG_GROUP_BIN.equals(localName)) {
            this.mType = 3;
            this.mFolder = attributes.getValue(ATTR_FOLDER);
            this.mNodes.add(new ResourceNode(this.mFolder, this.mType));
            return;
        }
        if (TAG_NODE.equals(localName)) {
            this.mFolder = attributes.getValue(ATTR_FOLDER);
            HashMap<String, String> map = new HashMap<String, String>();
            String[] stringArray = ATTR_NAMES;
            int n = ATTR_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String val = attributes.getValue(key);
                if (val != null) {
                    map.put(key, val);
                }
                ++n2;
            }
            this.mNodes.add(new ResourceNode(this.mFolder, this.mType, map));
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (TAG_RES.equals(localName)) {
            this.mIsStarted = false;
        }
    }
}

