/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;

public class PackageResourceInfo {
    private String name;
    private int resourceType;
    private int elementType;
    private boolean isRequirement;
    private String remotePath;
    private List<PackageResourceInfo> excludeList = new ArrayList<PackageResourceInfo>();
    public static final int NAME = 0;
    public static final int PATH = 1;
    public static final int REGEX = 2;
    public static final int EXCLUDE = 3;

    public PackageResourceInfo(String name, int resourceType, int elementType, String remotePath, boolean isRequirement) {
        this.name = name;
        this.resourceType = resourceType;
        this.elementType = elementType;
        this.remotePath = remotePath;
        this.isRequirement = isRequirement;
    }

    public String getName() {
        return this.name;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public int getElementType() {
        return this.elementType;
    }

    @Deprecated
    public String remotePath() {
        return this.remotePath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public boolean isRequirement() {
        return this.isRequirement;
    }

    public List<PackageResourceInfo> getExcludeList() {
        return this.excludeList;
    }

    public void addExcludeItem(PackageResourceInfo pkgResInfo) {
        String[] newChildSegments;
        boolean isValid = false;
        if (this.elementType != 0 || pkgResInfo.getElementType() != 3) {
            return;
        }
        String parentName = new Path(this.name).lastSegment();
        String[] stringArray = newChildSegments = new Path(pkgResInfo.getName()).segments();
        int n = newChildSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String newChildSegment = stringArray[n2];
            if (newChildSegment.equals(parentName)) {
                isValid = true;
                break;
            }
            ++n2;
        }
        if (!isValid) {
            return;
        }
        for (PackageResourceInfo exclude : this.excludeList) {
            if (!exclude.isNameMatch(pkgResInfo)) continue;
            return;
        }
        this.excludeList.add(pkgResInfo);
    }

    public boolean isSupportedType(int type) {
        if (this.resourceType == 0) {
            return true;
        }
        return this.resourceType == type;
    }

    public boolean isNameMatch(PackageResourceInfo pkgResInfo) {
        String[] newSegments;
        String[] segments = new Path(this.name).segments();
        if (segments.length != (newSegments = new Path(pkgResInfo.getName()).segments()).length) {
            return false;
        }
        int i = 0;
        while (i < segments.length) {
            if (!segments[i].equals(newSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isMatch(PackageResourceInfo pkgResInfo) {
        if (!this.isSupportedType(pkgResInfo.getResourceType())) {
            return false;
        }
        if (this.elementType != pkgResInfo.getElementType()) {
            return false;
        }
        return this.isNameMatch(pkgResInfo);
    }

    public String toString() {
        return this.getName();
    }
}

