/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.IOException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class URIEscapeUtil {
    public static String encode(String input) throws IOException {
        StringBuilder resultStr = new StringBuilder();
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (URIEscapeUtil.isNonASCII(ch)) {
                String result;
                try {
                    result = URIUtil.encodePathQuery((String)String.valueOf(ch));
                }
                catch (URIException e) {
                    throw new IOException(e);
                }
                resultStr.append(result);
            } else if (URIEscapeUtil.isUnsafe(ch)) {
                resultStr.append('%');
                resultStr.append(URIEscapeUtil.toHex(ch / 16));
                resultStr.append(URIEscapeUtil.toHex(ch % 16));
            } else {
                resultStr.append(ch);
            }
            ++n2;
        }
        return resultStr.toString();
    }

    public static String decode(String input) throws IOException {
        try {
            return URIUtil.decode((String)input);
        }
        catch (URIException e) {
            throw new IOException(e);
        }
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static boolean isUnsafe(char ch) {
        return "% <>#{}|\\^~[]`;/?@=&$!*:+".indexOf(ch) >= 0;
    }

    private static boolean isNonASCII(char ch) {
        return ch > '\u007f' || ch < '\u0000';
    }
}

