/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.unittest;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.tizen.nativecommon.unittest.IUnitTestHandler;
import org.tizen.nativecommon.unittest.UnitTestProjectInfo;

public class UnitTestRegistry {
    private static List<UnitTestProjectInfo> unittestProjectDB = new ArrayList<UnitTestProjectInfo>();
    private static final String UNITTEST_HANDLER_EXTENSION = "org.tizen.nativecommon.unittest.handler";

    public static void setTargetProjectType(IUnitTestHandler unitTestHandler, String templateId, String buildArtifactType, String projectType) {
        unittestProjectDB.add(new UnitTestProjectInfo(unitTestHandler, templateId, buildArtifactType, projectType));
    }

    public static List<UnitTestProjectInfo> getUnitTestProjectInfoList() {
        return unittestProjectDB;
    }

    public static void initializeUnitTestRegistry() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(UNITTEST_HANDLER_EXTENSION);
        IUnitTestHandler handler = null;
        String targetArtefactType = null;
        String templateName = null;
        String targetType = null;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    handler = (IUnitTestHandler)ce.createExecutableExtension("class");
                }
                catch (Exception exception) {
                    break block3;
                }
                targetArtefactType = ce.getAttribute("targetArtefactType");
                templateName = ce.getAttribute("templateName");
                targetType = ce.getAttribute("targetType");
                UnitTestRegistry.setTargetProjectType(handler, templateName, targetArtefactType, targetType);
            }
            ++n2;
        }
    }

    public static UnitTestProjectInfo getUnitTestProjectInfo(String buildArtefactType) {
        for (UnitTestProjectInfo info : unittestProjectDB) {
            if (!info.getBuildArtifactType().equals(buildArtefactType)) continue;
            return info;
        }
        return null;
    }

    public static UnitTestProjectInfo getUnitTestProjectInfo(IProject project) {
        String targetProjectType = UnitTestRegistry.getBuildArtefactType(project);
        if (targetProjectType == null) {
            return null;
        }
        return UnitTestRegistry.getUnitTestProjectInfo(targetProjectType);
    }

    public static String getBuildArtefactType(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IConfiguration cfg = info.getDefaultConfiguration();
        if (cfg == null) {
            return null;
        }
        IManagedProject managedProject = cfg.getManagedProject();
        if (managedProject == null) {
            return null;
        }
        IProjectType projectType = managedProject.getProjectType();
        if (projectType == null) {
            return null;
        }
        IBuildPropertyValue buildArtefactType = projectType.getBuildArtefactType();
        if (buildArtefactType == null) {
            return null;
        }
        return buildArtefactType.getId();
    }

    public static IUnitTestHandler getUnitTestHandler(IProject project) {
        String buildArtefactType = UnitTestRegistry.getBuildArtefactType(project);
        if (buildArtefactType == null) {
            return null;
        }
        UnitTestProjectInfo unitTestInfo = UnitTestRegistry.getUnitTestProjectInfo(buildArtefactType);
        if (unitTestInfo == null) {
            return null;
        }
        return unitTestInfo.getUnitTestHandler();
    }
}

