/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.indexer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMProjectIndexLocationConverter;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;

public class PdomRootstrapConverter
extends PDOMProjectIndexLocationConverter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IProject project;

    public PdomRootstrapConverter(IProject project, boolean ignoreWSExternal) {
        super(project, ignoreWSExternal);
        this.project = project;
    }

    private String getRootstrapPath() {
        IConfiguration config = ProjectUtil.getDefaultConfiguration(this.project);
        return this.getCanonicalPath(CommonConfigurationManager.getRootstrapPath(config));
    }

    private String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.error("Failed to get canonical path: " + path, (Throwable)e);
            return "";
        }
    }

    public String toInternalFormat(IIndexFileLocation location) {
        String rootstrapPrefix = this.getRootstrapPath();
        URI uri = location.getURI();
        if (this.getCanonicalPath(uri.getPath()).startsWith(rootstrapPrefix)) {
            return super.toInternalFormat(location);
        }
        return null;
    }
}

