/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.tizen.common.sign.model.ISignatureXml;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractSignatureXml
implements ISignatureXml {
    private Document document;

    public AbstractSignatureXml(Document document) {
        Assert.notNull((Object)document);
        this.document = document;
    }

    protected Document getDocument() {
        return this.document;
    }

    @Override
    public void writeToFileIn(String directory) throws FileNotFoundException {
        File file = new File(directory, this.getFilename());
        this.writeTo(file);
    }

    @Override
    public void writeToFileIn(File directory) throws FileNotFoundException {
        File file = new File(directory, this.getFilename());
        this.writeTo(file);
    }

    protected void writeTo(File file) throws FileNotFoundException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.writeTo(os);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{os});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{os});
    }

    @Override
    public void writeTo(OutputStream os) {
        Assert.notNull((Object)os);
        XMLUtils.outputDOM((Node)this.document, (OutputStream)os);
    }

    @Override
    public InputStream getContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

