/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.sa.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecommon.sa.model.Warning;
import org.tizen.nativecommon.sa.model.WarningFileInfo;
import org.tizen.nativecommon.sa.model.WarningType;

public class WarningRoot {
    private List<File> resultFiles = new ArrayList<File>();
    private List<WarningType> warningTypes = new ArrayList<WarningType>();

    public List<File> getResultFiles() {
        return this.resultFiles;
    }

    public List<WarningType> getChildren() {
        return this.warningTypes;
    }

    public void setResultFiles(List<File> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public void setChildren(List<WarningType> warningTypes) {
        this.warningTypes = warningTypes;
    }

    public void addChild(WarningType warningType) {
        for (WarningType oldWarningType : this.warningTypes) {
            if (!oldWarningType.getType().equals(warningType.getType())) continue;
            for (Warning warning : warningType.getChildren()) {
                oldWarningType.addChild(warning);
            }
            return;
        }
        this.warningTypes.add(warningType);
    }

    public void addWarning(Warning warning) {
        for (WarningType warningType : this.warningTypes) {
            if (!warningType.getType().equals(warning.getType())) continue;
            warning.setParent(warningType);
            warningType.addChild(warning);
            return;
        }
        WarningType newWarningType = new WarningType();
        WarningFileInfo fileInfo = warning.getFileInfo();
        newWarningType.setDes(warning.getDes());
        newWarningType.setType(warning.getType());
        newWarningType.setName(fileInfo.getName());
        newWarningType.addChild(warning);
        newWarningType.setParent(this);
        warning.setParent(newWarningType);
        this.addChild(newWarningType);
    }

    public String toString() {
        return this.resultFiles.toString();
    }
}

