/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.policy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.policy.AbstractMessagePolicy;

public interface MessagePolicy {
    public static final MessagePolicy LOGGING = new AbstractMessagePolicy(){
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        @Override
        public void print(Prompter prompter, String format, Object ... args) {
            this.logger.debug(this.format(format, args));
        }

        @Override
        public void error(Prompter prompter, String format, Object ... args) {
            this.logger.error(this.format(format, args));
        }
    };
    public static final MessagePolicy PROMPTER = new AbstractMessagePolicy(){

        @Override
        public void print(Prompter prompter, String format, Object ... args) {
            prompter.notify(this.format(format, args));
        }

        @Override
        public void error(Prompter prompter, String format, Object ... args) {
            prompter.error(this.format(format, args));
        }
    };

    public void print(Prompter var1, String var2, Object ... var3);

    public void error(Prompter var1, String var2, Object ... var3);
}

