/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tizen.sdblib.app.IApplicationType;
import org.tizen.sdblib.util.StringUtil;

public enum TizenProjectType implements IApplicationType
{
    TIZEN_C_UI_APPLICATION(true, true, true),
    TIZEN_C_COMPONENT_APPLICATION(true, true, true),
    TIZEN_CPP_COMPONENT_APPLICATION(true, true, true),
    TIZEN_C_SERVICE_APPLICATION(false, false, true),
    TIZEN_C_WATCH_APPLICATION(true, true, false),
    TIZEN_C_WIDGET_APPLICATION(true, true, true),
    TIZEN_C_IME_APPLICATION(false, false, false),
    TIZEN_C_SHAREDLIBRARY(false, false, true),
    TIZEN_C_STATICLIBRARY(false, false, false),
    TIZEN_CPP_UI_APPLICATION(true, true, true),
    TIZEN_CPP_SERVICE_APPLICATION(false, false, true),
    TIZEN_CPP_WATCH_APPLICATION(true, true, false),
    TIZEN_CPP_WIDGET_APPLICATION(true, true, true),
    TIZEN_CPP_SHAREDLIBRARY(false, false, true),
    TIZEN_CPP_STATICLIBRARY(false, false, false),
    TIZEN_CPP_UNITTEST(true, false, false),
    TIZEN_PLATFORM_PROJECT(false, false, false),
    TIZEN_WEB_APPLICATION(false, true, true),
    TIZEN_WEB_UIFW_APPLICATION(false, true, true),
    TIZEN_WEB_UIBUILDER_APPLICATION(false, true, true),
    TIZEN_WEB_WIDGET_APPLICATION(false, true, true),
    TIZEN_WEB_WATCH_APPLICATION(true, false, false);

    private boolean isNeededIconValidation;
    private boolean isRootPrj;
    private boolean isRefPrj;
    @Deprecated
    private static final Map<TizenProjectType, Set<TizenProjectType>> avalableParentsMap;
    private static final Map<TizenProjectType, Set<SubProjectType>> avalableChildrenMap;

    static {
        avalableParentsMap = new EnumMap<TizenProjectType, Set<TizenProjectType>>(TizenProjectType.class);
        avalableChildrenMap = new EnumMap<TizenProjectType, Set<SubProjectType>>(TizenProjectType.class);
        avalableParentsMap.put(TIZEN_WEB_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_WEB_WIDGET_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_WEB_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_WEB_UIBUILDER_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_WEB_UIFW_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_C_UI_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_C_UI_APPLICATION);
                this.add(TIZEN_C_IME_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_C_SERVICE_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_C_UI_APPLICATION);
                this.add(TIZEN_C_WATCH_APPLICATION);
                this.add(TIZEN_C_WIDGET_APPLICATION);
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_C_WIDGET_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_C_UI_APPLICATION);
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_CPP_UI_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_C_UI_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_CPP_SERVICE_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_CPP_UI_APPLICATION);
                this.add(TIZEN_CPP_WATCH_APPLICATION);
                this.add(TIZEN_CPP_WIDGET_APPLICATION);
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_CPP_WIDGET_APPLICATION, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_CPP_UI_APPLICATION);
                this.add(TIZEN_WEB_APPLICATION);
                this.add(TIZEN_WEB_UIBUILDER_APPLICATION);
                this.add(TIZEN_WEB_UIFW_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_C_SHAREDLIBRARY, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_C_UI_APPLICATION);
                this.add(TIZEN_C_SERVICE_APPLICATION);
                this.add(TIZEN_C_WIDGET_APPLICATION);
                this.add(TIZEN_C_WATCH_APPLICATION);
            }
        });
        avalableParentsMap.put(TIZEN_CPP_SHAREDLIBRARY, (Set<TizenProjectType>)new HashSet<TizenProjectType>(){
            {
                this.add(TIZEN_CPP_UI_APPLICATION);
                this.add(TIZEN_CPP_SERVICE_APPLICATION);
                this.add(TIZEN_CPP_WIDGET_APPLICATION);
                this.add(TIZEN_CPP_WATCH_APPLICATION);
            }
        });
        avalableChildrenMap.put(TIZEN_C_UI_APPLICATION, (Set<SubProjectType>)new HashSet<SubProjectType>(){
            {
                this.add(new SubProjectType(TIZEN_C_UI_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_SERVICE_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_WIDGET_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_SHAREDLIBRARY, SelectableReferenceNum.NATURAL));
            }
        });
        avalableChildrenMap.put(TIZEN_C_WATCH_APPLICATION, (Set<SubProjectType>)new HashSet<SubProjectType>(){
            {
                this.add(new SubProjectType(TIZEN_C_SERVICE_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_SHAREDLIBRARY, SelectableReferenceNum.NATURAL));
            }
        });
        avalableChildrenMap.put(TIZEN_C_IME_APPLICATION, (Set<SubProjectType>)new HashSet<SubProjectType>(){
            {
                this.add(new SubProjectType(TIZEN_C_UI_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_SERVICE_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_SHAREDLIBRARY, SelectableReferenceNum.NATURAL));
            }
        });
        avalableChildrenMap.put(TIZEN_WEB_APPLICATION, (Set<SubProjectType>)new HashSet<SubProjectType>(){
            {
                this.add(new SubProjectType(TIZEN_C_SERVICE_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_WIDGET_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_WEB_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_UIFW_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_UIBUILDER_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_WIDGET_APPLICATION, SelectableReferenceNum.NATURAL));
            }
        });
        avalableChildrenMap.put(TIZEN_WEB_UIBUILDER_APPLICATION, (Set<SubProjectType>)new HashSet<SubProjectType>(){
            {
                this.add(new SubProjectType(TIZEN_C_SERVICE_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_WIDGET_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_WEB_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_UIFW_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_UIBUILDER_APPLICATION, SelectableReferenceNum.ONE));
            }
        });
        avalableChildrenMap.put(TIZEN_WEB_UIFW_APPLICATION, (Set<SubProjectType>)new HashSet<SubProjectType>(){
            {
                this.add(new SubProjectType(TIZEN_C_SERVICE_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_C_WIDGET_APPLICATION, SelectableReferenceNum.NATURAL));
                this.add(new SubProjectType(TIZEN_WEB_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_UIFW_APPLICATION, SelectableReferenceNum.ONE));
                this.add(new SubProjectType(TIZEN_WEB_UIBUILDER_APPLICATION, SelectableReferenceNum.ONE));
            }
        });
    }

    private TizenProjectType(boolean isNeededIconValidation, boolean isRootPrj, boolean isRefPrj) {
        this.isNeededIconValidation = isNeededIconValidation;
        this.isRootPrj = isRootPrj;
        this.isRefPrj = isRefPrj;
    }

    public boolean isNeededIconValidation() {
        return this.isNeededIconValidation;
    }

    public boolean isRootProject() {
        return this.isRootPrj;
    }

    public boolean isRootProject(TizenProjectType childType) {
        Set<SubProjectType> childrenSet = avalableChildrenMap.get((Object)this);
        if (childrenSet == null) {
            return false;
        }
        for (SubProjectType type : childrenSet) {
            if (!type.tizenProjectType.equals((Object)childType)) continue;
            return true;
        }
        return false;
    }

    public SubProjectType getAvailableSubProjectType(TizenProjectType childType) {
        Set<SubProjectType> childrenSet = avalableChildrenMap.get((Object)this);
        if (childrenSet == null) {
            return null;
        }
        for (SubProjectType subType : childrenSet) {
            if (subType.selectableNum == SelectableReferenceNum.ZERO || !subType.tizenProjectType.equals((Object)childType)) continue;
            return subType;
        }
        return null;
    }

    public boolean isReferencedProject() {
        return this.isRefPrj;
    }

    public boolean isReferencedProject(TizenProjectType parentType) {
        Set<TizenProjectType> parentSet = avalableParentsMap.get((Object)this);
        if (parentSet == null) {
            return false;
        }
        for (TizenProjectType type : avalableParentsMap.get((Object)this)) {
            if (!type.equals((Object)parentType)) continue;
            return true;
        }
        return false;
    }

    public boolean isNativeProject() {
        switch (this) {
            case TIZEN_C_UI_APPLICATION: 
            case TIZEN_C_COMPONENT_APPLICATION: 
            case TIZEN_CPP_COMPONENT_APPLICATION: 
            case TIZEN_C_SERVICE_APPLICATION: 
            case TIZEN_C_WATCH_APPLICATION: 
            case TIZEN_C_WIDGET_APPLICATION: 
            case TIZEN_C_IME_APPLICATION: 
            case TIZEN_C_SHAREDLIBRARY: 
            case TIZEN_C_STATICLIBRARY: 
            case TIZEN_CPP_UI_APPLICATION: 
            case TIZEN_CPP_SERVICE_APPLICATION: 
            case TIZEN_CPP_WATCH_APPLICATION: 
            case TIZEN_CPP_WIDGET_APPLICATION: 
            case TIZEN_CPP_SHAREDLIBRARY: 
            case TIZEN_CPP_STATICLIBRARY: 
            case TIZEN_CPP_UNITTEST: 
            case TIZEN_PLATFORM_PROJECT: {
                return true;
            }
        }
        return false;
    }

    public boolean isNativeApplicationProject() {
        switch (this) {
            case TIZEN_C_UI_APPLICATION: 
            case TIZEN_C_COMPONENT_APPLICATION: 
            case TIZEN_CPP_COMPONENT_APPLICATION: 
            case TIZEN_C_SERVICE_APPLICATION: 
            case TIZEN_C_WATCH_APPLICATION: 
            case TIZEN_C_WIDGET_APPLICATION: 
            case TIZEN_C_IME_APPLICATION: 
            case TIZEN_CPP_UI_APPLICATION: 
            case TIZEN_CPP_SERVICE_APPLICATION: 
            case TIZEN_CPP_WATCH_APPLICATION: 
            case TIZEN_CPP_WIDGET_APPLICATION: 
            case TIZEN_CPP_UNITTEST: {
                return true;
            }
        }
        return false;
    }

    public boolean isNativeSharedLibraryProject() {
        switch (this) {
            case TIZEN_C_SHAREDLIBRARY: 
            case TIZEN_CPP_SHAREDLIBRARY: {
                return true;
            }
        }
        return false;
    }

    public boolean isNativeStaticLibraryProject() {
        switch (this) {
            case TIZEN_C_STATICLIBRARY: 
            case TIZEN_CPP_STATICLIBRARY: {
                return true;
            }
        }
        return false;
    }

    public boolean isNativeDebuggableProject() {
        switch (this) {
            case TIZEN_C_UI_APPLICATION: 
            case TIZEN_C_COMPONENT_APPLICATION: 
            case TIZEN_CPP_COMPONENT_APPLICATION: 
            case TIZEN_C_SERVICE_APPLICATION: 
            case TIZEN_C_WIDGET_APPLICATION: 
            case TIZEN_C_IME_APPLICATION: 
            case TIZEN_CPP_UI_APPLICATION: 
            case TIZEN_CPP_SERVICE_APPLICATION: 
            case TIZEN_CPP_WIDGET_APPLICATION: 
            case TIZEN_CPP_UNITTEST: {
                return true;
            }
        }
        return false;
    }

    public boolean isWebProject() {
        switch (this) {
            case TIZEN_WEB_APPLICATION: 
            case TIZEN_WEB_UIFW_APPLICATION: 
            case TIZEN_WEB_UIBUILDER_APPLICATION: 
            case TIZEN_WEB_WIDGET_APPLICATION: 
            case TIZEN_WEB_WATCH_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isPlatformProject() {
        switch (this) {
            case TIZEN_PLATFORM_PROJECT: {
                return true;
            }
        }
        return false;
    }

    public boolean isOSPProject() {
        switch (this) {
            case TIZEN_CPP_UI_APPLICATION: 
            case TIZEN_CPP_SERVICE_APPLICATION: 
            case TIZEN_CPP_WATCH_APPLICATION: 
            case TIZEN_CPP_WIDGET_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isCoreProject() {
        switch (this) {
            case TIZEN_C_UI_APPLICATION: 
            case TIZEN_C_COMPONENT_APPLICATION: 
            case TIZEN_C_SERVICE_APPLICATION: 
            case TIZEN_C_WATCH_APPLICATION: 
            case TIZEN_C_WIDGET_APPLICATION: 
            case TIZEN_C_IME_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isNativeServiceApplicationProject() {
        switch (this) {
            case TIZEN_C_SERVICE_APPLICATION: 
            case TIZEN_CPP_SERVICE_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isImeProject() {
        switch (this) {
            case TIZEN_C_IME_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public String getAppIdForLaunch(String appId) {
        if (StringUtil.isEmpty((CharSequence)appId)) {
            return appId;
        }
        if (this.equals((Object)TIZEN_C_WIDGET_APPLICATION) || this.equals((Object)TIZEN_C_WATCH_APPLICATION)) {
            return "org.tizen.widget_viewer_sdk widget_id " + appId;
        }
        return appId;
    }

    public boolean isNativeWidgetApplicationProject() {
        switch (this) {
            case TIZEN_C_WIDGET_APPLICATION: 
            case TIZEN_CPP_WIDGET_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isWebWidgetApplicationProject() {
        switch (this) {
            case TIZEN_WEB_WIDGET_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isWebWatchApplicationProject() {
        switch (this) {
            case TIZEN_WEB_WATCH_APPLICATION: {
                return true;
            }
        }
        return false;
    }

    public SelectableReferenceNum getSelectableReferenceNum(TizenProjectType childTizenProjectType) {
        SubProjectType type = this.getAvailableSubProjectType(childTizenProjectType);
        if (type != null) {
            return type.getSelectableReferenceNum();
        }
        return SelectableReferenceNum.ZERO;
    }

    public String getProjectType() {
        if (this.isWebProject()) {
            return "Web";
        }
        if (this.isNativeProject()) {
            return "Native";
        }
        return "";
    }

    public String getAppType() {
        switch (this) {
            case TIZEN_C_UI_APPLICATION: 
            case TIZEN_CPP_UI_APPLICATION: {
                return "UI";
            }
            case TIZEN_C_SERVICE_APPLICATION: 
            case TIZEN_CPP_SERVICE_APPLICATION: {
                return "Service";
            }
            case TIZEN_C_WATCH_APPLICATION: 
            case TIZEN_CPP_WATCH_APPLICATION: 
            case TIZEN_WEB_WATCH_APPLICATION: {
                return "Watch";
            }
            case TIZEN_C_WIDGET_APPLICATION: 
            case TIZEN_CPP_WIDGET_APPLICATION: 
            case TIZEN_WEB_WIDGET_APPLICATION: {
                return "Widget";
            }
            case TIZEN_C_SHAREDLIBRARY: 
            case TIZEN_C_STATICLIBRARY: 
            case TIZEN_CPP_SHAREDLIBRARY: 
            case TIZEN_CPP_STATICLIBRARY: {
                return "Library";
            }
            case TIZEN_C_IME_APPLICATION: {
                return "IME";
            }
            case TIZEN_CPP_UNITTEST: {
                return "Unittest";
            }
            case TIZEN_PLATFORM_PROJECT: {
                return "Platform";
            }
            case TIZEN_C_COMPONENT_APPLICATION: 
            case TIZEN_CPP_COMPONENT_APPLICATION: {
                return "COMPONENT";
            }
            case TIZEN_WEB_APPLICATION: 
            case TIZEN_WEB_UIFW_APPLICATION: 
            case TIZEN_WEB_UIBUILDER_APPLICATION: {
                return "";
            }
        }
        return "";
    }

    public static enum SelectableReferenceNum {
        ZERO,
        ONE,
        NATURAL;

    }

    public static class SubProjectType {
        private TizenProjectType tizenProjectType;
        private SelectableReferenceNum selectableNum;

        public SubProjectType(TizenProjectType tizenProjectType, SelectableReferenceNum selectableNum) {
            this.tizenProjectType = tizenProjectType;
            this.selectableNum = selectableNum;
        }

        public TizenProjectType getProjectType() {
            return this.tizenProjectType;
        }

        public SelectableReferenceNum getSelectableReferenceNum() {
            return this.selectableNum;
        }
    }
}

