/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.sources.FilteredSourcePackage;
import org.eclipse.osgi.internal.loader.sources.PackageSource;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class BundleLoaderSources {
    static SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final Map<String, PackageSource> pkgSources = new HashMap<String, PackageSource>();
    private final BundleLoader loader;

    public BundleLoaderSources(BundleLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource getPackageSource(String pkgName) {
        Map<String, PackageSource> map = this.pkgSources;
        synchronized (map) {
            PackageSource pkgSource = this.pkgSources.get(pkgName);
            if (pkgSource == null) {
                pkgSource = new SingleSourcePackage(pkgName, this.loader);
                this.pkgSources.put(pkgSource.getId(), pkgSource);
            }
            return pkgSource;
        }
    }

    boolean forceSourceCreation(ModuleCapability packageCapability) {
        Map<String, String> directives = packageCapability.getDirectives();
        return directives.get("exclude") != null || directives.get("exclude") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource createPackageSource(ModuleCapability packageCapability, boolean storeSource) {
        PackageSource pkgSource = null;
        String name = (String)packageCapability.getAttributes().get("osgi.wiring.package");
        String includes = packageCapability.getDirectives().get("include");
        String excludes = packageCapability.getDirectives().get("exclude");
        if (includes != null || excludes != null) {
            pkgSource = new FilteredSourcePackage(name, this.loader, includes, excludes);
        }
        if (storeSource) {
            if (pkgSource != null) {
                Map<String, PackageSource> map = this.pkgSources;
                synchronized (map) {
                    if (this.pkgSources.get(name) == null) {
                        this.pkgSources.put(pkgSource.getId(), pkgSource);
                    }
                }
            }
        } else if (pkgSource == null && (pkgSource = this.getPackageSource(name)).getClass() != SingleSourcePackage.class) {
            return new SingleSourcePackage(name, this.loader);
        }
        return pkgSource;
    }
}

