/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards.build;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.exception.TizenProcessFailureException;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativecommon.templateengine.build.model.BuildProperty;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.nativecommon.templateengine.process.TizenProcessRunner;

public class ExpressProjectGenerator
extends AbstractProjectGenerator {
    private static final String QUOAT_EXPRESS = "&quot;";
    private static final String MACRO_FRAMEWORK = "frameWork";
    private static final String TEMPLATE_FRAMEWORK = "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>";
    private static final String TEMPLATE_INC = "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>";
    private static final String TEMPLATE_CF = "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>";
    private static final String TEMPLATE_LF = "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>";

    public ExpressProjectGenerator() {
        this(new BuildProperty(){

            public void addCFlags(String cFlag) {
                super.addCFlags(cFlag.replace("\"", ExpressProjectGenerator.QUOAT_EXPRESS));
            }

            public void addIncludePath(String includePath) {
                super.addIncludePath(includePath.replace("\"", ExpressProjectGenerator.QUOAT_EXPRESS));
            }

            public void addLFlags(String lFlag) {
                super.addLFlags(lFlag.replace("\"", ExpressProjectGenerator.QUOAT_EXPRESS));
            }
        });
    }

    public ExpressProjectGenerator(BuildProperty property) {
        super(property);
    }

    protected String getQuotedString(String msg) {
        return QUOAT_EXPRESS + msg + QUOAT_EXPRESS;
    }

    public void pressPostValueStoreFromDevPkg(Map<String, String> valueStore, TizenTemplate template) {
        List frameworks = (List)template.getProperty("frameworks");
        BuildProperty emulBuildProperty = (BuildProperty)template.getProperty("emulator_buildprop");
        this.pressTemplate(valueStore, MACRO_FRAMEWORK, "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>", frameworks);
        this.pressTemplate(valueStore, "emulInc", "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>", emulBuildProperty.getIncludePathList());
        this.pressTemplate(valueStore, "emulCf", "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>", emulBuildProperty.getcFlagList());
        this.pressTemplate(valueStore, "emulLf", "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>", emulBuildProperty.getlFlagList());
    }

    private void addToolToValueStore(Map<String, String> valueStore) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String targetId = valueStore.get("emulTarget");
        try {
            String cxxCompiler = sbi.getCXXCompilerPath(targetId);
            String cCompiler = sbi.getCCompilerPath(targetId);
            String assembler = sbi.getAssemblerPath(targetId);
            String archiver = sbi.getArchiverPath(targetId);
            if (cxxCompiler != null) {
                cxxCompiler = new Path(cxxCompiler).lastSegment();
                valueStore.put("toolCppCompiler", cxxCompiler);
                valueStore.put("toolCppLinker", cxxCompiler);
            }
            if (cCompiler != null) {
                valueStore.put("toolCCompiler", new Path(cCompiler).lastSegment());
            }
            if (assembler != null) {
                valueStore.put("toolAssembler", new Path(assembler).lastSegment());
            }
            if (archiver != null) {
                valueStore.put("toolArchiver", new Path(archiver).lastSegment());
            }
        }
        catch (SBIException e) {
            e.printStackTrace();
        }
    }

    private void pressTemplate(Map<String, String> valueStore, String valueStoreKey, String template, List<String> replaceStringList) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String replaceString : replaceStringList) {
            if (i != 0) {
                buffer.append("\n");
            }
            buffer.append(String.format(template, replaceString));
            ++i;
        }
        valueStore.put(valueStoreKey, buffer.toString());
    }

    public TizenProcessRunner getTemplateProcess(String templateId, TizenTemplate template) throws TizenProcessFailureException {
        TizenProcessRunner runner = null;
        return runner;
    }

    public void createBuildFiles(Map<String, String> postValueStore, TizenTemplate template) throws TizenProcessFailureException {
    }
}

