/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.manifest;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonProjectDependentPackager;
import org.tizen.nativecommon.launch.CProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.build.NativeCoreProjectDependentPackager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;

public class CoreProjectManifest
extends CProjectLaunchCommand
implements IAdaptable {
    private static Logger logger = LoggerFactory.getLogger(CoreProjectManifest.class);
    public static final String C_ICON_PATH = "%s/" + TizenPlatformConstants.APP_ICON_INSTALL_PATH + "/%s";
    private final IProject project;
    private IXMLStore xmlManager;

    public CoreProjectManifest(IProject project) {
        this.project = project;
    }

    public void loadManifestfile() {
        this.xmlManager = this.getXmlStore();
    }

    public File getProjectDefaultIcon() {
        List<String> iconFileList = this.getProjectIconFiles();
        File iconFile = null;
        for (String iconName : iconFileList) {
            if (iconName.isEmpty() || !(iconFile = new File(String.format(C_ICON_PATH, this.project.getLocation().toOSString(), iconName))).exists()) continue;
            return iconFile;
        }
        return null;
    }

    public List<String> getProjectIconFiles() {
        if (this.xmlManager != null) {
            try {
                return this.xmlManager.getIconFileList();
            }
            catch (Exception e) {
                logger.error("Failed to get icon files of " + this.project.getName(), (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public boolean resetAppId() {
        if (this.xmlManager != null) {
            return this.xmlManager.resetAppId();
        }
        return false;
    }

    public boolean storeXml(IFile file) {
        if (file == null || this.xmlManager == null) {
            return false;
        }
        return this.xmlManager.storeXml(file);
    }

    public String generateAppId() {
        if (this.xmlManager != null) {
            return this.xmlManager.generateAppId();
        }
        return "";
    }

    public List<String> getExecutableNames() {
        if (this.xmlManager != null) {
            return this.xmlManager.getExecutableNames();
        }
        return new ArrayList<String>();
    }

    public String getPackageName() {
        return this.xmlManager.getPkgId();
    }

    public IProject getProject() {
        return this.project;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getLaunchCommand() {
        return "";
    }

    public String getDebugLaunchCommand() {
        return null;
    }

    public String getInstallCommand(File packageFile, String packageType, IDevice device) {
        return this.getInstallCommand(packageFile, packageType, TizenPlatformConstants.getAppTmpDirectory((IDevice)device), device);
    }

    public String getInstallCommand(File packageFile, String packageType, String destDirectory, IDevice device) {
        String tpkFormat = null;
        PlatformCapability capa = null;
        boolean isDebugMode = false;
        try {
            capa = device.getPlatformCapability();
            isDebugMode = "enabled".equals(capa.getPkgcmdDebugModeSupport());
        }
        catch (Exception e) {
            isDebugMode = false;
            logger.debug("Failed to get platform capability.", (Throwable)e);
        }
        tpkFormat = isDebugMode ? TizenPlatformConstants.PKG_TOOL_INSTALL_COMMAND : TizenPlatformConstants.PKG_TOOL_INSTALL_OLD_COMMAND;
        String command = String.format(tpkFormat, packageType.toLowerCase(), String.valueOf(destDirectory) + "/" + packageFile.getName());
        if ("RPM".equalsIgnoreCase(packageType)) {
            command = String.valueOf(command) + String.format("/usr/etc/package-manager/backend/oap -i %s", String.valueOf(TizenPlatformConstants.APP_INSTALL_PATH) + "/" + this.getPackageName());
        }
        return command;
    }

    public String getInstallCommand(File packageFile, String packageType, File tepPackageFile, String destDirectory, IDevice device) {
        String command = null;
        String tpkFormat = null;
        String tepFormat = null;
        PlatformCapability capa = null;
        boolean isDebugMode = false;
        try {
            capa = device.getPlatformCapability();
            isDebugMode = "enabled".equals(capa.getPkgcmdDebugModeSupport());
        }
        catch (Exception e) {
            isDebugMode = false;
            logger.debug("Failed to get platform capability.", (Throwable)e);
        }
        if (isDebugMode) {
            tpkFormat = TizenPlatformConstants.PKG_TOOL_INSTALL_COMMAND;
            tepFormat = TizenPlatformConstants.PKG_TOOL_TEP_INSTALL_COMMAND;
        } else {
            tpkFormat = TizenPlatformConstants.PKG_TOOL_INSTALL_OLD_COMMAND;
            tepFormat = TizenPlatformConstants.PKG_TOOL_TEP_INSTALL_OLD_COMMAND;
        }
        command = tepPackageFile == null ? String.format(tpkFormat, packageType.toLowerCase(), String.valueOf(destDirectory) + "/" + packageFile.getName()) : String.format(tepFormat, String.valueOf(destDirectory) + "/" + packageFile.getName(), String.valueOf(destDirectory) + "/" + tepPackageFile.getName());
        if ("RPM".equalsIgnoreCase(packageType)) {
            command = String.valueOf(command) + String.format("/usr/etc/package-manager/backend/oap -i %s", String.valueOf(TizenPlatformConstants.APP_INSTALL_PATH) + "/" + this.getPackageName());
        }
        return command;
    }

    public String getRemoveCommand(String packageType) {
        String command = String.format(TizenPlatformConstants.PKG_TOOL_REMOVE_COMMAND, "tpk", this.getPackageName());
        return command;
    }

    public String getListCommand() {
        String command = String.format(TizenPlatformConstants.PKG_TOOL_LIST_COMMAND, this.getPackageName());
        return command;
    }

    public String getArchitecture(IConfiguration config) {
        return NativeCoreConfigurationManager.getArchitecture((IConfiguration)config);
    }

    public String getBuildTargetName(IConfiguration config) {
        return NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    public String getAllCFlags(IConfiguration config) {
        return NativeCoreConfigurationManager.getAllCFlags(config);
    }

    public void doMultiAppPreProcess(CommonProjectDependentPackager packager, IProgressMonitor monitor) {
        if (packager instanceof NativeCoreProjectDependentPackager) {
            ((NativeCoreProjectDependentPackager)packager).doMultiAppPreProcess(monitor);
        }
    }

    public String getListCommandResult() {
        return this.getPackageName();
    }

    public TizenProjectType getNativeProjectType() {
        String arteType = ProjectUtil.getProjectArtefactType((IProject)this.project);
        if ("org.tizen.nativecore.buildArtefactType.app".equals(arteType)) {
            IXMLStore mStore = this.getXmlStore();
            if (mStore == null) {
                return null;
            }
            TizenProjectType projectType = mStore.getApplicationType();
            if (projectType != null && projectType == TizenProjectType.TIZEN_C_UI_APPLICATION) {
                try {
                    if (this.project.getNature("org.tizen.tizentest.nature") != null) {
                        return TizenProjectType.TIZEN_CPP_UNITTEST;
                    }
                }
                catch (CoreException coreException) {
                    logger.error("Cannot read natureIds of " + this.project);
                    return projectType;
                }
            }
            return projectType;
        }
        if ("org.tizen.nativecore.buildArtefactType.sharedLib".equals(arteType)) {
            IXMLStore mStore = this.getXmlStore();
            if (mStore == null) {
                return TizenProjectType.TIZEN_C_SHAREDLIBRARY;
            }
            if (mStore.isImeCategory()) {
                return TizenProjectType.TIZEN_C_IME_APPLICATION;
            }
            return TizenProjectType.TIZEN_C_SHAREDLIBRARY;
        }
        if ("org.tizen.nativecore.buildArtefactType.staticLib".equals(arteType)) {
            return TizenProjectType.TIZEN_C_STATICLIBRARY;
        }
        return null;
    }

    public String getLaunchCommand(ILaunchConfiguration config, boolean isDebug, boolean isGcov, boolean isTest, String args) throws CoreException {
        String runFormat;
        String debugFormat;
        if (OSChecker.isWindows()) {
            debugFormat = "-a \\\"%s\\\" -p -e -m debug -P %s -t %s %s";
            runFormat = "-a \\\"%s\\\" -p -e -m run -t %s %s";
        } else {
            debugFormat = "-a \"%s\" -p -e -m debug -P %s -t %s %s";
            runFormat = "-a \"%s\" -p -e -m run -t %s %s";
        }
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)this.project);
        xmlStore.setProject(this.project);
        xmlStore.loadXml();
        TizenProjectType projectType = ProjectUtil.getTizenProjectType((IProject)this.project);
        String appId = projectType.getAppIdForLaunch(xmlStore.getXMLDataId());
        String type = "";
        String string = args = args == null ? "" : args;
        if (isTest) {
            type = "gtest";
        }
        if (isGcov) {
            if (!StringUtil.isEmpty((CharSequence)type)) {
                type = String.valueOf(type) + ",";
            }
            type = String.valueOf(type) + "gcov";
        }
        String command = "";
        if (isDebug) {
            String gdbserverPort = LaunchUtils.getGdbserverPort((ILaunchConfiguration)config);
            command = String.format(debugFormat, appId, gdbserverPort, type, args);
        } else {
            command = String.format(runFormat, appId, type, args);
        }
        return command;
    }

    public IXMLStore getXmlStore() {
        this.xmlManager = ProjectUtil.getXmlStore((IProject)this.project, (String)"org.tizen.nativecore.ext.xmlstore.CoreXMLStore");
        if (this.xmlManager == null) {
            return null;
        }
        this.xmlManager.setProject(this.project);
        if (!this.xmlManager.loadXml()) {
            return null;
        }
        return this.xmlManager;
    }

    public String getVersion() {
        return this.xmlManager.getVersion();
    }

    public List<File> getPackageFiles() {
        return new ArrayList<File>();
    }

    public String getExeFileOnTarget() {
        return "";
    }
}

