/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.ui.dialog.NotificationIconType;
import org.tizen.common.ui.dialog.NotificationTrayPopup;
import org.tizen.common.util.CollectionUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonBuildMessages;
import org.tizen.nativecommon.build.CommonBuildPackageFile;
import org.tizen.nativecommon.build.CommonProjectDependentPackager;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecore.build.Messages;
import org.tizen.nativecore.build.NativeCheckCancelJob;
import org.tizen.nativecore.build.NativeCoreProjectDependentPackager;
import org.tizen.nativecore.build.TPKPackagingThread;
import org.tizen.nativecore.util.PackageUtil;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.model.BuildOption;

public class BuildPackageObjectAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    protected IProject project;
    protected IWorkbenchWindow window;
    private IStatus status = null;
    private String pkgType = "TPK";
    private static final Logger logger = LoggerFactory.getLogger(BuildPackageObjectAction.class);

    public BuildPackageObjectAction() {
    }

    public BuildPackageObjectAction(IProject project) {
        this();
        this.project = project;
    }

    public void run(IAction action) {
        CommonBuildPackageFile.setPackageType((IProject)this.project, (String)this.pkgType);
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.window.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    BuildPackageObjectAction.this.status = null;
                    CommonProjectDependentPackager packager = ProjectTypeManager.getProjectPackagerInstance((IProject)BuildPackageObjectAction.this.project);
                    if (packager == null) {
                        return;
                    }
                    NativeCoreProjectDependentPackager pac = new NativeCoreProjectDependentPackager(BuildPackageObjectAction.this.project);
                    IConfiguration config = packager.getCurrentConfiguration();
                    NativeCheckCancelJob cancelJob = null;
                    Thread checkCancelThread = null;
                    try {
                        int refPrjsCount = BuildPackageObjectAction.this.project.getReferencedProjects().length;
                        int totalWorkCount = refPrjsCount + 2;
                        monitor.beginTask(CommonBuildMessages.PACKAGING_APPLICATION, totalWorkCount);
                        int count = 1;
                        monitor.subTask(String.format("Building project [%s]...", BuildPackageObjectAction.this.project.getName()));
                        ResourcesPlugin.getWorkspace().build(BuildPackageObjectAction.this.project.getBuildConfigs(), 10, true, monitor);
                        String workingDir = packager.getWorkingDir(config);
                        String artifactName = ProjectUtil.getBinaryName((IProject)BuildPackageObjectAction.this.project);
                        File targetFile = new File(String.valueOf(workingDir) + File.separator + artifactName);
                        if (!targetFile.exists()) {
                            BuildPackageObjectAction.this.status = (IStatus)new Status(4, "org.tizen.nativecore", CommonBuildMessages.FAIL_TO_BUILD_PACKAGE);
                            monitor.done();
                            return;
                        }
                        monitor.worked(count++);
                        List migratingReferencedProjects = PackageUtil.getMigratingReferencedProjects((IProject)BuildPackageObjectAction.this.project);
                        if (!CollectionUtil.isEmpty((Collection)migratingReferencedProjects)) {
                            PackageUtil.migrateReferencedProjects((IProject)BuildPackageObjectAction.this.project, (List)migratingReferencedProjects);
                        }
                        monitor.subTask(String.format("Packaging project [%s]...", BuildPackageObjectAction.this.project.getName()));
                        if (packager instanceof NativeCoreProjectDependentPackager) {
                            ((NativeCoreProjectDependentPackager)packager).doMultiAppPreProcess(monitor);
                        }
                        TPK tpk = TPK.getInstance();
                        String targetID = pac.getTargetID(config);
                        BuildOption bOption = null;
                        try {
                            bOption = pac.getBuildOption(config, BuildPackageObjectAction.this.pkgType, TizenPlatformConstants.SIGNING_BUILD_PACKAGE, targetID);
                        }
                        catch (CoreException e1) {
                            throw new InvocationTargetException(e1);
                        }
                        catch (SBIException e1) {
                            throw new InvocationTargetException(e1);
                        }
                        Thread packageThread = new Thread((Runnable)new TPKPackagingThread(tpk, bOption), "packageThread");
                        cancelJob = new NativeCheckCancelJob(monitor, BuildPackageObjectAction.this.project, packageThread);
                        checkCancelThread = new Thread((Runnable)cancelJob, "checkCancelThread");
                        checkCancelThread.start();
                        packager.buildPackage(BuildPackageObjectAction.this.pkgType, TizenPlatformConstants.SIGNING_BUILD_PACKAGE, false, packageThread);
                        monitor.worked(count);
                    }
                    catch (SBIException e) {
                        e.printStackTrace();
                        BuildPackageObjectAction.this.status = (IStatus)new Status(4, "org.tizen.nativecore", CommonBuildMessages.FAIL_TO_BUILD_PACKAGE, (Throwable)e);
                        BuildPackageObjectAction.this.setFinishFlag(cancelJob, true);
                        monitor.done();
                        return;
                    }
                    catch (CoreException e) {
                        BuildPackageObjectAction.this.status = (IStatus)new Status(4, "org.tizen.nativecore", e.getMessage(), (Throwable)e);
                        BuildPackageObjectAction.this.setFinishFlag(cancelJob, true);
                        monitor.done();
                        return;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        BuildPackageObjectAction.this.setFinishFlag(cancelJob, true);
                        return;
                    }
                    catch (CommandCancelException commandCancelException) {
                        BuildPackageObjectAction.this.setFinishFlag(cancelJob, true);
                        return;
                    }
                    if (checkCancelThread != null && checkCancelThread.getState() != Thread.State.TERMINATED) {
                        if (packager.checkPackageFile(BuildPackageObjectAction.this.pkgType)) {
                            BuildPackageObjectAction.this.status = (IStatus)new Status(0, "org.tizen.nativecore", CommonBuildMessages.SUCCESS_TO_BUILD_PACKAGE);
                        } else {
                            BuildPackageObjectAction.this.status = (IStatus)new Status(4, "org.tizen.nativecore", CommonBuildMessages.FAIL_TO_BUILD_PACKAGE);
                        }
                    } else {
                        BuildPackageObjectAction.this.status = (IStatus)new Status(4, "org.tizen.nativecore", CommonBuildMessages.FAIL_TO_BUILD_PACKAGE);
                    }
                    BuildPackageObjectAction.this.setFinishFlag(cancelJob, true);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to build package", (Throwable)e);
        }
        if (this.status != null) {
            if (this.status.isOK()) {
                this.validateVersion();
                NotificationTrayPopup.notify((String)CommonBuildMessages.BUILD_RESULT, (String)this.status.getMessage(), (NotificationIconType)NotificationIconType.CHECK);
            } else {
                MessageDialog.openError((Shell)this.window.getShell(), (String)CommonBuildMessages.BUILD_RESULT, (String)this.status.getMessage());
            }
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
    }

    private void setFinishFlag(NativeCheckCancelJob cancelJob, boolean flag) {
        if (cancelJob != null) {
            cancelJob.setFinishFlag(flag);
        }
    }

    private void validateVersion() {
        String projectVersion = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)this.project).getVersion();
        if (projectVersion == null) {
            return;
        }
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)this.project);
        if (xmlStore == null) {
            return;
        }
        String manifestVersion = xmlStore.getApiVersion();
        if (!projectVersion.equals(manifestVersion)) {
            String message = NLS.bind((String)Messages.WARN_VERSION_IS_DIFFERENT, (Object)manifestVersion, (Object)projectVersion);
            NotificationTrayPopup.notify((String)Messages.TITLE_DIFFERENT_VERSION, (String)message, (NotificationIconType)NotificationIconType.INFO);
        }
    }

    protected File findFirstFilebyExtension(File searchPath, String ext) {
        File[] allFiles = searchPath.listFiles(new ExtFilter(ext));
        if (allFiles == null || allFiles.length == 0) {
            return null;
        }
        return allFiles[0];
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection _selection;
        Object obj = null;
        if (selection instanceof TreeSelection && (_selection = (TreeSelection)selection) != null) {
            obj = _selection.getFirstElement();
        }
        if (obj != null && obj instanceof IProject) {
            this.project = (IProject)obj;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public IProject getProject() {
        return this.project;
    }

    protected static class ExtFilter
    implements FilenameFilter {
        protected String ext;

        public ExtFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

