/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.manifest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.tizen.common.ITizenNativeXMLStore;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecore.manifest.parser.CoreManifestHandler;
import org.tizen.nativecore.manifest.parser.Manifest;
import org.tizen.nativecore.manifest.parser.Privileges;
import org.tizen.nativecore.manifest.parser.ServiceApplication;
import org.tizen.nativecore.manifest.parser.UiApplication;

public class CoreXmlStore
implements IXMLStore {
    public static String MANIFEST_FILE = "tizen-manifest.xml";
    private String projectPath = "";
    private File file = null;
    private Manifest manifest = null;

    public void setProject(String projectPath) {
        this.projectPath = projectPath;
        this.file = new File(String.valueOf(projectPath) + "/" + MANIFEST_FILE);
    }

    public void setProject(IProject project) {
        this.projectPath = project.getLocation().toString();
        this.file = new File(String.valueOf(this.projectPath) + "/" + MANIFEST_FILE);
        this.loadXml();
    }

    public boolean loadXml() {
        return this.loadXml(this.file);
    }

    public boolean loadXml(File file) {
        CoreManifestHandler manifestHandler = new CoreManifestHandler();
        this.manifest = manifestHandler.unmarshal(file);
        return this.manifest != null;
    }

    public boolean storeXml(File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            CoreManifestHandler manifestHandler = new CoreManifestHandler();
            manifestHandler.marshal(this.manifest, fos);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtil.tryClose((Object[])new Object[]{fos});
            return false;
        }
        catch (JAXBException jAXBException) {
            try {}
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{fos});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{fos});
            return false;
        }
        IOUtil.tryClose((Object[])new Object[]{fos});
        return false;
    }

    public List<String> getIconFileList() {
        return new ArrayList<String>();
    }

    public void addAppIdList(List<String> appIdList) {
    }

    public boolean storeXml(IFile multiAppFile) {
        return false;
    }

    public String getXMLDataId() {
        if (this.manifest == null) {
            return "";
        }
        List<Object> appList = this.manifest.getLabelOrIconOrAuthor();
        if (appList.isEmpty()) {
            return "";
        }
        for (Object obj : appList) {
            if (obj instanceof UiApplication) {
                return ((UiApplication)obj).getAppid();
            }
            if (!(obj instanceof ServiceApplication)) continue;
            return ((ServiceApplication)obj).getAppid();
        }
        return "";
    }

    public String getVersion() {
        return this.manifest.getVersion();
    }

    public String generateAppId() {
        return null;
    }

    public boolean resetAppId() {
        return false;
    }

    public TizenProjectType getApplicationType() {
        if (this.manifest == null) {
            return null;
        }
        List<Object> appList = this.manifest.getLabelOrIconOrAuthor();
        if (appList.isEmpty()) {
            return null;
        }
        for (Object obj : appList) {
            if (obj instanceof UiApplication) {
                return TizenProjectType.TIZEN_C_UI_APPLICATION;
            }
            if (!(obj instanceof ServiceApplication)) continue;
            return TizenProjectType.TIZEN_C_SERVICE_APPLICATION;
        }
        return null;
    }

    public List<String> getExecutableNames() {
        ArrayList<String> executableNameList = new ArrayList<String>();
        if (this.manifest == null) {
            return executableNameList;
        }
        List<Object> appList = this.manifest.getLabelOrIconOrAuthor();
        if (appList.isEmpty()) {
            return executableNameList;
        }
        for (Object obj : appList) {
            if (obj instanceof UiApplication) {
                executableNameList.add(((UiApplication)obj).getExec());
                continue;
            }
            if (!(obj instanceof ServiceApplication)) continue;
            executableNameList.add(((ServiceApplication)obj).getExec());
        }
        return executableNameList;
    }

    public boolean isImeCategory() {
        return false;
    }

    public boolean isSubMode() {
        return false;
    }

    public boolean isOspCompat() {
        return false;
    }

    public boolean isLaunchOnBoot() {
        return false;
    }

    public String getPkgId() {
        if (this.manifest == null) {
            return "";
        }
        List<Object> appList = this.manifest.getLabelOrIconOrAuthor();
        if (appList.isEmpty()) {
            return "";
        }
        return this.manifest.getPackage();
    }

    public void mergeManifest(ITizenNativeXMLStore refManifest) {
    }

    public Collection<String> getPrivileges() {
        List<Object> objList = this.manifest.getLabelOrIconOrAuthor();
        HashSet<String> privileges = new HashSet<String>();
        for (Object obj : objList) {
            if (!(obj instanceof Privileges)) continue;
            Privileges ps = (Privileges)obj;
            for (String privilege : ps.getPrivilege()) {
                privileges.add(privilege.toString());
            }
        }
        return privileges;
    }

    public Collection<String> getFeatures() {
        return new ArrayList<String>();
    }

    public void setId(String appId) {
        List<Object> appList = this.manifest.getLabelOrIconOrAuthor();
        if (appList.isEmpty()) {
            return;
        }
        for (Object obj : appList) {
            if (obj instanceof UiApplication) {
                ((UiApplication)obj).setAppid(appId);
                continue;
            }
            if (!(obj instanceof ServiceApplication)) continue;
            ((ServiceApplication)obj).setAppid(appId);
        }
    }

    public void setPackage(String packageId) {
        this.manifest.setPackage(packageId);
    }

    public void setVersion(String version) {
        this.manifest.setVersion(version);
    }

    public void mergeAppData(ITizenNativeXMLStore refAppXml) {
    }

    public void mergePrivData(ITizenNativeXMLStore refManifest) {
    }

    public String getProfileName() {
        return null;
    }

    public void storeXml() {
    }

    public String getApiVersion() {
        return null;
    }

    public void setApiVersion(String apiVersion) {
    }

    public void setProfileName(String profileName) {
    }
}

