/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.nativeappcommon.wizards.TizenProjectWizard;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.wizards.Messages;
import org.tizen.nativecore.wizards.TizenCoreMainWizardPage;

public class TizenCoreProjectWizard
extends TizenProjectWizard {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static boolean precompiledHeader = false;
    private static MBSWizardHandler _h_selected = null;
    private static String pkgName = "";

    public TizenCoreProjectWizard() {
        super(Messages.TizenCoreProjectWizard_0, Messages.TizenCoreProjectWizard_1);
    }

    public boolean performFinish() {
        precompiledHeader = ((TizenCoreMainWizardPage)this.fMainPage).hasPrecompiledHedaer();
        _h_selected = (MBSWizardHandler)this.fMainPage.h_selected;
        this.projectPkgName = pkgName = ((TizenCoreMainWizardPage)this.fMainPage).getPkgName();
        this.nativeTemplate = ((TizenCoreMainWizardPage)this.fMainPage).getSelectedTemplate();
        ((TizenCoreMainWizardPage)this.fMainPage).createEntryDescriptor(this.nativeTemplate);
        this.workingSets = this.getMainPage().getSelectedWorkingSets();
        return super.performFinish();
    }

    public boolean postCreateJobProcess(IProgressMonitor monitor) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.newProject);
        IConfiguration[] iConfigurationArray = info.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            config.setArtifactName(this.projectPkgName);
            ++n2;
        }
        boolean isChecked = ManagedBuildManager.saveBuildInfo((IProject)this.newProject, (boolean)true);
        monitor.beginTask("", 80);
        monitor.worked(50);
        pkgName = "";
        return isChecked;
    }

    public void addPages() {
        this.fMainPage = new TizenCoreMainWizardPage(Messages.TizenCoreProjectWizard_0, "native");
        this.fMainPage.setTitle(Messages.TizenCoreProjectWizard_title);
        this.fMainPage.setDescription(Messages.TizenCoreProjectWizard_1);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public IProject getProject(boolean defaults, boolean onFinish) {
        IProject prj = super.getProject(defaults, onFinish);
        NativeCoreConfigurationManager.setProjectVersion((IProject)prj, (String)"1.0.0", (boolean)false);
        NativeCoreConfigurationManager.setInitialDebugDefinitionSymbolIfNeeded(prj, false);
        ManagedBuildManager.saveBuildInfo((IProject)prj, (boolean)true);
        return prj;
    }

    public static boolean hasPrecompiledHeader() {
        return precompiledHeader;
    }

    public static String getPkgName() {
        return pkgName;
    }

    public static String getAppName() {
        if (StringUtil.isEmpty((CharSequence)pkgName)) {
            return "";
        }
        String[] pkgNameSplited = pkgName.split("\\.");
        String appName = pkgNameSplited[pkgNameSplited.length - 1].toLowerCase();
        return appName;
    }

    public static MBSWizardHandler getHSelected() {
        return _h_selected;
    }

    protected TizenTemplate getTizenTemplate(String samplePath, String projectName, String projectLocation) {
        TizenTemplate result = super.getTizenTemplate(samplePath, projectName, projectLocation);
        if (((TizenCoreMainWizardPage)this.fMainPage).hasPrecompiledHedaer()) {
            result.setProperty("pcheader", (Object)"true");
        }
        return result;
    }

    protected AbstractProjectGenerator getBuildFileGenerator() {
        return null;
    }
}

