/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.makefile;

import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.tizen.nativecore.build.makefile.NativeCoreMakeFileGenerator;
import org.tizen.nativecore.build.makefile.NativeCoreNinjaFileGenerator;

public class NativeCoreBuildFileGenerator
implements IManagedBuilderMakefileGenerator2 {
    private boolean isusingNinja = false;
    private boolean buildToolChanged = false;
    private IManagedBuilderMakefileGenerator2 generator;

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        IConfiguration config = info.getDefaultConfiguration();
        IBuilder builder = config.getEditableBuilder();
        this.isusingNinja = builder.getCommand().startsWith("ninja");
        if (this.isusingNinja) {
            boolean bl = this.buildToolChanged = !(this.generator instanceof NativeCoreNinjaFileGenerator);
            if (this.generator == null || this.buildToolChanged) {
                this.generator = new NativeCoreNinjaFileGenerator();
            }
        } else {
            boolean bl = this.buildToolChanged = !(this.generator instanceof NativeCoreNinjaFileGenerator);
            if (this.generator == null || this.buildToolChanged) {
                this.generator = new NativeCoreMakeFileGenerator();
            }
        }
        this.generator.initialize(project, info, monitor);
    }

    public void initialize(int buildKind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        this.isusingNinja = builder.getCommand().startsWith("ninja");
        if (this.isusingNinja) {
            boolean bl = this.buildToolChanged = !(this.generator instanceof NativeCoreNinjaFileGenerator);
            if (this.generator == null || this.buildToolChanged) {
                this.generator = new NativeCoreNinjaFileGenerator();
            }
        } else {
            boolean bl = this.buildToolChanged = !(this.generator instanceof NativeCoreNinjaFileGenerator);
            if (this.generator == null || this.buildToolChanged) {
                this.generator = new NativeCoreMakeFileGenerator();
            }
        }
        this.generator.initialize(buildKind, cfg, builder, monitor);
    }

    public void generateDependencies() throws CoreException {
        this.generator.generateDependencies();
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        return this.buildToolChanged ? this.generator.regenerateMakefiles() : this.generator.generateMakefiles(delta);
    }

    public IPath getBuildWorkingDir() {
        return this.generator.getBuildWorkingDir();
    }

    public String getMakefileName() {
        return this.generator.getMakefileName();
    }

    public boolean isGeneratedResource(IResource resource) {
        return this.generator.isGeneratedResource(resource);
    }

    public void regenerateDependencies(boolean force) throws CoreException {
        this.generator.regenerateDependencies(force);
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        return this.generator.regenerateMakefiles();
    }
}

