/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.ProjectUtil;

public class PackageUtil
extends org.tizen.common.util.PackageUtil {
    private static final HashMap<String, String[]> BLOCKED_KEYWORDS = new HashMap();

    static {
        BLOCKED_KEYWORDS.put("Service Application Template", new String[]{"Service"});
    }

    public static boolean validateServiceProjectName(String projectName) {
        return PackageUtil.validateProjectName("Service Application Template", projectName);
    }

    public static boolean validateProjectName(String category, String projectName) {
        Object[] blockedKeywords = BLOCKED_KEYWORDS.get(category);
        return ArrayUtil.isEmpty((Object[])blockedKeywords) || !ArrayUtil.contains((Object[])blockedKeywords, (Object)projectName);
    }

    public static IProject[] getRefLibProjects(IProject project) {
        TizenProjectDescription desc = ProjectUtil.getTizenProjectDescription((IProject)project);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> refProjects = new ArrayList<IProject>();
        if (desc == null) {
            return refProjects.toArray(new IProject[refProjects.size()]);
        }
        Map map = desc.getReferencedLibraryProjectMap();
        if (map == null) {
            return refProjects.toArray(new IProject[refProjects.size()]);
        }
        Set libProjectNameList = map.keySet();
        for (String subProject : libProjectNameList) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (subProject.equals(proj.getName())) {
                    refProjects.add(proj);
                }
                ++n2;
            }
        }
        return refProjects.toArray(new IProject[refProjects.size()]);
    }

    public static IProject[] getRefProjects(IProject project) {
        int n;
        TizenProjectDescription desc = ProjectUtil.getTizenProjectDescription((IProject)project);
        List subProjectList = desc.getSubProjectList();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> refProjects = new HashSet<IProject>();
        for (TizenProjectDescription.RefTizenProject subProject : subProjectList) {
            IProject[] iProjectArray = projects;
            n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (subProject.getName().equals(proj.getName())) {
                    refProjects.add(proj);
                }
                ++n2;
            }
        }
        Set libProjectNameList = desc.getReferencedLibraryProjectMap().keySet();
        for (String subProject : libProjectNameList) {
            IProject[] iProjectArray = projects;
            int n3 = projects.length;
            n = 0;
            while (n < n3) {
                IProject proj = iProjectArray[n];
                if (subProject.equals(proj.getName())) {
                    refProjects.add(proj);
                }
                ++n;
            }
        }
        return refProjects.toArray(new IProject[refProjects.size()]);
    }
}

