/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.PlatformTemplateLoader;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.EntryDescriptorPlatformMap;
import org.tizen.nativeappcommon.wizards.TemplateTizenNewWizard;
import org.w3c.dom.Element;

public class TemplateTizenCoreNewWizard
extends TemplateTizenNewWizard {
    private static final Map<String, String> PROJECT_TYPE_MAP = new HashMap<String, String>();
    public static final String APP_PROJECT_TYPE = "org.tizen.nativecore.buildArtefactType.app";
    public static final String APP_TEMPLATE_ID = "TizenCoreApplicationProject";
    public static final String APP_CATEGORY = "Application Template";
    public static final String SERVICE_APP_CATEGORY = "Service Application Template";
    public static final String STATIC_PROJECT_TYPE = "org.tizen.nativecore.buildArtefactType.staticLib";
    public static final String STATIC_TEMPLATE_ID = "TizenCoreSimpleStaticLibraryProject";
    public static final String SHARED_PROJECT_TYPE = "org.tizen.nativecore.buildArtefactType.sharedLib";
    public static final String SHARED_TEMPLATE_ID = "TizenCoreSimpleSharedLibraryProject";
    public static final IPath templatePath = new Path(InstallPathConfig.getSamplesPath()).append("native").append("core");

    static {
        PROJECT_TYPE_MAP.put(APP_PROJECT_TYPE, APP_TEMPLATE_ID);
        PROJECT_TYPE_MAP.put(STATIC_PROJECT_TYPE, STATIC_TEMPLATE_ID);
        PROJECT_TYPE_MAP.put(SHARED_PROJECT_TYPE, SHARED_TEMPLATE_ID);
    }

    public EntryDescriptor[] createItems(boolean supportedOnly, IWizard wizard) {
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        PlatformTemplateLoader templateLoader = new PlatformTemplateLoader("native" + File.separator + "core", "sample.xml");
        Map platformTemplateMap = templateLoader.loadPlatformSamples();
        for (ProfileInfo profileInfo : platformTemplateMap.keySet()) {
            IPath rootPath = new Path(InstallPathConfig.getSamplesPath((ProfileInfo)profileInfo, (String)profileInfo.getLatestPlatformVersion())).append("native").append("core");
            for (File sampleFile : (List)platformTemplateMap.get(profileInfo)) {
                Path templatePath = new Path(sampleFile.getPath());
                TemplateDescriptor templateDesc = TizenTemplateProcessParser.createTemplateDesc((File)sampleFile);
                if (templateDesc == null) continue;
                EntryDescriptor entryDes = this.getEntryDesc(templateDesc, templatePath.removeLastSegments(1).lastSegment());
                IPath sourcePath = templatePath.removeLastSegments(1);
                if (sourcePath.segmentCount() != rootPath.segmentCount()) {
                    entryDes.setPath(templatePath.removeLastSegments(2).makeRelativeTo(rootPath).toString());
                } else {
                    entryDes.setPath(null);
                }
                EntryDescriptorPlatformMap.getInstance().put(entryDes, profileInfo);
                items.add(entryDes);
            }
        }
        return items.toArray(new EntryDescriptor[items.size()]);
    }

    public IPath getTemplatePath() {
        return templatePath;
    }

    public String getTemplateID(String projTypeName) {
        String templateId = PROJECT_TYPE_MAP.get(projTypeName);
        return templateId;
    }

    public EntryDescriptor getEntryDesc(TemplateDescriptor descriptor, String label) {
        Element root = descriptor.getRootElement();
        Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag((Element)root, (String)"slp-property");
        slpPropertyElement = TizenTemplateProcessParser.getElementFromTag((Element)slpPropertyElement, (String)"property-group");
        String projTypeName = TizenTemplateProcessParser.getTextContextFromElement((Element)slpPropertyElement, (String)"project-type");
        return new EntryDescriptor(this.getTemplateID(projTypeName), projTypeName, label, false, null, null);
    }

    public EntryDescriptor getEntryDesc(String projectType, String label) {
        if (projectType == null) {
            return null;
        }
        return new EntryDescriptor(this.getTemplateID(projectType), projectType, label, false, null, null);
    }
}

